/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.util;

import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.herac.tuxguitar.gui.TuxGuitar;

public class TuxGuitarFileUtils {
    private static final String APP_CONFIG_DOMAIN = ".tuxguitar";
    private static final String APP_CONFIG_DOMAIN_ENV_VAR = "TUXGUITAR_CONFIG_HOME";
    private static final String SYSTEM_SHARED_PROPERTY = "tuxguitar.shared.path";
    public static final String USER_CONFIG_PREFIX = TuxGuitarFileUtils.getUserConfigDir();
    public static final String IMAGE_PREFIX = TuxGuitarFileUtils.getRealPath("files");
    public static final String LANGUAGE_PREFIX = TuxGuitarFileUtils.getRealPath("lang");
    public static final String PLUGINS_PREFIX = TuxGuitarFileUtils.getRealPath("plugins");
    public static final String SCALES_PREFIX = TuxGuitarFileUtils.getRealPath("scales");

    public static Image loadImage(String string) {
        if (IMAGE_PREFIX != null) {
            try {
                return new Image((Device)TuxGuitar.instance().getDisplay(), new ImageData(IMAGE_PREFIX + string));
            }
            catch (Exception exception) {
                System.err.println(IMAGE_PREFIX + string + ": not found");
            }
        }
        return new Image((Device)TuxGuitar.instance().getDisplay(), 16, 16);
    }

    public static String getRealPath(String string) {
        String string2 = null;
        String string3 = System.getProperty(SYSTEM_SHARED_PROPERTY);
        string2 = string3 != null ? string3 + System.getProperty("file.separator") + string : TuxGuitarFileUtils.getResourcePath(string);
        if (string2 != null) {
            return new File(string2).getAbsolutePath() + System.getProperty("file.separator");
        }
        return null;
    }

    public static String getResourcePath(String string) {
        URL uRL = TuxGuitarFileUtils.class.getClassLoader().getResource(string);
        try {
            if (uRL != null) {
                return URLDecoder.decode(uRL.getPath(), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return null;
    }

    public static InputStream getResourceAsStream(String string) {
        return TuxGuitarFileUtils.class.getClassLoader().getResourceAsStream(string);
    }

    public static String getUserConfigDir() {
        File file;
        String string = null;
        try {
            string = System.getenv(APP_CONFIG_DOMAIN_ENV_VAR);
        }
        catch (Error error) {
            // empty catch block
        }
        if (string == null) {
            string = System.getProperty("user.home") + System.getProperty("file.separator") + APP_CONFIG_DOMAIN;
        }
        if (!(file = new File(string)).exists()) {
            file.mkdirs();
        }
        return string;
    }
}

