/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.util;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;

public class SplashShell {
    private Shell shell;

    public SplashShell(Display display) {
        if (TuxGuitar.instance().getConfig().getBooleanConfigValue("show.splash")) {
            this.open(display);
        }
    }

    private void open(Display display) {
        final Image image = SystemImages.TUXGUITAR_SPLASH;
        int n = image.getBounds().width;
        int n2 = image.getBounds().height;
        int n3 = (display.getBounds().width - display.getBounds().x) / 2 - n / 2;
        int n4 = (display.getBounds().height - display.getBounds().y) / 2 - n2 / 2;
        this.shell = new Shell(display, 262152);
        this.shell.setBounds(n3, n4, n, n2);
        this.shell.setImage(SystemImages.TUXGUITAR_ICON);
        this.shell.setText(TuxGuitar.getProperty("tuxguitar.title"));
        this.shell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                paintEvent.gc.drawImage(image, 0, 0);
            }
        });
        this.shell.open();
    }

    public void close() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.close();
            this.shell.dispose();
        }
    }
}

