/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.util;

import java.io.File;

public class ArgumentParser {
    private final String[] OPTION_HELP = new String[]{"-h", "--help"};
    private String[] arguments;
    private boolean printAndExit;
    private File file;

    public ArgumentParser(String[] stringArray) {
        this.arguments = stringArray;
        this.printAndExit = false;
        this.parse();
    }

    private void parse() {
        this.checkHelp();
        if (!this.printAndExit()) {
            this.checkFile();
        }
    }

    private void checkHelp() {
        for (int i = 0; i < this.arguments.length; ++i) {
            for (int j = 0; j < this.OPTION_HELP.length; ++j) {
                if (!this.arguments[i].equals(this.OPTION_HELP[j])) continue;
                System.out.println("usage: TuxGuitar [file]");
                System.out.println("Options:");
                System.out.println("\t-h, --help                 Give this help list");
                this.printAndExit = true;
            }
        }
    }

    private void checkFile() {
        for (int i = 0; i < this.arguments.length; ++i) {
            File file = new File(this.arguments[i]);
            if (!file.exists()) continue;
            this.file = file;
            break;
        }
    }

    public boolean printAndExit() {
        return this.printAndExit;
    }

    public File getFile() {
        return this.file;
    }
}

