/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.custom;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.SongCoords;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.TimeSignature;

public class UndoableChangeTimeSignature
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private long position;
    private TimeSignature redoableTimeSignature;
    private TimeSignature undoableTimeSignature;
    private List nextTimeSignaturePositions;
    private boolean toEnd;

    private UndoableChangeTimeSignature() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TuxGuitar.instance().getSongManager().changeTimeSignature(this.position, (TimeSignature)this.redoableTimeSignature.clone(), this.toEnd);
        TuxGuitar.instance().fireUpdate();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        SongCoords songCoords = UndoableChangeTimeSignature.getCaret().getSongCoords();
        TuxGuitar.instance().getSongManager().changeTimeSignature(this.position, (TimeSignature)this.undoableTimeSignature.clone(), this.toEnd);
        if (this.toEnd) {
            for (TimeSignaturePosition timeSignaturePosition : this.nextTimeSignaturePositions) {
                TuxGuitar.instance().getSongManager().changeTimeSignature(timeSignaturePosition.getPosition(), (TimeSignature)timeSignaturePosition.getTimeSignature().clone(), true);
            }
        }
        TuxGuitar.instance().fireUpdate();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableChangeTimeSignature startUndo() {
        UndoableChangeTimeSignature undoableChangeTimeSignature = new UndoableChangeTimeSignature();
        Caret caret = UndoableChangeTimeSignature.getCaret();
        undoableChangeTimeSignature.doAction = 1;
        undoableChangeTimeSignature.undoCaret = new UndoableCaretHelper();
        undoableChangeTimeSignature.position = caret.getPosition();
        undoableChangeTimeSignature.undoableTimeSignature = (TimeSignature)caret.getMeasureCoords().getMeasure().getTimeSignature().clone();
        undoableChangeTimeSignature.nextTimeSignaturePositions = new ArrayList();
        TimeSignature timeSignature = undoableChangeTimeSignature.undoableTimeSignature;
        for (MeasureCoords measureCoords : caret.getSongCoords().getFirstTrack().getMeasuresCoords()) {
            if (measureCoords.getMeasure().getStart() <= undoableChangeTimeSignature.position) continue;
            TimeSignature timeSignature2 = measureCoords.getMeasure().getTimeSignature();
            int n = timeSignature.getNumerator();
            int n2 = timeSignature.getDenominator().getValue();
            int n3 = timeSignature2.getNumerator();
            int n4 = timeSignature2.getDenominator().getValue();
            if (n != n3 || n2 != n4) {
                UndoableChangeTimeSignature undoableChangeTimeSignature2 = undoableChangeTimeSignature;
                undoableChangeTimeSignature2.getClass();
                TimeSignaturePosition timeSignaturePosition = undoableChangeTimeSignature2.new TimeSignaturePosition(measureCoords.getMeasure().getStart(), (TimeSignature)timeSignature2.clone());
                undoableChangeTimeSignature.nextTimeSignaturePositions.add(timeSignaturePosition);
            }
            timeSignature = timeSignature2;
        }
        return undoableChangeTimeSignature;
    }

    public UndoableChangeTimeSignature endUndo(TimeSignature timeSignature, boolean bl) {
        this.redoCaret = new UndoableCaretHelper();
        this.redoableTimeSignature = (TimeSignature)timeSignature.clone();
        this.toEnd = bl;
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }

    private class TimeSignaturePosition {
        private long position;
        private TimeSignature timeSignature;

        public TimeSignaturePosition(long l, TimeSignature timeSignature) {
            this.position = l;
            this.timeSignature = timeSignature;
        }

        public long getPosition() {
            return this.position;
        }

        public TimeSignature getTimeSignature() {
            return this.timeSignature;
        }
    }
}

