/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo.undoables.custom;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.SongCoords;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.SongTrack;

public class UndoableChangeClef
implements UndoableEdit {
    private int doAction;
    private UndoableCaretHelper undoCaret;
    private UndoableCaretHelper redoCaret;
    private long position;
    private int redoableClef;
    private int undoableClef;
    private List nextClefPositions;
    private boolean toEnd;
    private SongTrack track;

    private UndoableChangeClef() {
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        TuxGuitar.instance().getSongManager().getTrackManager().changeClef(this.track, this.position, this.redoableClef, this.toEnd);
        TuxGuitar.instance().fireUpdate();
        this.redoCaret.update();
        this.doAction = 1;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        SongCoords songCoords = UndoableChangeClef.getCaret().getSongCoords();
        TuxGuitar.instance().getSongManager().getTrackManager().changeClef(this.track, this.position, this.undoableClef, this.toEnd);
        if (this.toEnd) {
            for (ClefPosition clefPosition : this.nextClefPositions) {
                TuxGuitar.instance().getSongManager().getTrackManager().changeClef(this.track, clefPosition.getPosition(), clefPosition.getClef(), true);
            }
        }
        TuxGuitar.instance().fireUpdate();
        this.undoCaret.update();
        this.doAction = 2;
    }

    public boolean canRedo() {
        return this.doAction == 2;
    }

    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static UndoableChangeClef startUndo() {
        UndoableChangeClef undoableChangeClef = new UndoableChangeClef();
        Caret caret = UndoableChangeClef.getCaret();
        undoableChangeClef.doAction = 1;
        undoableChangeClef.undoCaret = new UndoableCaretHelper();
        undoableChangeClef.position = caret.getPosition();
        undoableChangeClef.undoableClef = caret.getMeasureCoords().getMeasure().getClef();
        undoableChangeClef.track = caret.getSongTrackCoords().getTrack();
        undoableChangeClef.nextClefPositions = new ArrayList();
        int n = undoableChangeClef.undoableClef;
        for (MeasureCoords measureCoords : caret.getSongTrackCoords().getMeasuresCoords()) {
            if (measureCoords.getMeasure().getStart() <= undoableChangeClef.position) continue;
            int n2 = measureCoords.getMeasure().getClef();
            if (n != n2) {
                UndoableChangeClef undoableChangeClef2 = undoableChangeClef;
                undoableChangeClef2.getClass();
                ClefPosition clefPosition = undoableChangeClef2.new ClefPosition(measureCoords.getMeasure().getStart(), n2);
                undoableChangeClef.nextClefPositions.add(clefPosition);
            }
            n = n2;
        }
        return undoableChangeClef;
    }

    public UndoableChangeClef endUndo(int n, boolean bl) {
        this.redoCaret = new UndoableCaretHelper();
        this.redoableClef = n;
        this.toEnd = bl;
        return this;
    }

    private static Caret getCaret() {
        return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }

    private class ClefPosition {
        private long position;
        private int clef;

        public ClefPosition(long l, int n) {
            this.position = l;
            this.clef = n;
        }

        public long getPosition() {
            return this.position;
        }

        public int getClef() {
            return this.clef;
        }
    }
}

