/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;

public class UndoManager {
    private static final int LIMIT = 100;
    private int indexOfNextAdd;
    private List edits;

    public UndoManager() {
        this.init();
    }

    public void discardAllEdits() {
        this.reset();
    }

    public synchronized void undo() throws CannotUndoException {
        UndoableEdit undoableEdit = this.editToBeUndone();
        if (undoableEdit == null) {
            throw new CannotUndoException();
        }
        undoableEdit.undo();
        --this.indexOfNextAdd;
    }

    public synchronized void redo() throws CannotRedoException {
        UndoableEdit undoableEdit = this.editToBeRedone();
        if (undoableEdit == null) {
            throw new CannotRedoException();
        }
        undoableEdit.redo();
        ++this.indexOfNextAdd;
    }

    public synchronized boolean canUndo() {
        boolean bl = false;
        UndoableEdit undoableEdit = this.editToBeUndone();
        if (undoableEdit != null) {
            bl = undoableEdit.canUndo();
        }
        return bl;
    }

    public synchronized boolean canRedo() {
        boolean bl = false;
        UndoableEdit undoableEdit = this.editToBeRedone();
        if (undoableEdit != null) {
            bl = undoableEdit.canRedo();
        }
        return bl;
    }

    public synchronized void addEdit(UndoableEdit undoableEdit) {
        this.checkForUnused();
        this.checkForLimit();
        this.edits.add(this.indexOfNextAdd, undoableEdit);
        ++this.indexOfNextAdd;
    }

    public boolean shift() {
        if (!this.edits.isEmpty()) {
            UndoableEdit undoableEdit = (UndoableEdit)this.edits.get(0);
            this.remove(undoableEdit);
            --this.indexOfNextAdd;
            return true;
        }
        return false;
    }

    private void checkForUnused() {
        while (this.edits.size() > this.indexOfNextAdd) {
            UndoableEdit undoableEdit = (UndoableEdit)this.edits.get(this.indexOfNextAdd);
            this.remove(undoableEdit);
        }
    }

    private void checkForLimit() {
        while (this.edits.size() >= 100) {
            UndoableEdit undoableEdit = (UndoableEdit)this.edits.get(0);
            this.remove(undoableEdit);
            --this.indexOfNextAdd;
        }
    }

    private void remove(UndoableEdit undoableEdit) {
        this.edits.remove(undoableEdit);
    }

    private UndoableEdit editToBeUndone() {
        int n = this.indexOfNextAdd - 1;
        if (n >= 0 && n < this.edits.size()) {
            return (UndoableEdit)this.edits.get(n);
        }
        return null;
    }

    private UndoableEdit editToBeRedone() {
        int n = this.indexOfNextAdd;
        if (n >= 0 && n < this.edits.size()) {
            return (UndoableEdit)this.edits.get(n);
        }
        return null;
    }

    private void init() {
        this.indexOfNextAdd = 0;
        this.edits = new ArrayList();
    }

    private void reset() {
        this.indexOfNextAdd = 0;
        this.edits.clear();
    }
}

