/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.plugins.TGPlugin;
import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;

public class PluginManager {
    public static final String PROPERTY_PLUGIN_PATH = "plugin.path";
    public static final String PROPERTY_PLUGIN_CLASS = "plugin.class";
    private static final String LANGUAGE_FOLDER = "lang";
    private List plugins = new ArrayList();
    private List pluginItems = new ArrayList();

    public List getPlugins() {
        return this.plugins;
    }

    public List getPluginItems() {
        return this.pluginItems;
    }

    public void loadPlugins() {
        File file;
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.indexOf("plugin_") != -1 && string.indexOf(".properties") != -1;
            }
        };
        String string = TuxGuitarFileUtils.PLUGINS_PREFIX;
        if (string != null && (file = new File(string)) != null && file.exists()) {
            String[] stringArray = file.list(filenameFilter);
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    this.loadPLugin(string + File.separator + stringArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                catch (Error error) {
                    error.printStackTrace();
                }
            }
        }
    }

    private void loadPLugin(String string) throws FileNotFoundException, IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        try {
            Object obj;
            Class<?> clazz;
            URLClassLoader uRLClassLoader;
            Properties properties = new Properties();
            properties.load(new FileInputStream(string));
            String string2 = properties.getProperty(PROPERTY_PLUGIN_PATH, new String());
            String string3 = properties.getProperty(PROPERTY_PLUGIN_CLASS, new String());
            File file = new File(string2);
            if (file != null && file.exists() && (uRLClassLoader = new URLClassLoader(new URL[]{new File(string2).toURL()}, this.getClass().getClassLoader())) != null && (clazz = uRLClassLoader.loadClass(string3)) != null && (obj = clazz.newInstance()) instanceof TGPlugin) {
                TGPlugin tGPlugin = (TGPlugin)obj;
                this.plugins.add(tGPlugin);
                if (tGPlugin.getItem().isEnabled()) {
                    this.pluginItems.add(tGPlugin);
                }
            }
        }
        catch (Exception exception) {
            TuxGuitar.instance().showErrorMessage(exception);
        }
        catch (Error error) {
            TuxGuitar.instance().showErrorMessage(error);
        }
    }

    public void initPLugins() {
        Iterator iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            try {
                TGPlugin tGPlugin = (TGPlugin)iterator.next();
                tGPlugin.init(TuxGuitar.instance());
            }
            catch (Exception exception) {
                TuxGuitar.instance().showErrorMessage(exception);
            }
            catch (Error error) {
                TuxGuitar.instance().showErrorMessage(error);
            }
        }
    }

    public void closePLugins() {
        Iterator iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            try {
                TGPlugin tGPlugin = (TGPlugin)iterator.next();
                tGPlugin.close();
            }
            catch (Exception exception) {
                TuxGuitar.instance().showErrorMessage(exception);
            }
            catch (Error error) {
                TuxGuitar.instance().showErrorMessage(error);
            }
        }
    }
}

