/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.language;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Locale;
import java.util.ResourceBundle;
import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;

public class LanguageManager {
    private ResourceBundle resources;
    private String[] languages;

    public LanguageManager() {
        this.loadLanguages();
    }

    public void setLanguage(String string) {
        try {
            this.resources = string == null || string.length() == 0 ? ResourceBundle.getBundle("lang.messages") : ResourceBundle.getBundle("lang.messages", new Locale(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getProperty(String string) {
        String string2 = null;
        try {
            string2 = this.resources.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
            System.out.println(string2);
        }
        return string2;
    }

    public String getLanguage() {
        if (this.resources != null) {
            return this.resources.getLocale().getLanguage();
        }
        return null;
    }

    public String[] getLanguages() {
        return this.languages;
    }

    private void loadLanguages() {
        File file;
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.indexOf("messages_") != -1 && string.indexOf(".properties") != -1;
            }
        };
        String string = TuxGuitarFileUtils.LANGUAGE_PREFIX;
        if (string != null && (file = new File(string)) != null) {
            String[] stringArray = file.list(filenameFilter);
            this.languages = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].indexOf("messages_") == -1) continue;
                this.languages[i] = stringArray[i].substring(9, 11);
            }
        }
    }
}

