/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config.items;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.config.ConfigEditor;
import org.herac.tuxguitar.gui.system.config.items.Option;

public class StylesOption
extends Option {
    private static final int BUTTON_WIDTH = 85;
    private static final int BUTTON_HEIGHT = 30;
    private FontData defaultFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue("font.default");
    private FontData noteFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue("font.note");
    private FontData timeSignatureFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue("font.time-signature");
    private FontData printerDefaultFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue("font.printer.default");
    private FontData printerNoteFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue("font.printer.note");
    private FontData printerTimeSignatureFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue("font.printer.time-signature");
    private RGB scoreNoteRGB = TuxGuitar.instance().getConfig().getRGBConfigValue("color.score.note");
    private RGB tabNoteRGB = TuxGuitar.instance().getConfig().getRGBConfigValue("color.tab.note");
    private RGB playNoteRGB = TuxGuitar.instance().getConfig().getRGBConfigValue("color.play.note");
    private RGB linesRGB = TuxGuitar.instance().getConfig().getRGBConfigValue("color.line");

    public StylesOption(ConfigEditor configEditor, ToolBar toolBar, Composite composite) {
        super(configEditor, toolBar, composite, TuxGuitar.getProperty("settings.config.styles"));
        if (this.scoreNoteRGB == null) {
            this.scoreNoteRGB = TuxGuitar.instance().getTablatureEditor().getTablature().getScoreNoteColor().getRGB();
        }
        if (this.tabNoteRGB == null) {
            this.tabNoteRGB = TuxGuitar.instance().getTablatureEditor().getTablature().getTabNoteColor().getRGB();
        }
        if (this.playNoteRGB == null) {
            this.playNoteRGB = TuxGuitar.instance().getTablatureEditor().getTablature().getPlayNoteColor().getRGB();
        }
        if (this.linesRGB == null) {
            this.linesRGB = TuxGuitar.instance().getTablatureEditor().getTablature().getLineColor().getRGB();
        }
    }

    public void createOption() {
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.styles"));
        this.getToolItem().setImage(SystemImages.OPTION_STYLE);
        this.getToolItem().addSelectionListener(this);
        Composite composite = new Composite(this.getComposite(), 0);
        composite.setLayout(new GridLayout(2, false));
        composite.setLayoutData(new GridData(4, 4, true, true));
        this.showLabel(composite, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.default"));
        Button button = new Button(composite, 8);
        button.setLayoutData(this.makeButtonData());
        button.setText(TuxGuitar.getProperty("choose"));
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object;
                FontData[] fontDataArray = null;
                if (StylesOption.this.defaultFontData != null) {
                    object = new Font((Device)StylesOption.this.getDisplay(), StylesOption.this.defaultFontData);
                    fontDataArray = ((Font)object).getFontData();
                    ((Font)object).dispose();
                }
                if (fontDataArray == null) {
                    fontDataArray = TuxGuitar.instance().getTablatureEditor().getTablature().getDefaultFont().getFontData();
                }
                object = new FontDialog(StylesOption.this.getShell());
                ((FontDialog)object).setFontList(fontDataArray);
                FontData fontData = ((FontDialog)object).open();
                if (fontData != null) {
                    StylesOption.this.defaultFontData = fontData;
                }
            }
        });
        this.showLabel(composite, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.note"));
        Button button2 = new Button(composite, 8);
        button2.setLayoutData(this.makeButtonData());
        button2.setText(TuxGuitar.getProperty("choose"));
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object;
                FontData[] fontDataArray = null;
                if (StylesOption.this.noteFontData != null) {
                    object = new Font((Device)StylesOption.this.getDisplay(), StylesOption.this.noteFontData);
                    fontDataArray = ((Font)object).getFontData();
                    ((Font)object).dispose();
                }
                if (fontDataArray == null) {
                    fontDataArray = TuxGuitar.instance().getTablatureEditor().getTablature().getNoteFont().getFontData();
                }
                object = new FontDialog(StylesOption.this.getShell());
                ((FontDialog)object).setFontList(fontDataArray);
                FontData fontData = ((FontDialog)object).open();
                if (fontData != null) {
                    StylesOption.this.noteFontData = fontData;
                }
            }
        });
        this.showLabel(composite, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.time-signature"));
        Button button3 = new Button(composite, 8);
        button3.setLayoutData(this.makeButtonData());
        button3.setText(TuxGuitar.getProperty("choose"));
        button3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object;
                FontData[] fontDataArray = null;
                if (StylesOption.this.timeSignatureFontData != null) {
                    object = new Font((Device)StylesOption.this.getDisplay(), StylesOption.this.timeSignatureFontData);
                    fontDataArray = ((Font)object).getFontData();
                    ((Font)object).dispose();
                }
                if (fontDataArray == null) {
                    fontDataArray = TuxGuitar.instance().getTablatureEditor().getTablature().getTimeSignatureFont().getFontData();
                }
                object = new FontDialog(StylesOption.this.getShell());
                ((FontDialog)object).setFontList(fontDataArray);
                FontData fontData = ((FontDialog)object).open();
                if (fontData != null) {
                    StylesOption.this.timeSignatureFontData = fontData;
                }
            }
        });
        this.showLabel(composite, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.printer-default"));
        Button button4 = new Button(composite, 8);
        button4.setLayoutData(this.makeButtonData());
        button4.setText(TuxGuitar.getProperty("choose"));
        button4.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object;
                FontData[] fontDataArray = null;
                if (StylesOption.this.printerDefaultFontData != null) {
                    object = new Font((Device)StylesOption.this.getDisplay(), StylesOption.this.printerDefaultFontData);
                    fontDataArray = ((Font)object).getFontData();
                    ((Font)object).dispose();
                }
                if (fontDataArray == null) {
                    fontDataArray = TuxGuitar.instance().getTablatureEditor().getTablature().getPrinterDefaultFont().getFontData();
                }
                object = new FontDialog(StylesOption.this.getShell());
                ((FontDialog)object).setFontList(fontDataArray);
                FontData fontData = ((FontDialog)object).open();
                if (fontData != null) {
                    StylesOption.this.printerDefaultFontData = fontData;
                }
            }
        });
        this.showLabel(composite, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.printer-note"));
        Button button5 = new Button(composite, 8);
        button5.setLayoutData(this.makeButtonData());
        button5.setText(TuxGuitar.getProperty("choose"));
        button5.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object;
                FontData[] fontDataArray = null;
                if (StylesOption.this.printerNoteFontData != null) {
                    object = new Font((Device)StylesOption.this.getDisplay(), StylesOption.this.printerNoteFontData);
                    fontDataArray = ((Font)object).getFontData();
                    ((Font)object).dispose();
                }
                if (fontDataArray == null) {
                    fontDataArray = TuxGuitar.instance().getTablatureEditor().getTablature().getPrinterNoteFont().getFontData();
                }
                object = new FontDialog(StylesOption.this.getShell());
                ((FontDialog)object).setFontList(fontDataArray);
                FontData fontData = ((FontDialog)object).open();
                if (fontData != null) {
                    StylesOption.this.printerNoteFontData = fontData;
                }
            }
        });
        this.showLabel(composite, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.font.printer-time-signature"));
        Button button6 = new Button(composite, 8);
        button6.setLayoutData(this.makeButtonData());
        button6.setText(TuxGuitar.getProperty("choose"));
        button6.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object;
                FontData[] fontDataArray = null;
                if (StylesOption.this.printerTimeSignatureFontData != null) {
                    object = new Font((Device)StylesOption.this.getDisplay(), StylesOption.this.printerTimeSignatureFontData);
                    fontDataArray = ((Font)object).getFontData();
                    ((Font)object).dispose();
                }
                if (fontDataArray == null) {
                    fontDataArray = TuxGuitar.instance().getTablatureEditor().getTablature().getPrinterTimeSignatureFont().getFontData();
                }
                object = new FontDialog(StylesOption.this.getShell());
                ((FontDialog)object).setFontList(fontDataArray);
                FontData fontData = ((FontDialog)object).open();
                if (fontData != null) {
                    StylesOption.this.printerTimeSignatureFontData = fontData;
                }
            }
        });
        this.showLabel(composite, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.color.score-note"));
        final Button button7 = new Button(composite, 8);
        button7.setLayoutData(this.makeButtonData());
        this.setButtonColor(button7, this.scoreNoteRGB);
        button7.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorDialog colorDialog = new ColorDialog(StylesOption.this.getShell());
                colorDialog.setRGB(StylesOption.this.getDisplay().getSystemColor(2).getRGB());
                colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    StylesOption.this.scoreNoteRGB = new RGB(rGB.red, rGB.green, rGB.blue);
                    StylesOption.this.setButtonColor(button7, rGB);
                }
            }
        });
        this.showLabel(composite, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.color.tab-note"));
        final Button button8 = new Button(composite, 8);
        button8.setLayoutData(this.makeButtonData());
        this.setButtonColor(button8, this.tabNoteRGB);
        button8.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorDialog colorDialog = new ColorDialog(StylesOption.this.getShell());
                colorDialog.setRGB(StylesOption.this.getDisplay().getSystemColor(2).getRGB());
                colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    StylesOption.this.tabNoteRGB = new RGB(rGB.red, rGB.green, rGB.blue);
                    StylesOption.this.setButtonColor(button8, rGB);
                }
            }
        });
        this.showLabel(composite, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.color.play-note"));
        final Button button9 = new Button(composite, 8);
        button9.setLayoutData(this.makeButtonData());
        this.setButtonColor(button9, this.playNoteRGB);
        button9.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorDialog colorDialog = new ColorDialog(StylesOption.this.getShell());
                colorDialog.setRGB(StylesOption.this.getDisplay().getSystemColor(2).getRGB());
                colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    StylesOption.this.playNoteRGB = new RGB(rGB.red, rGB.green, rGB.blue);
                    StylesOption.this.setButtonColor(button9, rGB);
                }
            }
        });
        this.showLabel(composite, 16448, 0, 0, TuxGuitar.getProperty("settings.config.styles.color.lines"));
        final Button button10 = new Button(composite, 8);
        button10.setLayoutData(this.makeButtonData());
        this.setButtonColor(button10, this.linesRGB);
        button10.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorDialog colorDialog = new ColorDialog(StylesOption.this.getShell());
                colorDialog.setRGB(StylesOption.this.getDisplay().getSystemColor(2).getRGB());
                colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    StylesOption.this.linesRGB = new RGB(rGB.red, rGB.green, rGB.blue);
                    StylesOption.this.setButtonColor(button10, rGB);
                }
            }
        });
    }

    public GridData makeButtonData() {
        GridData gridData = new GridData(131072, 0x1000000, true, true);
        gridData.minimumWidth = 85;
        gridData.minimumHeight = 30;
        return gridData;
    }

    private void setButtonColor(Button button, RGB rGB) {
        Color color = new Color(this.getDisplay(), rGB);
        Image image = new Image((Device)this.getDisplay(), 75, 20);
        GC gC = new GC(image);
        gC.setBackground(color);
        gC.fillRectangle(0, 0, 75, 20);
        gC.dispose();
        button.setImage(image);
    }

    public void updateConfig() {
        if (this.defaultFontData != null) {
            this.getConfig().setProperty("font.default", this.defaultFontData.getName() + "," + this.defaultFontData.getHeight() + "," + this.defaultFontData.getStyle());
        }
        if (this.noteFontData != null) {
            this.getConfig().setProperty("font.note", this.noteFontData.getName() + "," + this.noteFontData.getHeight() + "," + this.noteFontData.getStyle());
        }
        if (this.timeSignatureFontData != null) {
            this.getConfig().setProperty("font.time-signature", this.timeSignatureFontData.getName() + "," + this.timeSignatureFontData.getHeight() + "," + this.timeSignatureFontData.getStyle());
        }
        if (this.printerDefaultFontData != null) {
            this.getConfig().setProperty("font.printer.default", this.printerDefaultFontData.getName() + "," + this.printerDefaultFontData.getHeight() + "," + this.printerDefaultFontData.getStyle());
        }
        if (this.printerNoteFontData != null) {
            this.getConfig().setProperty("font.printer.note", this.printerNoteFontData.getName() + "," + this.printerNoteFontData.getHeight() + "," + this.printerNoteFontData.getStyle());
        }
        if (this.printerTimeSignatureFontData != null) {
            this.getConfig().setProperty("font.printer.time-signature", this.printerTimeSignatureFontData.getName() + "," + this.printerTimeSignatureFontData.getHeight() + "," + this.printerTimeSignatureFontData.getStyle());
        }
        if (this.scoreNoteRGB != null) {
            this.getConfig().setProperty("color.score.note", this.scoreNoteRGB.red + "," + this.scoreNoteRGB.green + "," + this.scoreNoteRGB.blue);
        }
        if (this.tabNoteRGB != null) {
            this.getConfig().setProperty("color.tab.note", this.tabNoteRGB.red + "," + this.tabNoteRGB.green + "," + this.tabNoteRGB.blue);
        }
        if (this.playNoteRGB != null) {
            this.getConfig().setProperty("color.play.note", this.playNoteRGB.red + "," + this.playNoteRGB.green + "," + this.playNoteRGB.blue);
        }
        if (this.linesRGB != null) {
            this.getConfig().setProperty("color.line", this.linesRGB.red + "," + this.linesRGB.green + "," + this.linesRGB.blue);
        }
    }

    public void applyConfig(boolean bl) {
        TuxGuitar.instance().loadStyles();
    }
}

