/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config.items;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.system.config.ConfigEditor;
import org.herac.tuxguitar.gui.system.config.ConfigManager;

public abstract class Option
extends SelectionAdapter {
    protected static final int MINIMUN_WIDTH = 500;
    protected static final int DEFAULT_INDENT = 20;
    private ConfigEditor configEditor;
    private ToolBar toolBar;
    private Composite parent;
    private Group group;
    private Composite composite;
    private ToolItem toolItem;

    public Option(ConfigEditor configEditor, ToolBar toolBar, Composite composite, String string, int n, int n2) {
        this.configEditor = configEditor;
        this.toolBar = toolBar;
        this.parent = composite;
        this.toolItem = new ToolItem(toolBar, 16);
        this.group = new Group(composite, 16);
        this.group.setLayout(new GridLayout());
        this.group.setLayoutData(this.getGroupData());
        this.group.setText(string);
        this.composite = new Composite(this.group, 16);
        this.composite.setLayout(new GridLayout());
        this.composite.setLayoutData(new GridData(n, n2, true, true));
    }

    public Option(ConfigEditor configEditor, ToolBar toolBar, Composite composite, String string) {
        this(configEditor, toolBar, composite, string, 4, 128);
    }

    public abstract void createOption();

    public abstract void updateConfig();

    public abstract void applyConfig(boolean var1);

    public void setVisible(boolean bl) {
        this.toolItem.setSelection(bl);
        this.group.setVisible(bl);
    }

    protected Label showLabel(Composite composite, int n, int n2, int n3, String string) {
        return this.showLabel(composite, 0x1000000, n, n2, n3, string);
    }

    protected Label showLabel(Composite composite, int n, int n2, int n3, int n4, String string) {
        Label label = new Label(composite, n2);
        label.setText(string);
        label.setLayoutData(new GridData(4, n, true, true));
        FontData[] fontDataArray = label.getFont().getFontData();
        if (fontDataArray.length > 0) {
            Font font = new Font(label.getDisplay(), fontDataArray[0].getName(), fontDataArray[0].getHeight() + n4, n3);
            label.setFont(font);
            font.dispose();
        }
        return label;
    }

    protected Label showImageLabel(Composite composite, int n, Image image) {
        Label label = new Label(composite, n);
        label.setImage(image);
        return label;
    }

    protected FormData getGroupData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        return formData;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.configEditor.select(this);
    }

    public Composite getComposite() {
        return this.composite;
    }

    public ToolItem getToolItem() {
        return this.toolItem;
    }

    public ConfigManager getConfig() {
        return this.configEditor.getConfig();
    }

    public TablatureEditor getEditor() {
        return this.configEditor.getEditor();
    }

    public Display getDisplay() {
        return this.toolBar.getDisplay();
    }

    public Shell getShell() {
        return this.toolBar.getShell();
    }

    public GridData makeGridData(int n, int n2) {
        return this.configEditor.makeGridData(n, n2);
    }

    public GridData makeGridData(int n, int n2, int n3, int n4) {
        return this.configEditor.makeGridData(n, n2, n3, n4);
    }

    protected GridData getTabbedData() {
        return this.getTabbedData(20, 4, 0x1000000);
    }

    protected GridData getTabbedData(int n, int n2) {
        return this.getTabbedData(20, n, n2);
    }

    protected GridData getTabbedData(int n, int n2, int n3) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = n2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = n3;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalIndent = n;
        return gridData;
    }

    public GridData makeGridData(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, int n7, int n8) {
        GridData gridData = new GridData();
        gridData.widthHint = n;
        gridData.heightHint = n2;
        gridData.minimumWidth = n3;
        gridData.minimumHeight = n4;
        gridData.horizontalAlignment = n5;
        gridData.verticalAlignment = n6;
        gridData.grabExcessHorizontalSpace = bl;
        gridData.horizontalSpan = n7;
        gridData.verticalSpan = n8;
        return gridData;
    }
}

