/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config.items;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.config.ConfigEditor;
import org.herac.tuxguitar.gui.system.config.items.Option;
import org.herac.tuxguitar.gui.util.WindowTitleUtil;

public class MainOption
extends Option {
    private Button showSplash;
    private Text windowTitle;

    public MainOption(ConfigEditor configEditor, ToolBar toolBar, Composite composite) {
        super(configEditor, toolBar, composite, TuxGuitar.getProperty("settings.config.main"));
    }

    public void createOption() {
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.main"));
        this.getToolItem().setImage(SystemImages.OPTION_VIEW);
        this.getToolItem().addSelectionListener(this);
        this.showLabel(this.getComposite(), 16576, 1, 0, TuxGuitar.getProperty("settings.config.main.window-title"));
        Composite composite = new Composite(this.getComposite(), 0);
        composite.setLayout(new GridLayout());
        composite.setLayoutData(this.getTabbedData());
        this.windowTitle = new Text(composite, 2048);
        this.windowTitle.setLayoutData(new GridData(500, -1));
        this.windowTitle.setTextLimit(80);
        this.windowTitle.setText(this.getConfig().getStringConfigValue("window.title"));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout(2, false));
        composite2.setLayoutData(new GridData(4, 4, true, true));
        this.showImageLabel(composite2, 0, composite2.getDisplay().getSystemImage(2));
        this.showLabel(composite2, 16576, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.help"));
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout(new GridLayout(2, false));
        composite3.setLayoutData(new GridData(4, 4, true, true));
        this.showLabel(composite3, 0, 1, -1, WindowTitleUtil.getVar("appname"));
        this.showLabel(composite3, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.appname"));
        this.showLabel(composite3, 0, 1, -1, WindowTitleUtil.getVar("appversion"));
        this.showLabel(composite3, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.appversion"));
        this.showLabel(composite3, 0, 1, -1, WindowTitleUtil.getVar("filename"));
        this.showLabel(composite3, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.filename"));
        this.showLabel(composite3, 0, 1, -1, WindowTitleUtil.getVar("filepath"));
        this.showLabel(composite3, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.filepath"));
        this.showLabel(composite3, 0, 1, -1, WindowTitleUtil.getVar("songname"));
        this.showLabel(composite3, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.songname"));
        this.showLabel(composite3, 0, 1, -1, WindowTitleUtil.getVar("songalbum"));
        this.showLabel(composite3, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.songalbum"));
        this.showLabel(composite3, 0, 1, -1, WindowTitleUtil.getVar("songinterpret"));
        this.showLabel(composite3, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.songinterpret"));
        this.showLabel(composite3, 0, 1, -1, WindowTitleUtil.getVar("songauthor"));
        this.showLabel(composite3, 192, 0, 0, TuxGuitar.getProperty("settings.config.main.window-title.var.description.songauthor"));
        this.showLabel(this.getComposite(), 17472, 1, 0, TuxGuitar.getProperty("settings.config.main.options"));
        Composite composite4 = new Composite(this.getComposite(), 0);
        composite4.setLayout(new GridLayout(2, false));
        composite4.setLayoutData(this.getTabbedData());
        this.showSplash = new Button(composite4, 32);
        this.showSplash.setLayoutData(this.spanData(new GridData(), 2));
        this.showSplash.setText(TuxGuitar.getProperty("settings.config.main.splash-enabled"));
        this.showSplash.setSelection(this.getConfig().getBooleanConfigValue("show.splash"));
    }

    private GridData spanData(GridData gridData, int n) {
        gridData.horizontalSpan = n;
        return gridData;
    }

    public void updateConfig() {
        this.getConfig().setProperty("window.title", this.windowTitle.getText());
        this.getConfig().setProperty("show.splash", this.showSplash.getSelection());
    }

    public void applyConfig(boolean bl) {
        TuxGuitar.instance().showTitle();
    }
}

