/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.herac.tuxguitar.gui.system.config.ConfigDefaults;
import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;

public class ConfigManager {
    private Properties properties = new Properties(new ConfigDefaults().getProperties());

    public void init() {
        this.load();
    }

    private String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public String getStringConfigValue(String string, String string2) {
        String string3 = this.getProperty(string);
        return string3 == null ? string2 : string3.trim();
    }

    public String getStringConfigValue(String string) {
        return this.getStringConfigValue(string, null);
    }

    public int getIntConfigValue(String string, int n) {
        String string2 = this.getProperty(string);
        return string2 == null ? n : Integer.parseInt(string2.trim());
    }

    public int getIntConfigValue(String string) {
        return this.getIntConfigValue(string, 0);
    }

    public boolean getBooleanConfigValue(String string, boolean bl) {
        String string2 = this.getProperty(string);
        return string2 == null ? bl : Boolean.valueOf(string2.trim());
    }

    public boolean getBooleanConfigValue(String string) {
        return this.getBooleanConfigValue(string, false);
    }

    public FontData getFontDataConfigValue(String string) {
        String[] stringArray;
        String string2 = this.getProperty(string);
        if (string2 != null && (stringArray = string2.trim().split(",")) != null && stringArray.length == 3) {
            try {
                String string3 = stringArray[0].trim();
                int n = Integer.parseInt(stringArray[1].trim());
                int n2 = Integer.parseInt(stringArray[2].trim());
                return new FontData(string3, n, n2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public RGB getRGBConfigValue(String string) {
        String[] stringArray;
        String string2 = this.getProperty(string);
        if (string2 != null && (stringArray = string2.trim().split(",")) != null && stringArray.length == 3) {
            try {
                int n = Integer.parseInt(stringArray[0].trim());
                int n2 = Integer.parseInt(stringArray[1].trim());
                int n3 = Integer.parseInt(stringArray[2].trim());
                return new RGB(n, n2, n3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    public void setProperty(String string, int n) {
        this.setProperty(string, Integer.toString(n));
    }

    public void setProperty(String string, boolean bl) {
        this.setProperty(string, Boolean.toString(bl));
    }

    public void setDefaults() {
        Properties properties = new ConfigDefaults().getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        this.save();
    }

    public void removeProperty(String string) {
        this.properties.remove(string);
    }

    public void clear() {
        this.properties.clear();
    }

    public void load() {
        try {
            if (new File(this.getFileName()).exists()) {
                FileInputStream fileInputStream = new FileInputStream(this.getFileName());
                this.properties.clear();
                this.properties.load(fileInputStream);
            } else {
                this.save();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void save() {
        try {
            this.properties.store(new FileOutputStream(this.getFileName()), "System Configuration");
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String getFileName() {
        return TuxGuitarFileUtils.USER_CONFIG_PREFIX + File.separator + "config.properties";
    }
}

