/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.printer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import org.eclipse.swt.graphics.ImageData;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintPage;
import org.herac.tuxguitar.gui.util.ImageUtils;

public class PrintableImpl
implements Printable {
    private PrintDocument document;

    public PrintableImpl(PrintDocument printDocument) {
        this.document = printDocument;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (this.document.count() > n) {
            System.out.println("Printing page: " + n);
            PrintPage printPage = (PrintPage)this.document.getPages().get(n);
            ImageData imageData = printPage.getData();
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n2 = (int)pageFormat.getImageableX();
            int n3 = (int)pageFormat.getImageableY();
            graphics2D.drawImage(ImageUtils.convertToAWT(imageData), null, n2, n3);
            return 0;
        }
        return 1;
    }

    public PrintDocument getPrintDocument() {
        return this.document;
    }
}

