/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.mixer;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.mixer.SongMixer;
import org.herac.tuxguitar.song.models.SongTrack;

public class TrackMixer {
    private SongMixer mixer;
    private SongTrack track;
    private Button soloCheckBox;
    private Button muteCheckBox;
    private Scale balanceScale;
    private Scale volumeScale;
    private Text volumeText;
    private Label channelLabel;
    private Label volumeLabel;

    public TrackMixer(SongMixer songMixer, SongTrack songTrack) {
        this.mixer = songMixer;
        this.track = songTrack;
    }

    public void init(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout(1, true));
        composite2.setLayoutData(new GridData(0x1000000, 4, true, true));
        this.channelLabel = new Label(composite2, 0);
        this.soloCheckBox = new Button(composite2, 32);
        this.soloCheckBox.setSelection(this.track.getChannel().isSolo());
        this.soloCheckBox.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TrackMixer.this.track.getChannel().setSolo(TrackMixer.this.soloCheckBox.getSelection());
                if (TrackMixer.this.track.getChannel().isSolo()) {
                    TrackMixer.this.track.getChannel().setMute(false);
                }
                TrackMixer.this.mixer.fireChanges(TrackMixer.this.track.getChannel());
            }
        });
        this.muteCheckBox = new Button(composite2, 32);
        this.muteCheckBox.setSelection(this.track.getChannel().isMute());
        this.muteCheckBox.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TrackMixer.this.track.getChannel().setMute(TrackMixer.this.muteCheckBox.getSelection());
                if (TrackMixer.this.track.getChannel().isMute()) {
                    TrackMixer.this.track.getChannel().setSolo(false);
                }
                TrackMixer.this.mixer.fireChanges(TrackMixer.this.track.getChannel());
            }
        });
        this.balanceScale = new Scale(composite2, 256);
        this.balanceScale.setMaximum(127);
        this.balanceScale.setMinimum(0);
        this.balanceScale.setIncrement(1);
        this.balanceScale.setPageIncrement(64);
        this.balanceScale.setSize(300, 50);
        this.balanceScale.setLayoutData(this.getBalanceScaleData());
        this.volumeLabel = new Label(composite2, 0);
        this.volumeScale = new Scale(composite2, 512);
        this.volumeScale.setMaximum(127);
        this.volumeScale.setMinimum(0);
        this.volumeScale.setIncrement(1);
        this.volumeScale.setPageIncrement(16);
        this.volumeScale.setLayoutData(new GridData(0x1000000, 4, true, true));
        this.volumeText = new Text(composite2, 16779268);
        this.volumeText.setEditable(false);
        this.volumeText.setLayoutData(this.getVolumeTextData());
        this.balanceScale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TrackMixer.this.track.getChannel().setBalance((short)TrackMixer.this.balanceScale.getSelection());
                TrackMixer.this.balanceScale.setToolTipText(TuxGuitar.getProperty("track.channel.balance") + ": " + TrackMixer.this.track.getChannel().getBalance());
                TrackMixer.this.mixer.fireChanges(TrackMixer.this.track.getChannel());
            }
        });
        this.volumeScale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TrackMixer.this.track.getChannel().setVolume((short)(TrackMixer.this.volumeScale.getMaximum() - TrackMixer.this.volumeScale.getSelection()));
                TrackMixer.this.volumeScale.setToolTipText(TuxGuitar.getProperty("track.channel.volume") + ": " + TrackMixer.this.track.getChannel().getVolume());
                TrackMixer.this.mixer.fireChanges(TrackMixer.this.track.getChannel());
            }
        });
        this.balanceScale.setSelection(this.track.getChannel().getBalance());
        this.balanceScale.setToolTipText("Balance: " + this.track.getChannel().getBalance());
        this.volumeScale.setSelection(this.volumeScale.getMaximum() - this.track.getChannel().getVolume());
        this.volumeText.setText(Integer.toString(this.volumeScale.getMaximum() - this.volumeScale.getSelection()));
    }

    private GridData getBalanceScaleData() {
        GridData gridData = new GridData(0x1000000, 0, false, true);
        gridData.widthHint = 65;
        return gridData;
    }

    private GridData getVolumeTextData() {
        GridData gridData = new GridData(0x1000000, 0, true, false);
        gridData.minimumWidth = 40;
        return gridData;
    }

    public void fireChanges() {
        this.soloCheckBox.setSelection(this.track.getChannel().isSolo());
        this.muteCheckBox.setSelection(this.track.getChannel().isMute());
        this.volumeScale.setSelection(this.volumeScale.getMaximum() - this.track.getChannel().getVolume());
        this.volumeText.setText(Integer.toString(this.volumeScale.getMaximum() - this.volumeScale.getSelection()));
    }

    public SongTrack getTrack() {
        return this.track;
    }

    public void loadProperties() {
        this.channelLabel.setText("CH:" + this.track.getChannel().getChannel() + " EC:" + this.track.getChannel().getEffectChannel());
        this.soloCheckBox.setText(TuxGuitar.getProperty("track.channel.solo"));
        this.muteCheckBox.setText(TuxGuitar.getProperty("track.channel.mute"));
        this.volumeLabel.setText(TuxGuitar.getProperty("track.channel.volume") + ":");
        this.volumeScale.setToolTipText(TuxGuitar.getProperty("track.channel.volume") + ": " + this.track.getChannel().getVolume());
        this.balanceScale.setToolTipText(TuxGuitar.getProperty("track.channel.balance") + ": " + this.track.getChannel().getBalance());
    }
}

