/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.xml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ToolBarsReader {
    private static final String ITEM_LIST_TAG = "toolbars";
    private static final String ITEM_TAG = "toolbar";
    private static final String NAME_ATTRIBUTE = "name";

    public List loadToolBars(File file) {
        ArrayList arrayList = new ArrayList();
        if (file.exists()) {
            try {
                Document document = ToolBarsReader.getDocument(file);
                ToolBarsReader.loadToolBars(arrayList, document.getFirstChild());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Error error) {
                error.printStackTrace();
            }
        }
        return arrayList;
    }

    private static Document getDocument(File file) throws ParserConfigurationException, SAXException, IOException {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        document = documentBuilder.parse(file);
        return document;
    }

    private static void loadToolBars(List list, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (!string.equals(ITEM_TAG)) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            String string2 = namedNodeMap.getNamedItem(NAME_ATTRIBUTE).getNodeValue();
            if (string2 == null || string2.trim().length() == 0) {
                System.err.println("Invalid ToolBar name.");
            }
            list.add(string2);
        }
    }
}

