/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ToolItems;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;

public class NoteEffectToolItems
extends ToolItems {
    public static final String NAME = "effect.items";
    private ToolBar toolBar;
    private ToolItem deadNote;
    private ToolItem ghostNote;
    private ToolItem accentuatedNote;
    private ToolItem heavyAccentuatedNote;
    private ToolItem harmonicNote;
    private ToolItem graceNote;
    private ToolItem vibrato;
    private ToolItem bend;
    private ToolItem tremoloBar;
    private ToolItem slide;
    private ToolItem hammer;
    private ToolItem trill;
    private ToolItem tremoloPicking;
    private ToolItem palmMute;
    private ToolItem staccato;
    private ToolItem tapping;
    private ToolItem slapping;
    private ToolItem popping;
    private ToolItem fadeIn;

    public NoteEffectToolItems() {
        super(NAME);
    }

    public void showItems(ToolBar toolBar) {
        this.toolBar = toolBar;
        this.deadNote = new ToolItem(toolBar, 32);
        this.deadNote.setImage(SystemImages.EFFECT_DEAD);
        this.deadNote.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-dead"));
        this.ghostNote = new ToolItem(toolBar, 32);
        this.ghostNote.setImage(SystemImages.EFFECT_GHOST);
        this.ghostNote.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-ghost"));
        this.accentuatedNote = new ToolItem(toolBar, 32);
        this.accentuatedNote.setImage(SystemImages.EFFECT_ACCENTUATED);
        this.accentuatedNote.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-accentuated"));
        this.heavyAccentuatedNote = new ToolItem(toolBar, 32);
        this.heavyAccentuatedNote.setImage(SystemImages.EFFECT_HEAVY_ACCENTUATED);
        this.heavyAccentuatedNote.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-heavy-accentuated"));
        this.harmonicNote = new ToolItem(toolBar, 32);
        this.harmonicNote.setImage(SystemImages.EFFECT_HARMONIC);
        this.harmonicNote.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-harmonic"));
        this.graceNote = new ToolItem(toolBar, 32);
        this.graceNote.setImage(SystemImages.EFFECT_GRACE);
        this.graceNote.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-grace"));
        new ToolItem(toolBar, 2);
        this.vibrato = new ToolItem(toolBar, 32);
        this.vibrato.setImage(SystemImages.EFFECT_VIBRATO);
        this.vibrato.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-vibrato"));
        this.bend = new ToolItem(toolBar, 32);
        this.bend.setImage(SystemImages.EFFECT_BEND);
        this.bend.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-bend"));
        this.tremoloBar = new ToolItem(toolBar, 32);
        this.tremoloBar.setImage(SystemImages.EFFECT_TREMOLO_BAR);
        this.tremoloBar.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-tremolo-bar"));
        this.slide = new ToolItem(toolBar, 32);
        this.slide.setImage(SystemImages.EFFECT_SLIDE);
        this.slide.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-slide"));
        this.hammer = new ToolItem(toolBar, 32);
        this.hammer.setImage(SystemImages.EFFECT_HAMMER);
        this.hammer.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-hammer"));
        new ToolItem(toolBar, 2);
        this.trill = new ToolItem(toolBar, 32);
        this.trill.setImage(SystemImages.EFFECT_TRILL);
        this.trill.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-trill"));
        this.tremoloPicking = new ToolItem(toolBar, 32);
        this.tremoloPicking.setImage(SystemImages.EFFECT_TREMOLO_PICKING);
        this.tremoloPicking.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-tremolo-picking"));
        this.palmMute = new ToolItem(toolBar, 32);
        this.palmMute.setImage(SystemImages.EFFECT_PALM_MUTE);
        this.palmMute.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-palm-mute"));
        this.staccato = new ToolItem(toolBar, 32);
        this.staccato.setImage(SystemImages.EFFECT_STACCATO);
        this.staccato.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-staccato"));
        new ToolItem(toolBar, 2);
        this.tapping = new ToolItem(toolBar, 32);
        this.tapping.setImage(SystemImages.EFFECT_TAPPING);
        this.tapping.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-tapping"));
        this.slapping = new ToolItem(toolBar, 32);
        this.slapping.setImage(SystemImages.EFFECT_SLAPPING);
        this.slapping.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-slapping"));
        this.popping = new ToolItem(toolBar, 32);
        this.popping.setImage(SystemImages.EFFECT_POPPING);
        this.popping.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-popping"));
        new ToolItem(toolBar, 2);
        this.fadeIn = new ToolItem(toolBar, 32);
        this.fadeIn.setImage(SystemImages.EFFECT_FADE_IN);
        this.fadeIn.addSelectionListener(TuxGuitar.instance().getAction("action.note.effect.change-fade-in"));
        this.loadProperties();
    }

    public void update() {
        Note note = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getSelectedNote();
        NoteEffect noteEffect = note != null ? note.getEffect() : new NoteEffect();
        this.vibrato.setSelection(noteEffect.isVibrato());
        this.bend.setSelection(noteEffect.isBend());
        this.tremoloBar.setSelection(noteEffect.isTremoloBar());
        this.deadNote.setSelection(noteEffect.isDeadNote());
        this.slide.setSelection(noteEffect.isSlide());
        this.hammer.setSelection(noteEffect.isHammer());
        this.ghostNote.setSelection(noteEffect.isGhostNote());
        this.accentuatedNote.setSelection(noteEffect.isAccentuatedNote());
        this.heavyAccentuatedNote.setSelection(noteEffect.isHeavyAccentuatedNote());
        this.harmonicNote.setSelection(noteEffect.isHarmonic());
        this.graceNote.setSelection(noteEffect.isGrace());
        this.trill.setSelection(noteEffect.isTrill());
        this.tremoloPicking.setSelection(noteEffect.isTremoloPicking());
        this.palmMute.setSelection(noteEffect.isPalmMute());
        this.staccato.setSelection(noteEffect.isStaccato());
        this.tapping.setSelection(noteEffect.isTapping());
        this.slapping.setSelection(noteEffect.isSlapping());
        this.popping.setSelection(noteEffect.isPopping());
        this.fadeIn.setSelection(noteEffect.isFadeIn());
    }

    public void loadProperties() {
        this.vibrato.setToolTipText(TuxGuitar.getProperty("effects.vibrato"));
        this.bend.setToolTipText(TuxGuitar.getProperty("effects.bend"));
        this.popping.setToolTipText(TuxGuitar.getProperty("effects.popping"));
        this.deadNote.setToolTipText(TuxGuitar.getProperty("effects.deadnote"));
        this.slide.setToolTipText(TuxGuitar.getProperty("effects.slide"));
        this.hammer.setToolTipText(TuxGuitar.getProperty("effects.hammer"));
        this.ghostNote.setToolTipText(TuxGuitar.getProperty("effects.ghostnote"));
        this.accentuatedNote.setToolTipText(TuxGuitar.getProperty("effects.accentuatednote"));
        this.heavyAccentuatedNote.setToolTipText(TuxGuitar.getProperty("effects.heavyaccentuatednote"));
        this.harmonicNote.setToolTipText(TuxGuitar.getProperty("effects.harmonic"));
        this.graceNote.setToolTipText(TuxGuitar.getProperty("effects.grace"));
        this.trill.setToolTipText(TuxGuitar.getProperty("effects.trill"));
        this.tremoloPicking.setToolTipText(TuxGuitar.getProperty("effects.tremolo-picking"));
        this.palmMute.setToolTipText(TuxGuitar.getProperty("effects.palm-mute"));
        this.staccato.setToolTipText(TuxGuitar.getProperty("effects.staccato"));
        this.tapping.setToolTipText(TuxGuitar.getProperty("effects.tapping"));
        this.slapping.setToolTipText(TuxGuitar.getProperty("effects.slapping"));
        this.popping.setToolTipText(TuxGuitar.getProperty("effects.popping"));
        this.fadeIn.setToolTipText(TuxGuitar.getProperty("effects.fade-in"));
    }
}

