/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.items.MenuItems;

public class PlayMenuItem
implements MenuItems {
    private static final int STATUS_STOPED = 1;
    private static final int STATUS_PAUSED = 2;
    private static final int STATUS_RUNNING = 3;
    private TablatureEditor tablatureEditor;
    private Shell shell;
    private MenuItem playMenuItem;
    private Menu menu;
    private MenuItem play;
    private MenuItem stop;
    private int status;

    public PlayMenuItem(Shell shell, Menu menu, int n, TablatureEditor tablatureEditor) {
        this.playMenuItem = new MenuItem(menu, n);
        this.tablatureEditor = tablatureEditor;
        this.shell = shell;
        this.menu = new Menu(shell, 4);
    }

    public void showItems() {
        this.play = new MenuItem(this.menu, 8);
        this.play.setImage(SystemImages.TRANSPORT_ICON_PLAY_1);
        this.play.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().play(selectionEvent);
            }
        });
        this.stop = new MenuItem(this.menu, 8);
        this.stop.setImage(SystemImages.TRANSPORT_ICON_STOP_1);
        this.stop.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().stop(selectionEvent);
            }
        });
        this.status = 1;
        this.playMenuItem.setMenu(this.menu);
        this.loadProperties();
    }

    public void update() {
        int n = this.status;
        this.status = TuxGuitar.instance().getPlayer().isRunning() ? 3 : (TuxGuitar.instance().getPlayer().isPaused() ? 2 : 1);
        if (n != this.status) {
            if (this.status == 3) {
                this.stop.setImage(SystemImages.TRANSPORT_ICON_STOP_2);
                this.play.setImage(SystemImages.TRANSPORT_ICON_PAUSE);
            } else if (this.status == 2) {
                this.stop.setImage(SystemImages.TRANSPORT_ICON_STOP_2);
                this.play.setImage(SystemImages.TRANSPORT_ICON_PLAY_2);
            } else if (this.status == 1) {
                this.stop.setImage(SystemImages.TRANSPORT_ICON_STOP_1);
                this.play.setImage(SystemImages.TRANSPORT_ICON_PLAY_1);
            }
        }
    }

    public void loadProperties() {
        this.playMenuItem.setText(TuxGuitar.getProperty("player"));
        this.play.setText(TuxGuitar.getProperty("player.start"));
        this.stop.setText(TuxGuitar.getProperty("player.stop"));
    }
}

