/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.layout.LinearViewLayout;
import org.herac.tuxguitar.gui.editors.tab.layout.PageViewLayout;
import org.herac.tuxguitar.gui.items.MenuItems;

public class LayoutMenuItem
implements MenuItems {
    private TablatureEditor tablatureEditor;
    private MenuItem layoutMenuItem;
    private Menu menu;
    private MenuItem showMixer;
    private MenuItem showTransport;
    private MenuItem showFretBoard;
    private MenuItem showPiano;
    private MenuItem pageLayout;
    private MenuItem linearLayout;
    private MenuItem multitrack;
    private MenuItem scoreEnabled;

    public LayoutMenuItem(Shell shell, Menu menu, int n, TablatureEditor tablatureEditor) {
        this.layoutMenuItem = new MenuItem(menu, n);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu(shell, 4);
    }

    public void showItems() {
        this.showMixer = new MenuItem(this.menu, 32);
        this.showMixer.addSelectionListener(TuxGuitar.instance().getAction("action.view.show-mixer"));
        this.showTransport = new MenuItem(this.menu, 32);
        this.showTransport.addSelectionListener(TuxGuitar.instance().getAction("action.view.show-transport"));
        this.showFretBoard = new MenuItem(this.menu, 32);
        this.showFretBoard.addSelectionListener(TuxGuitar.instance().getAction("action.view.show-fretboard"));
        this.showPiano = new MenuItem(this.menu, 32);
        this.showPiano.addSelectionListener(TuxGuitar.instance().getAction("action.view.show-piano"));
        new MenuItem(this.menu, 2);
        this.pageLayout = new MenuItem(this.menu, 16);
        this.pageLayout.addSelectionListener(TuxGuitar.instance().getAction("action.view.layout-set-page"));
        this.linearLayout = new MenuItem(this.menu, 16);
        this.linearLayout.addSelectionListener(TuxGuitar.instance().getAction("action.view.layout-set-linear"));
        this.multitrack = new MenuItem(this.menu, 32);
        this.multitrack.addSelectionListener(TuxGuitar.instance().getAction("action.view.layout-set-multitrack"));
        this.scoreEnabled = new MenuItem(this.menu, 32);
        this.scoreEnabled.addSelectionListener(TuxGuitar.instance().getAction("action.view.layout-set-score-enabled"));
        this.layoutMenuItem.setMenu(this.menu);
        this.loadProperties();
    }

    public void update() {
        this.showMixer.setSelection(!TuxGuitar.instance().getMixer().isDisposed());
        this.showTransport.setSelection(!TuxGuitar.instance().getTransport().isDisposed());
        this.showFretBoard.setSelection(TuxGuitar.instance().getFretBoardEditor().isVisible());
        this.showPiano.setSelection(TuxGuitar.instance().getPianoEditor().isVisible());
        this.pageLayout.setSelection(this.tablatureEditor.getTablature().getViewLayout() instanceof PageViewLayout);
        this.linearLayout.setSelection(this.tablatureEditor.getTablature().getViewLayout() instanceof LinearViewLayout);
        this.multitrack.setSelection(this.tablatureEditor.getTablature().getViewLayout().isMultitrack());
        this.scoreEnabled.setSelection(this.tablatureEditor.getTablature().getViewLayout().isScoreEnabled());
    }

    public void loadProperties() {
        this.layoutMenuItem.setText(TuxGuitar.getProperty("layout"));
        this.showMixer.setText(TuxGuitar.getProperty("show-mixer"));
        this.showTransport.setText(TuxGuitar.getProperty("show-transport"));
        this.showFretBoard.setText(TuxGuitar.getProperty("show-fretboard"));
        this.showPiano.setText(TuxGuitar.getProperty("show-piano"));
        this.pageLayout.setText(TuxGuitar.getProperty("layout.page"));
        this.linearLayout.setText(TuxGuitar.getProperty("layout.linear"));
        this.multitrack.setText(TuxGuitar.getProperty("layout.multitrack"));
        this.scoreEnabled.setText(TuxGuitar.getProperty("layout.score-enabled"));
    }
}

