/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.items.MenuItems;
import org.herac.tuxguitar.song.models.Note;

public class DynamicMenuItem
implements MenuItems {
    private TablatureEditor tablatureEditor;
    private MenuItem dynamicMenuItem;
    private Menu menu;
    private MenuItem pianoPianissimo;
    private MenuItem pianissimo;
    private MenuItem piano;
    private MenuItem mezzoPiano;
    private MenuItem mezzoForte;
    private MenuItem forte;
    private MenuItem fortissimo;
    private MenuItem forteFortissimo;

    public DynamicMenuItem(Shell shell, Menu menu, int n, TablatureEditor tablatureEditor) {
        this.dynamicMenuItem = new MenuItem(menu, n);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu(shell, 4);
    }

    public void showItems() {
        this.pianoPianissimo = new MenuItem(this.menu, 32);
        this.pianoPianissimo.setData(new Integer(15));
        this.pianoPianissimo.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.pianissimo = new MenuItem(this.menu, 32);
        this.pianissimo.setData(new Integer(31));
        this.pianissimo.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.piano = new MenuItem(this.menu, 32);
        this.piano.setData(new Integer(47));
        this.piano.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.mezzoPiano = new MenuItem(this.menu, 32);
        this.mezzoPiano.setData(new Integer(63));
        this.mezzoPiano.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.mezzoForte = new MenuItem(this.menu, 32);
        this.mezzoForte.setData(new Integer(79));
        this.mezzoForte.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.forte = new MenuItem(this.menu, 32);
        this.forte.setData(new Integer(95));
        this.forte.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.fortissimo = new MenuItem(this.menu, 32);
        this.fortissimo.setData(new Integer(111));
        this.fortissimo.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.forteFortissimo = new MenuItem(this.menu, 32);
        this.forteFortissimo.setData(new Integer(127));
        this.forteFortissimo.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.velocity"));
        this.dynamicMenuItem.setMenu(this.menu);
        this.loadProperties();
    }

    public void update() {
        Note note = this.tablatureEditor.getTablature().getCaret().getSelectedNote();
        int n = note != null ? note.getVelocity() : this.tablatureEditor.getTablature().getCaret().getVelocity();
        this.pianoPianissimo.setSelection(n == 15);
        this.pianissimo.setSelection(n == 31);
        this.piano.setSelection(n == 47);
        this.mezzoPiano.setSelection(n == 63);
        this.mezzoForte.setSelection(n == 79);
        this.forte.setSelection(n == 95);
        this.fortissimo.setSelection(n == 111);
        this.forteFortissimo.setSelection(n == 127);
    }

    public void loadProperties() {
        this.dynamicMenuItem.setText(TuxGuitar.getProperty("dynamic"));
        this.pianoPianissimo.setText(TuxGuitar.getProperty("dynamic.piano-pianissimo"));
        this.pianissimo.setText(TuxGuitar.getProperty("dynamic.pianissimo"));
        this.piano.setText(TuxGuitar.getProperty("dynamic.piano"));
        this.mezzoPiano.setText(TuxGuitar.getProperty("dynamic.mezzo-piano"));
        this.mezzoForte.setText(TuxGuitar.getProperty("dynamic.mezzo-forte"));
        this.forte.setText(TuxGuitar.getProperty("dynamic.forte"));
        this.fortissimo.setText(TuxGuitar.getProperty("dynamic.fortissimo"));
        this.forteFortissimo.setText(TuxGuitar.getProperty("dynamic.forte-fortissimo"));
    }
}

