/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.items.MenuItems;

public class DurationMenuItem
implements MenuItems {
    private TablatureEditor tablatureEditor;
    private Shell shell;
    private MenuItem durationMenuItem;
    private Menu menu;
    private MenuItem whole;
    private MenuItem half;
    private MenuItem quarter;
    private MenuItem eighth;
    private MenuItem sixteenth;
    private MenuItem thirtySecond;
    private MenuItem sixtyFourth;
    private MenuItem dotted;
    private MenuItem doubleDotted;
    private MenuItem tupleto;

    public DurationMenuItem(Shell shell, Menu menu, int n, TablatureEditor tablatureEditor) {
        this.durationMenuItem = new MenuItem(menu, n);
        this.tablatureEditor = tablatureEditor;
        this.shell = shell;
        this.menu = new Menu(shell, 4);
    }

    public void showItems() {
        this.whole = new MenuItem(this.menu, 8);
        this.whole.setImage(SystemImages.getDuration(1));
        this.whole.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.set-whole"));
        this.half = new MenuItem(this.menu, 8);
        this.half.setImage(SystemImages.getDuration(2));
        this.half.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.set-half"));
        this.quarter = new MenuItem(this.menu, 8);
        this.quarter.setImage(SystemImages.getDuration(4));
        this.quarter.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.set-quarter"));
        this.eighth = new MenuItem(this.menu, 8);
        this.eighth.setImage(SystemImages.getDuration(8));
        this.eighth.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.set-eighth"));
        this.sixteenth = new MenuItem(this.menu, 8);
        this.sixteenth.setImage(SystemImages.getDuration(16));
        this.sixteenth.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.set-sixteenth"));
        this.thirtySecond = new MenuItem(this.menu, 8);
        this.thirtySecond.setImage(SystemImages.getDuration(32));
        this.thirtySecond.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.set-thirty-second"));
        this.sixtyFourth = new MenuItem(this.menu, 8);
        this.sixtyFourth.setImage(SystemImages.getDuration(64));
        this.sixtyFourth.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.set-sixty-fourth"));
        new MenuItem(this.menu, 2);
        this.dotted = new MenuItem(this.menu, 8);
        this.dotted.setImage(SystemImages.DOTTED_IMAGE);
        this.dotted.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.change-dotted"));
        this.doubleDotted = new MenuItem(this.menu, 8);
        this.doubleDotted.setImage(SystemImages.DOUBLE_DOTTED_IMAGE);
        this.doubleDotted.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.change-double-dotted"));
        this.tupleto = new MenuItem(this.menu, 8);
        this.tupleto.setImage(SystemImages.TUPLETO_IMAGE);
        this.tupleto.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.change-tupleto"));
        this.durationMenuItem.setMenu(this.menu);
        this.loadProperties();
    }

    public void update() {
    }

    public void loadProperties() {
        this.durationMenuItem.setText(TuxGuitar.getProperty("duration"));
        this.whole.setText(TuxGuitar.getProperty("duration.whole"));
        this.half.setText(TuxGuitar.getProperty("duration.half"));
        this.quarter.setText(TuxGuitar.getProperty("duration.quarter"));
        this.eighth.setText(TuxGuitar.getProperty("duration.eighth"));
        this.sixteenth.setText(TuxGuitar.getProperty("duration.sixteenth"));
        this.thirtySecond.setText(TuxGuitar.getProperty("duration.thirtysecond"));
        this.sixtyFourth.setText(TuxGuitar.getProperty("duration.sixtyfourth"));
        this.dotted.setText(TuxGuitar.getProperty("duration.dotted"));
        this.doubleDotted.setText(TuxGuitar.getProperty("duration.doubledotted"));
        this.tupleto.setText(TuxGuitar.getProperty("duration.tupleto"));
    }
}

