/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.items.MenuItems;

public class CompositionMenuItem
implements MenuItems {
    private TablatureEditor tablatureEditor;
    private MenuItem compositionMenuItem;
    private Menu menu;
    private MenuItem timeSignature;
    private MenuItem tempo;
    private MenuItem clef;
    private MenuItem keySignature;
    private MenuItem openRepeat;
    private MenuItem closeRepeat;
    private MenuItem tripletFeel;
    private MenuItem properties;

    public CompositionMenuItem(Shell shell, Menu menu, int n, TablatureEditor tablatureEditor) {
        this.compositionMenuItem = new MenuItem(menu, n);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu(shell, 4);
    }

    public void showItems() {
        this.timeSignature = new MenuItem(this.menu, 8);
        this.timeSignature.setImage(SystemImages.TIME_SIGNATURE_IMAGE);
        this.timeSignature.addSelectionListener(TuxGuitar.instance().getAction("action.composition.change-time-signature"));
        this.tempo = new MenuItem(this.menu, 8);
        this.tempo.setImage(SystemImages.TEMPO_ICON_IMAGE);
        this.tempo.addSelectionListener(TuxGuitar.instance().getAction("action.composition.change-tempo"));
        this.clef = new MenuItem(this.menu, 8);
        this.clef.addSelectionListener(TuxGuitar.instance().getAction("action.composition.change-clef"));
        this.keySignature = new MenuItem(this.menu, 8);
        this.keySignature.addSelectionListener(TuxGuitar.instance().getAction("action.composition.change-key-signature"));
        this.tripletFeel = new MenuItem(this.menu, 8);
        this.tripletFeel.addSelectionListener(TuxGuitar.instance().getAction("action.composition.change-triplet-feel"));
        new MenuItem(this.menu, 2);
        this.openRepeat = new MenuItem(this.menu, 8);
        this.openRepeat.setImage(SystemImages.OPEN_REPEAT_IMAGE);
        this.openRepeat.addSelectionListener(TuxGuitar.instance().getAction("action.insert.open-repeat"));
        this.closeRepeat = new MenuItem(this.menu, 8);
        this.closeRepeat.setImage(SystemImages.CLOSE_REPEAT_IMAGE);
        this.closeRepeat.addSelectionListener(TuxGuitar.instance().getAction("action.insert.close-repeat"));
        new MenuItem(this.menu, 2);
        this.properties = new MenuItem(this.menu, 8);
        this.properties.setImage(SystemImages.SONG_PROPERTIES);
        this.properties.addSelectionListener(TuxGuitar.instance().getAction("action.composition.change-info"));
        this.compositionMenuItem.setMenu(this.menu);
        this.loadProperties();
    }

    public void update() {
    }

    public void loadProperties() {
        this.compositionMenuItem.setText(TuxGuitar.getProperty("composition"));
        this.timeSignature.setText(TuxGuitar.getProperty("composition.timesignature"));
        this.tempo.setText(TuxGuitar.getProperty("composition.tempo"));
        this.clef.setText(TuxGuitar.getProperty("composition.clef"));
        this.keySignature.setText(TuxGuitar.getProperty("composition.keysignature"));
        this.tripletFeel.setText(TuxGuitar.getProperty("composition.tripletfeel"));
        this.openRepeat.setText(TuxGuitar.getProperty("repeat.open"));
        this.closeRepeat.setText(TuxGuitar.getProperty("repeat.close"));
        this.properties.setText(TuxGuitar.getProperty("composition.properties"));
    }
}

