/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.items.MenuItems;
import org.herac.tuxguitar.song.models.Chord;

public class ChordMenuItem
implements MenuItems {
    private TablatureEditor tablatureEditor;
    private Shell shell;
    private MenuItem chordMenuItem;
    private Menu menu;
    private MenuItem insertChord;
    private MenuItem[] subMenuItems;
    private long lastEdit;

    public ChordMenuItem(Shell shell, Menu menu, int n, TablatureEditor tablatureEditor) {
        this.chordMenuItem = new MenuItem(menu, n);
        this.tablatureEditor = tablatureEditor;
        this.shell = shell;
        this.menu = new Menu(shell, 4);
    }

    public void showItems() {
        this.insertChord = new MenuItem(this.menu, 8);
        this.insertChord.addSelectionListener(TuxGuitar.instance().getAction("action.insert.chord"));
        new MenuItem(this.menu, 2);
        this.addItems();
        this.chordMenuItem.setMenu(this.menu);
        this.loadProperties();
    }

    public void addItems() {
        this.disposeItems();
        this.subMenuItems = new MenuItem[TuxGuitar.instance().getCustomChordManager().countChords()];
        for (int i = 0; i < this.subMenuItems.length; ++i) {
            Chord chord = TuxGuitar.instance().getCustomChordManager().getChord(i);
            this.subMenuItems[i] = new MenuItem(this.menu, 8);
            this.subMenuItems[i].setData(chord);
            this.subMenuItems[i].setText(chord.getName());
            this.subMenuItems[i].addSelectionListener(TuxGuitar.instance().getAction("action.insert.chord"));
        }
    }

    public void disposeItems() {
        if (this.subMenuItems != null) {
            for (int i = 0; i < this.subMenuItems.length; ++i) {
                this.subMenuItems[i].dispose();
            }
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.detail == 4 && this.subMenuItems != null && this.subMenuItems.length > 0) {
            ToolItem toolItem = (ToolItem)selectionEvent.widget;
            Rectangle rectangle = toolItem.getBounds();
            Point point = toolItem.getParent().toDisplay(new Point(rectangle.x, rectangle.y));
            this.menu.setLocation(point.x, point.y + rectangle.height);
            this.menu.setVisible(true);
        } else {
            TuxGuitar.instance().getAction("action.insert.chord").process(selectionEvent);
        }
    }

    public void update() {
        if (this.lastEdit != TuxGuitar.instance().getCustomChordManager().getLastEdit()) {
            this.addItems();
            this.lastEdit = TuxGuitar.instance().getCustomChordManager().getLastEdit();
        }
    }

    public void loadProperties() {
        this.chordMenuItem.setText(TuxGuitar.getProperty("chord"));
        this.insertChord.setText(TuxGuitar.getProperty("insert.chord"));
    }
}

