/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.effects;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.effects.TrillEffect;

public class TrillEditor
extends SelectionAdapter {
    public static final int WIDTH = 400;
    public static final int HEIGHT = 0;
    private Spinner fretSpinner;
    private Button sixtyFourthButton;
    private Button thirtySecondButton;
    private Button sixTeenthButton;
    private TrillEffect result;

    public TrillEffect show(final Note note) {
        Shell shell = TuxGuitar.instance().getShell();
        final Shell shell2 = new Shell(shell, 67680);
        shell2.setLayout(new GridLayout());
        shell2.setText(TuxGuitar.getProperty("effects.trill-editor"));
        Composite composite = new Composite(shell2, 0);
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(4, 4, true, true));
        int n = 2;
        int n2 = note.getValue();
        Duration duration = new Duration(16);
        if (note.getEffect().isTrill()) {
            n2 = note.getEffect().getTrill().getFret();
            duration = note.getEffect().getTrill().getDuration();
        }
        Group group = this.makeGroup(composite, n, TuxGuitar.getProperty("note"));
        group.setLayout(new GridLayout(2, false));
        Label label = new Label(group, 0);
        label.setText(TuxGuitar.getProperty("fret") + ": ");
        this.fretSpinner = new Spinner(group, 2048);
        this.fretSpinner.setLayoutData(this.makeGridData(1));
        this.fretSpinner.setSelection(n2);
        Group group2 = this.makeGroup(composite, n, TuxGuitar.getProperty("duration"));
        group2.setLayout(new GridLayout(3, false));
        this.sixtyFourthButton = new Button(group2, 16);
        this.sixtyFourthButton.setImage(SystemImages.getDuration(64));
        this.sixtyFourthButton.setLayoutData(this.makeGridData(1));
        this.sixtyFourthButton.setSelection(duration.getValue() == 64);
        this.thirtySecondButton = new Button(group2, 16);
        this.thirtySecondButton.setImage(SystemImages.getDuration(32));
        this.thirtySecondButton.setLayoutData(this.makeGridData(1));
        this.thirtySecondButton.setSelection(duration.getValue() == 32);
        this.sixTeenthButton = new Button(group2, 16);
        this.sixTeenthButton.setImage(SystemImages.getDuration(16));
        this.sixTeenthButton.setLayoutData(this.makeGridData(1));
        this.sixTeenthButton.setSelection(duration.getValue() == 16);
        Composite composite2 = new Composite(shell2, 0);
        composite2.setLayout(new GridLayout(3, false));
        composite2.setLayoutData(new GridData(0x1000008, 1024, true, true));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        Button button = new Button(composite2, 8);
        button.setText(TuxGuitar.getProperty("ok"));
        button.setLayoutData(gridData);
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TrillEditor.this.result = TrillEditor.this.getTrill();
                shell2.dispose();
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setText(TuxGuitar.getProperty("clean"));
        button2.setLayoutData(gridData);
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TrillEditor.this.result = null;
                shell2.dispose();
            }
        });
        Button button3 = new Button(composite2, 8);
        button3.setText(TuxGuitar.getProperty("cancel"));
        button3.setLayoutData(gridData);
        button3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TrillEditor.this.result = note.getEffect().getTrill();
                shell2.dispose();
            }
        });
        shell2.pack();
        shell2.open();
        int n3 = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
        int n4 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
        shell2.setLocation(n3, n4);
        while (!shell2.isDisposed()) {
            if (shell2.getDisplay().readAndDispatch()) continue;
            shell2.getDisplay().sleep();
        }
        return this.result;
    }

    private GridData resizeData(GridData gridData, int n) {
        gridData.minimumWidth = n;
        return gridData;
    }

    private Group makeGroup(Composite composite, int n, String string) {
        Group group = new Group(composite, 16);
        group.setLayoutData(this.makeGridData(n));
        group.setText(string);
        return group;
    }

    private GridData makeGridData(int n) {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = n;
        return gridData;
    }

    public TrillEffect getTrill() {
        int n = this.fretSpinner.getSelection();
        if (this.sixtyFourthButton.getSelection()) {
            return new TrillEffect(n, new Duration(64));
        }
        if (this.thirtySecondButton.getSelection()) {
            return new TrillEffect(n, new Duration(32));
        }
        if (this.sixTeenthButton.getSelection()) {
            return new TrillEffect(n, new Duration(16));
        }
        return null;
    }
}

