/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.effects;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.effects.BendEffect;

public class BendEditor {
    public static final int X_SPAN = 30;
    public static final int Y_SPAN = 15;
    private static final int X_LENGTH = 13;
    private static final int Y_LENGTH = 13;
    private Composite editor;
    private int[] x;
    private int[] y;
    private int width;
    private int height;
    private List points;
    private DefaultBend[] defaultBends;
    private boolean isEditing;
    private BendEffect result;

    public BendEditor() {
        this.init();
    }

    private void init() {
        int n;
        this.x = new int[13];
        this.y = new int[13];
        this.width = 360;
        this.height = 180;
        this.points = new ArrayList();
        for (n = 0; n < this.x.length; ++n) {
            this.x[n] = (n + 1) * 30;
        }
        for (n = 0; n < this.y.length; ++n) {
            this.y[n] = (n + 1) * 15;
        }
    }

    public BendEffect show(Shell shell, final Note note) {
        final Shell shell2 = new Shell(shell, 67680);
        shell2.setLayout(new GridLayout());
        shell2.setText(TuxGuitar.getProperty("bend.editor"));
        Composite composite = new Composite(shell2, 0);
        composite.setLayout(new GridLayout(3, false));
        composite.setLayoutData(new GridData(4, 4, true, true));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout());
        composite2.setLayoutData(new GridData(4, 4, true, true));
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout(new GridLayout());
        composite3.setLayoutData(new GridData(4, 4, true, true));
        this.isEditing = note.getEffect().isBend();
        this.editor = new Composite(composite2, 0x20000800);
        this.editor.setBackground(this.editor.getDisplay().getSystemColor(1));
        this.editor.setLayoutData(this.resizeData(new GridData(4, 4, true, true), this.getWidth() + 60, this.getHeight() + 30));
        this.editor.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                BendEditor.this.paintEditor(paintEvent.gc);
                paintEvent.gc.dispose();
            }
        });
        this.editor.addMouseListener(new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                BendEditor.this.checkPoint(mouseEvent.x, mouseEvent.y);
                BendEditor.this.editor.redraw();
            }
        });
        if (this.isEditing) {
            this.setBend(note.getEffect().getBend());
        }
        final org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(composite3, 2048);
        this.resetDefaultBends();
        for (int i = 0; i < this.defaultBends.length; ++i) {
            list.add(this.defaultBends[i].getName());
        }
        list.setLayoutData(new GridData(4, 4, true, true));
        list.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!BendEditor.this.isEditing) {
                    BendEditor.this.setBend(BendEditor.this.defaultBends[list.getSelectionIndex()].getBend());
                    BendEditor.this.editor.redraw();
                }
                BendEditor.this.isEditing = false;
            }
        });
        Button button = new Button(composite3, 8);
        button.setLayoutData(this.resizeData(new GridData(4, 1024, true, true), 80, 25));
        button.setText(TuxGuitar.getProperty("clean"));
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BendEditor.this.result = null;
                shell2.dispose();
            }
        });
        Button button2 = new Button(composite3, 8);
        button2.setLayoutData(this.resizeData(new GridData(4, 1024, true, false), 80, 25));
        button2.setText(TuxGuitar.getProperty("ok"));
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BendEditor.this.result = BendEditor.this.getBend();
                shell2.dispose();
            }
        });
        Button button3 = new Button(composite3, 8);
        button3.setLayoutData(this.resizeData(new GridData(4, 1024, true, false), 80, 25));
        button3.setText(TuxGuitar.getProperty("cancel"));
        button3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BendEditor.this.result = note.getEffect().getBend();
                shell2.dispose();
            }
        });
        shell2.pack();
        int n = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
        int n2 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
        shell2.setLocation(n, n2);
        shell2.open();
        while (!shell2.isDisposed()) {
            if (shell2.getDisplay().readAndDispatch()) continue;
            shell2.getDisplay().sleep();
        }
        return this.result;
    }

    private GridData resizeData(GridData gridData, int n, int n2) {
        gridData.minimumWidth = n;
        gridData.minimumHeight = n2;
        return gridData;
    }

    private void paintEditor(GC gC) {
        int n;
        for (n = 0; n < this.x.length; ++n) {
            this.setStyleX(gC, n);
            gC.drawLine(this.x[n], 15, this.x[n], 15 + this.height);
        }
        for (n = 0; n < this.y.length; ++n) {
            this.setStyleY(gC, n);
            gC.drawLine(30, this.y[n], 30 + this.width, this.y[n]);
        }
        Iterator iterator = null;
        Point point = null;
        gC.setLineStyle(1);
        gC.setLineWidth(2);
        gC.setForeground(this.editor.getDisplay().getSystemColor(15));
        for (Point point2 : this.points) {
            if (point != null) {
                gC.drawLine(point.x, point.y, point2.x, point2.y);
            }
            point = point2;
        }
        gC.setLineWidth(5);
        gC.setForeground(this.editor.getDisplay().getSystemColor(2));
        for (Point point2 : this.points) {
            gC.drawRectangle(point2.x - 2, point2.y - 2, 5, 5);
        }
        gC.setLineWidth(1);
    }

    private void setStyleX(GC gC, int n) {
        gC.setLineStyle(1);
        if (n == 0 || n == 12) {
            gC.setForeground(this.editor.getDisplay().getSystemColor(2));
        } else {
            gC.setForeground(this.editor.getDisplay().getSystemColor(9));
            if (n % 3 > 0) {
                gC.setLineStyle(3);
            }
        }
    }

    private void setStyleY(GC gC, int n) {
        gC.setLineStyle(1);
        if (n == 0 || n == 12) {
            gC.setForeground(this.editor.getDisplay().getSystemColor(2));
        } else {
            gC.setForeground(this.editor.getDisplay().getSystemColor(3));
            if (n % 2 > 0) {
                gC.setLineStyle(3);
                gC.setForeground(this.editor.getDisplay().getSystemColor(15));
            } else if (n % 4 > 0) {
                gC.setLineStyle(3);
            }
        }
    }

    private void checkPoint(int n, int n2) {
        Point point = new Point(this.getX(n), this.getY(n2));
        if (!this.removePoint(point)) {
            this.removePointsAtXLine(point.x);
            this.addPoint(point);
            this.orderPoints();
        }
    }

    private boolean removePoint(Point point) {
        for (Point point2 : this.points) {
            if (point2.x != point.x || point2.y != point.y) continue;
            this.points.remove(point);
            return true;
        }
        return false;
    }

    private void orderPoints() {
        for (int i = 0; i < this.points.size(); ++i) {
            Point point = null;
            for (int j = i; j < this.points.size(); ++j) {
                Point point2 = (Point)this.points.get(j);
                if (point != null && point2.x >= point.x) continue;
                point = point2;
            }
            this.points.remove(point);
            this.points.add(i, point);
        }
    }

    private void removePointsAtXLine(int n) {
        for (Point point : this.points) {
            if (point.x != n) continue;
            this.points.remove(point);
            break;
        }
    }

    private void addPoint(Point point) {
        this.points.add(point);
    }

    private int getX(int n) {
        int n2 = -1;
        for (int i = 0; i < this.x.length; ++i) {
            if (n2 < 0) {
                n2 = this.x[i];
                continue;
            }
            int n3 = Math.abs(n - n2);
            int n4 = Math.abs(n - this.x[i]);
            if (n4 >= n3) continue;
            n2 = this.x[i];
        }
        return n2;
    }

    private int getY(int n) {
        int n2 = -1;
        for (int i = 0; i < this.y.length; ++i) {
            if (n2 < 0) {
                n2 = this.y[i];
                continue;
            }
            int n3 = Math.abs(n - n2);
            int n4 = Math.abs(n - this.y[i]);
            if (n4 >= n3) continue;
            n2 = this.y[i];
        }
        return n2;
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    public BendEffect getBend() {
        if (this.points != null && !this.points.isEmpty()) {
            BendEffect bendEffect = new BendEffect();
            for (Point point : this.points) {
                this.addBendPoint(bendEffect, point);
            }
            return bendEffect;
        }
        return null;
    }

    private void addBendPoint(BendEffect bendEffect, Point point) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.x.length; ++n) {
            if (point.x != this.x[n]) continue;
            n2 = n;
        }
        for (n = 0; n < this.y.length; ++n) {
            if (point.y != this.y[n]) continue;
            n3 = this.y.length - n - 1;
        }
        bendEffect.addPoint(n2, n3);
    }

    public void setBend(BendEffect bendEffect) {
        this.points.clear();
        for (BendEffect.BendPoint bendPoint : bendEffect.getPoints()) {
            this.makePoint(bendPoint);
        }
    }

    private void makePoint(BendEffect.BendPoint bendPoint) {
        int n = bendPoint.getPosition();
        int n2 = this.y.length - bendPoint.getValue() - 1;
        if (n >= 0 && n < this.x.length && n2 >= 0 && n2 < this.y.length) {
            Point point = new Point(0, 0);
            point.x = this.x[n];
            point.y = this.y[n2];
            this.points.add(point);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private void resetDefaultBends() {
        this.defaultBends = new DefaultBend[5];
        this.defaultBends[0] = new DefaultBend(TuxGuitar.getProperty("bend.bend"), new BendEffect());
        this.defaultBends[0].getBend().addPoint(0, 0);
        this.defaultBends[0].getBend().addPoint(6, 4);
        this.defaultBends[0].getBend().addPoint(12, 4);
        this.defaultBends[1] = new DefaultBend(TuxGuitar.getProperty("bend.bend-release"), new BendEffect());
        this.defaultBends[1].getBend().addPoint(0, 0);
        this.defaultBends[1].getBend().addPoint(3, 4);
        this.defaultBends[1].getBend().addPoint(6, 4);
        this.defaultBends[1].getBend().addPoint(9, 0);
        this.defaultBends[1].getBend().addPoint(12, 0);
        this.defaultBends[2] = new DefaultBend(TuxGuitar.getProperty("bend.bend-release-bend"), new BendEffect());
        this.defaultBends[2].getBend().addPoint(0, 0);
        this.defaultBends[2].getBend().addPoint(2, 4);
        this.defaultBends[2].getBend().addPoint(4, 4);
        this.defaultBends[2].getBend().addPoint(6, 0);
        this.defaultBends[2].getBend().addPoint(8, 0);
        this.defaultBends[2].getBend().addPoint(10, 4);
        this.defaultBends[2].getBend().addPoint(12, 4);
        this.defaultBends[3] = new DefaultBend(TuxGuitar.getProperty("bend.prebend"), new BendEffect());
        this.defaultBends[3].getBend().addPoint(0, 4);
        this.defaultBends[3].getBend().addPoint(12, 4);
        this.defaultBends[4] = new DefaultBend(TuxGuitar.getProperty("bend.prebend-release"), new BendEffect());
        this.defaultBends[4].getBend().addPoint(0, 4);
        this.defaultBends[4].getBend().addPoint(4, 4);
        this.defaultBends[4].getBend().addPoint(8, 0);
        this.defaultBends[4].getBend().addPoint(12, 0);
    }

    private class DefaultBend {
        private String name;
        private BendEffect bend;

        public DefaultBend(String string, BendEffect bendEffect) {
            this.name = string;
            this.bend = bendEffect;
        }

        public BendEffect getBend() {
            return this.bend;
        }

        public String getName() {
            return this.name;
        }
    }
}

