/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab.edit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.MeasureComponent;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.NoteCoords;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.editors.tab.edit.EditorKit;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.SongTrack;

public class MouseKit {
    private static final int[] FIRST_LINE_VALUES = new int[]{65, 45, 52, 55};
    private EditorKit kit;
    private Image back = null;
    private int lastx;
    private int lasty;

    public MouseKit(EditorKit editorKit) {
        this.kit = editorKit;
    }

    private ViewLayout.TrackPosition getTrackPosition(int n) {
        TablatureEditor tablatureEditor = TuxGuitar.instance().getTablatureEditor();
        return tablatureEditor.getTablature().getViewLayout().getTrackPositionAt(n);
    }

    public void tryBack() {
        if (!this.kit.getTablature().isLocked()) {
            GC gC = new GC(this.kit.getTablature());
            if (this.back != null && !this.back.isDisposed()) {
                gC.drawImage(this.back, this.lastx, this.lasty);
            }
            gC.dispose();
        }
        if (this.back != null) {
            this.back.dispose();
        }
    }

    public void mouseExit(MouseEvent mouseEvent) {
        this.tryBack();
    }

    public void mouseMove(MouseEvent mouseEvent) {
        MeasureCoords measureCoords;
        this.tryBack();
        SongTrackCoords songTrackCoords = this.kit.getTrackCoords(mouseEvent.y);
        if (songTrackCoords != null && (measureCoords = this.kit.getMeasureCoords(songTrackCoords, mouseEvent.x, mouseEvent.y)) != null && measureCoords.getTs() != null) {
            int n = songTrackCoords.getTrack().getString(songTrackCoords.getTrack().stringCount()).getValue();
            int n2 = songTrackCoords.getTrack().getString(1).getValue() + 29;
            int n3 = FIRST_LINE_VALUES[measureCoords.getMeasure().getClef() - 1];
            int n4 = this.kit.getTablature().getViewLayout().getScoreLineSpan();
            int n5 = 10;
            int n6 = measureCoords.getTs().getPosition(2);
            int n7 = measureCoords.getTs().getPosition(12) - measureCoords.getTs().getPosition(3);
            int n8 = mouseEvent.x - 5;
            int n9 = mouseEvent.x + 5;
            int n10 = measureCoords.getPosY() + measureCoords.getTs().getPosition(2);
            int n11 = n10 + n4 * 5;
            if (mouseEvent.y < n10 + 3 && mouseEvent.y >= n10 - n6) {
                this.back = new Image((Device)TuxGuitar.instance().getDisplay(), n5 + 1, n6 + 1);
                GC gC = new GC(TuxGuitar.instance().getTablatureEditor().getTablature());
                gC.copyArea(this.back, n8, n10 - n6);
                gC.setForeground(this.kit.getTablature().getLineColor());
                for (int i = n10 - n4; i >= n10 - n6 && i >= mouseEvent.y - 5 && (n3 += NoteCoords.NO_NATURAL_NOTES[((n3 += NoteCoords.NO_NATURAL_NOTES[(n3 + 1) % 12] ? 2 : 1) + 1) % 12] ? 2 : 1) <= n2; i -= n4) {
                    gC.drawLine(n8, i, n9, i);
                }
                gC.dispose();
                this.lastx = n8;
                this.lasty = n10 - n6;
            } else if (mouseEvent.y > n11 - 3 && mouseEvent.y < n11 + n7) {
                this.back = new Image((Device)TuxGuitar.instance().getDisplay(), n5 + 1, n7 + 1);
                GC gC = new GC(TuxGuitar.instance().getTablatureEditor().getTablature());
                gC.copyArea(this.back, n8, n11);
                gC.setForeground(this.kit.getTablature().getLineColor());
                n3 -= 14;
                for (int i = n11; i <= n11 + n7 && i <= mouseEvent.y + 5 && (n3 -= NoteCoords.NO_NATURAL_NOTES[((n3 -= NoteCoords.NO_NATURAL_NOTES[(n3 - 1) % 12] ? 2 : 1) - 1) % 12] ? 2 : 1) >= n; i += n4) {
                    gC.drawLine(n8, i, n9, i);
                }
                gC.dispose();
                this.lastx = n8;
                this.lasty = n11;
            }
        }
    }

    public void mouseUp(MouseEvent mouseEvent) {
        ViewLayout.TrackPosition trackPosition = this.getTrackPosition(mouseEvent.y);
        if (trackPosition != null) {
            SongTrackCoords songTrackCoords = this.kit.getTablature().getCaret().getSongTrackCoords();
            MeasureCoords measureCoords = this.kit.getTablature().getCaret().getMeasureCoords();
            if (measureCoords.getTs() != null) {
                int n = songTrackCoords.getTrack().getString(songTrackCoords.getTrack().stringCount()).getValue();
                int n2 = songTrackCoords.getTrack().getString(1).getValue() + 29;
                int n3 = this.kit.getTablature().getViewLayout().getScoreLineSpan();
                int n4 = 10;
                int n5 = measureCoords.getTs().getPosition(2);
                int n6 = measureCoords.getTs().getPosition(12) - measureCoords.getTs().getPosition(3);
                int n7 = trackPosition.getPosY() + measureCoords.getTs().getPosition(2);
                int n8 = n7 + n3 * 5;
                if (mouseEvent.y >= n7 - n5 && mouseEvent.y < n8 + n6) {
                    int n9 = 0;
                    int n10 = FIRST_LINE_VALUES[measureCoords.getMeasure().getClef() - 1];
                    int n11 = 0;
                    while ((double)n11 < (double)n5 / ((double)n3 / 2.0)) {
                        n10 += NoteCoords.NO_NATURAL_NOTES[(n10 + 1) % 12] ? 2 : 1;
                        ++n11;
                    }
                    float f = 0.0f;
                    float f2 = n7 - n5;
                    while (f2 <= (float)(n8 + n6)) {
                        if (n10 > 0) {
                            float f3 = Math.abs((float)mouseEvent.y - f2);
                            if (n9 == 0 || f3 < f) {
                                n9 = n10;
                                f = f3;
                            }
                            n10 -= NoteCoords.NO_NATURAL_NOTES[(n10 - 1) % 12] ? 2 : 1;
                        }
                        f2 = (float)((double)f2 + (double)n3 / 2.0);
                    }
                    if (n9 >= n && n9 <= n2) {
                        List list;
                        if (!this.removeNote(n9 = this.getValue(n9), list = this.kit.getTablature().getCaret().getMeasureCoords().getComponents(this.kit.getTablature().getCaret().getPosition()))) {
                            this.makeNote(n9, list);
                        }
                        this.redrawTablature();
                    }
                }
            }
        }
    }

    private int getValue(int n) {
        int n2 = this.kit.getTablature().getCaret().getMeasureCoords().getMeasure().getKeySignature();
        if (n2 <= 7) {
            if (NoteCoords.KEY_SIGNATURES[n2][NoteCoords.SCORE_SHARP_NOTES[n % 12]] == 1 && this.kit.isNatural()) {
                ++n;
            } else if (NoteCoords.KEY_SIGNATURES[n2][NoteCoords.SCORE_SHARP_NOTES[n % 12]] != 1 && !this.kit.isNatural() && NoteCoords.NO_NATURAL_NOTES[(n + 1) % 12]) {
                ++n;
            }
        } else if (n2 > 7) {
            if (NoteCoords.KEY_SIGNATURES[n2][NoteCoords.SCORE_FLAT_NOTES[n % 12]] == 2 && this.kit.isNatural()) {
                --n;
            } else if (NoteCoords.KEY_SIGNATURES[n2][NoteCoords.SCORE_FLAT_NOTES[n % 12]] != 2 && !this.kit.isNatural() && NoteCoords.NO_NATURAL_NOTES[(n - 1) % 12]) {
                --n;
            }
        }
        return n;
    }

    private boolean removeNote(int n, List list) {
        for (MeasureComponent measureComponent : list) {
            NoteCoords noteCoords;
            if (!(measureComponent instanceof NoteCoords) || (noteCoords = (NoteCoords)measureComponent).getRealValue() != n) continue;
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            SongManager songManager = TuxGuitar.instance().getSongManager();
            songManager.getMeasureManager().removeNote(this.kit.getTablature().getCaret().getMeasureCoords().getMeasure(), noteCoords.getNote());
            TuxGuitar.instance().getTablatureEditor().getUndoManager().addEdit(undoableMeasureGeneric.endUndo());
            return true;
        }
        return false;
    }

    private void makeNote(int n, List list) {
        SongTrack songTrack = this.kit.getTablature().getCaret().getSongTrackCoords().getTrack();
        long l = this.kit.getTablature().getCaret().getPosition();
        int n2 = this.getStringForValue(songTrack, list, n);
        if (n2 > 0) {
            int n3 = n - songTrack.getString(n2).getValue();
            int n4 = this.kit.getTablature().getCaret().getVelocity();
            Duration duration = (Duration)this.kit.getTablature().getCaret().getDuration().clone();
            Note note = new Note(n3, l, duration, n4, n2, false, new NoteEffect());
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            TuxGuitar.instance().getSongManager().getMeasureManager().addNote(this.kit.getTablature().getCaret().getMeasureCoords().getMeasure(), note);
            TuxGuitar.instance().getTablatureEditor().getUndoManager().addEdit(undoableMeasureGeneric.endUndo());
            this.kit.getTablature().getCaret().getMeasureCoords().playBeat(note.getStart());
            this.kit.getTablature().getCaret().setStringNumber(note.getString());
        }
    }

    private void redrawTablature() {
        Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
        TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(caret.getMeasureCoords().getMeasure().getNumber(), false);
        TuxGuitar.instance().redraw();
    }

    private int getStringForValue(SongTrack songTrack, List list, int n) {
        int n2;
        int n3;
        ArrayList<InstrumentString> arrayList = new ArrayList<InstrumentString>();
        for (n3 = 1; n3 <= songTrack.stringCount(); ++n3) {
            n2 = 0;
            InstrumentString instrumentString = songTrack.getString(n3);
            for (MeasureComponent measureComponent : list) {
                NoteCoords noteCoords;
                if (!(measureComponent instanceof NoteCoords) || (noteCoords = (NoteCoords)measureComponent).getNote().getString() != instrumentString.getNumber()) continue;
                n2 = 1;
            }
            if (n2 != 0) continue;
            arrayList.add(instrumentString);
        }
        n3 = -1;
        n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            InstrumentString instrumentString = (InstrumentString)arrayList.get(i);
            int n4 = n - instrumentString.getValue();
            if (n4 < 0 || n3 >= 0 && n4 >= n3) continue;
            n2 = instrumentString.getNumber();
            n3 = n4;
        }
        return n2;
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
    }

    public void mouseEnter(MouseEvent mouseEvent) {
    }

    public void mouseHover(MouseEvent mouseEvent) {
    }
}

