/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.TimeSignature;

public class TablatureUtil {
    public static final int getStartPosition(Measure measure, long l, int n) {
        double d = (double)l - (double)measure.getStart();
        double d2 = 0.0;
        if (d > 0.0) {
            double d3 = d / 1000.0;
            d2 = d3 * (double)n;
        }
        return (int)d2;
    }

    public static List createDurations(long l) {
        ArrayList<Duration> arrayList = new ArrayList<Duration>();
        Duration duration = new Duration(1);
        duration.setDotted(true);
        long l2 = l;
        boolean bl = false;
        while (!bl) {
            long l3 = duration.getTime();
            if (l3 <= l2) {
                arrayList.add((Duration)duration.clone());
                l2 -= l3;
            } else if (duration.isDotted()) {
                duration.setDotted(false);
            } else {
                duration.setValue(duration.getValue() * 2);
                duration.setDotted(true);
            }
            if (duration.getValue() <= 64) continue;
            bl = true;
        }
        return arrayList;
    }

    public static long getBeatLength(TimeSignature timeSignature) {
        long l = 1000L;
        int n = timeSignature.getDenominator().getValue();
        switch (n) {
            case 8: {
                if (timeSignature.getNumerator() % 3 != 0) break;
                l += 500L;
            }
        }
        return l;
    }
}

