/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.SongCoords;
import org.herac.tuxguitar.gui.editors.tab.TablaturePaintListener;
import org.herac.tuxguitar.gui.editors.tab.edit.EditorKit;
import org.herac.tuxguitar.gui.editors.tab.layout.LinearViewLayout;
import org.herac.tuxguitar.gui.editors.tab.layout.PageViewLayout;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;

public class Tablature
extends Composite {
    public static final int ALLOW_PLAY_CACHE = 1;
    private int flags;
    private SongManager songManager;
    private SongCoords songCoords;
    private Caret caret;
    private int width;
    private int height;
    private ViewLayout viewLayout;
    private EditorKit editorKit;
    private Font defaultFont;
    private Font noteFont;
    private Font timeSignatureFont;
    private Font printerDefaultFont;
    private Font printerNoteFont;
    private Font printerTimeSignatureFont;
    private Font lyricFont;
    private Font graceFont;
    private Color lineColor;
    private Color scoreNoteColor;
    private Color tabNoteColor;
    private Color playNoteColor;
    private boolean locked;
    private int SCROLL_DELAY = 15;
    private long lastVScrollTime;
    private long lastHScrollTime;
    private MeasureCoords lastMeasure;
    private List lastComponents;

    public Tablature(Composite composite, int n) {
        super(composite, n);
        this.setBackground(new Color(this.getDisplay(), 255, 255, 255));
        this.editorKit = new EditorKit(this);
    }

    public void initGUI() {
        this.addPaintListener(new TablaturePaintListener(this));
        final Point point = new Point(0, 0);
        final ScrollBar scrollBar = this.getHorizontalBar();
        scrollBar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (Tablature.this.lastHScrollTime + (long)Tablature.this.SCROLL_DELAY < System.currentTimeMillis()) {
                    int n = scrollBar.getSelection();
                    int n2 = -n - point.x;
                    Rectangle rectangle = Tablature.this.getClientArea();
                    Tablature.this.getShell().scroll(n2, 0, 0, 0, rectangle.width, rectangle.height, false);
                    point.x = -n;
                    Tablature.this.redraw();
                    Tablature.this.lastHScrollTime = System.currentTimeMillis();
                }
            }
        });
        final ScrollBar scrollBar2 = this.getVerticalBar();
        scrollBar2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (Tablature.this.lastVScrollTime + (long)Tablature.this.SCROLL_DELAY < System.currentTimeMillis()) {
                    int n = scrollBar2.getSelection();
                    int n2 = -n - point.y;
                    Rectangle rectangle = Tablature.this.getBounds();
                    Tablature.this.getShell().scroll(0, n2, 0, 0, rectangle.width, rectangle.height, false);
                    point.y = -n;
                    Tablature.this.redraw();
                    Tablature.this.lastVScrollTime = System.currentTimeMillis();
                }
            }
        });
        this.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Tablature.this.updateScroll();
            }
        });
    }

    public void initDefaults() {
        this.songCoords = new SongCoords(this, this.songManager);
        this.caret = new Caret(this, this.songManager, this.songCoords);
    }

    public void updateTablature() {
        this.lastMeasure = null;
        this.lastComponents = null;
        this.getViewLayout().updateSong();
    }

    public void initCaret() {
        this.caret.update(1, 1000L, 1);
    }

    public void loadFlags() {
        this.flags = TuxGuitar.instance().getConfig().getIntConfigValue("tablature.flags");
    }

    public void loadFonts() {
        this.defaultFont = Tablature.getFont("font.default");
        this.noteFont = Tablature.getFont("font.note");
        this.timeSignatureFont = Tablature.getFont("font.time-signature");
        this.printerDefaultFont = Tablature.getFont("font.printer.default");
        this.printerNoteFont = Tablature.getFont("font.printer.note");
        this.printerTimeSignatureFont = Tablature.getFont("font.printer.time-signature");
        this.lyricFont = Tablature.getFont("font.lyric");
        this.graceFont = Tablature.getFont("font.grace");
    }

    public void loadColors() {
        this.lineColor = Tablature.getColor("color.line");
        this.scoreNoteColor = Tablature.getColor("color.score.note");
        this.tabNoteColor = Tablature.getColor("color.tab.note");
        this.playNoteColor = Tablature.getColor("color.play.note");
    }

    public synchronized void paintTablature(GC gC) {
        this.lock();
        int n = this.getHorizontalBar().getSelection();
        int n2 = this.getVerticalBar().getSelection();
        this.getViewLayout().paintSong(gC, this.getClientArea(), -n, -n2);
        this.width = this.viewLayout.getWidth();
        this.height = this.viewLayout.getHeight();
        this.updateScroll();
        if (this.getCaret().hasChanges() && !TuxGuitar.instance().getPlayer().isRunning()) {
            this.getCaret().setChanges(false);
            if (this.getCaret().getMeasureCoords() != null) {
                this.getViewLayout().followMeasure(this.getCaret().getMeasureCoords(), true);
            }
        }
        if (TuxGuitar.instance().getPlayer().isRunning()) {
            this.redrawPlayingMode(gC, true);
        }
        this.unlock();
    }

    public void updateScroll() {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.getClientArea();
        ScrollBar scrollBar = this.getHorizontalBar();
        ScrollBar scrollBar2 = this.getVerticalBar();
        scrollBar.setMaximum(this.width + 22);
        scrollBar2.setMaximum(this.height);
        scrollBar.setThumb(Math.min(rectangle.width, rectangle2.width));
        scrollBar2.setThumb(Math.min(rectangle.height, rectangle2.height));
    }

    public boolean moveScrollHorizontalTo(MeasureCoords measureCoords, int n, boolean bl) {
        if (measureCoords != null) {
            int n2 = this.getHorizontalBar().getSelection();
            int n3 = this.getClientArea().width;
            int n4 = measureCoords.getPosX();
            int n5 = measureCoords.getWidth();
            if (n5 > n3 && n4 + n5 > 0 && n4 < n3) {
                return true;
            }
            if (n4 < 0 || n4 + n5 > n3) {
                this.getHorizontalBar().setSelection(n2 + n4 - n);
                if (bl) {
                    this.redraw();
                }
                return true;
            }
        }
        return false;
    }

    public boolean moveScrollVerticalTo(MeasureCoords measureCoords, int n, boolean bl) {
        if (measureCoords != null) {
            int n2 = this.getVerticalBar().getSelection();
            int n3 = this.getClientArea().height;
            int n4 = measureCoords.getPosY();
            int n5 = measureCoords.getTs().getSize();
            if (n5 > n3 && n4 + n5 > 0 && n4 < n3) {
                return true;
            }
            if (n4 < 0 || n4 + n5 > n3) {
                this.getVerticalBar().setSelection(n2 + n4 - n);
                if (bl) {
                    this.redraw();
                }
                return true;
            }
        }
        return false;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public Font getNoteFont() {
        return this.noteFont;
    }

    public Font getTimeSignatureFont() {
        return this.timeSignatureFont;
    }

    public Font getPrinterDefaultFont() {
        return this.printerDefaultFont;
    }

    public Font getPrinterNoteFont() {
        return this.printerNoteFont;
    }

    public Font getPrinterTimeSignatureFont() {
        return this.printerTimeSignatureFont;
    }

    public Font getLyricFont() {
        return this.lyricFont;
    }

    public Font getGraceFont() {
        return this.graceFont;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public Color getPlayNoteColor() {
        return this.playNoteColor;
    }

    public Color getScoreNoteColor() {
        return this.scoreNoteColor;
    }

    public Color getTabNoteColor() {
        return this.tabNoteColor;
    }

    public void redraw() {
        if (!super.isDisposed()) {
            this.lock();
            this.lastMeasure = null;
            this.lastComponents = null;
            super.redraw();
        }
    }

    public void redrawPlayingMode() {
        if ((this.flags & 1) == 0) {
            this.redraw();
            return;
        }
        GC gC = new GC(this);
        this.redrawPlayingMode(gC, false);
        gC.dispose();
    }

    private void redrawPlayingMode(GC gC, boolean bl) {
        if (!(super.isDisposed() || this.isLocked() && !bl)) {
            this.lock();
            MeasureCoords measureCoords = TuxGuitar.instance().getEditorCache().getPlayingMeasure();
            List list = TuxGuitar.instance().getEditorCache().getPlayingComponents();
            if (measureCoords != null && list != null && measureCoords.hasTrack(this.getCaret().getSongTrackCoords().getTrack().getNumber()) && (bl || !this.getViewLayout().followMeasure(measureCoords, true))) {
                boolean bl2;
                boolean bl3 = bl2 = bl || this.lastMeasure == null || !this.lastMeasure.equals(measureCoords);
                if (this.lastMeasure != null && this.lastComponents != null && !this.lastMeasure.isOutOfBounds() && this.lastMeasure.hasTrack(this.getCaret().getSongTrackCoords().getTrack().getNumber())) {
                    this.getViewLayout().paintCacheMode(gC, this.lastMeasure, this.lastComponents, bl2, false);
                }
                if (!measureCoords.isOutOfBounds()) {
                    this.getViewLayout().paintCacheMode(gC, measureCoords, list, bl2, true);
                }
                this.lastMeasure = measureCoords;
                this.lastComponents = new ArrayList(list);
            }
            this.unlock();
        }
    }

    private void lock() {
        this.editorKit.tryBack();
        this.locked = true;
    }

    private void unlock() {
        this.locked = false;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void resetScroll() {
        this.getHorizontalBar().setSelection(0);
        this.getVerticalBar().setSelection(0);
    }

    public Caret getCaret() {
        return this.caret;
    }

    public EditorKit getEditorKit() {
        return this.editorKit;
    }

    public SongManager getSongManager() {
        return this.songManager;
    }

    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }

    public SongCoords getSongCoords() {
        return this.songCoords;
    }

    public void changeCursor(int n) {
        this.setCursor(new Cursor(this.getDisplay(), n));
    }

    public ViewLayout getViewLayout() {
        return this.viewLayout;
    }

    public void setViewLayout(ViewLayout viewLayout) {
        if (this.getViewLayout() != null) {
            this.getViewLayout().disposeLayout();
        }
        this.viewLayout = viewLayout;
        if (this.getHorizontalBar() != null) {
            this.getHorizontalBar().setSelection(0);
        }
        if (this.getVerticalBar() != null) {
            this.getVerticalBar().setSelection(0);
        }
    }

    public void reloadStyles() {
        this.disposeGraphics();
        this.loadFonts();
        this.loadColors();
    }

    public void reloadViewLayout() {
        boolean bl = TuxGuitar.instance().getConfig().getBooleanConfigValue("show.multitrack");
        boolean bl2 = TuxGuitar.instance().getConfig().getBooleanConfigValue("show.score");
        boolean bl3 = TuxGuitar.instance().getConfig().getBooleanConfigValue("show.tablature");
        int n = TuxGuitar.instance().getConfig().getIntConfigValue("layout.mode");
        n = n == 0 ? 2 : n;
        switch (n) {
            case 1: {
                this.setViewLayout(new PageViewLayout(this, this.songManager, bl, bl2, bl3));
                break;
            }
            case 2: {
                this.setViewLayout(new LinearViewLayout(this, this.songManager, bl, bl2, bl3));
            }
        }
    }

    private static final Font getFont(String string) {
        FontData fontData = TuxGuitar.instance().getConfig().getFontDataConfigValue(string);
        if (fontData == null) {
            fontData = new FontData();
        }
        return new Font((Device)TuxGuitar.instance().getDisplay(), fontData);
    }

    private static final Color getColor(String string) {
        RGB rGB = TuxGuitar.instance().getConfig().getRGBConfigValue(string);
        if (rGB == null) {
            rGB = new RGB(0, 0, 0);
        }
        return new Color(TuxGuitar.instance().getDisplay(), rGB);
    }

    public void dispose() {
        super.dispose();
        this.getViewLayout().disposeLayout();
        this.disposeGraphics();
    }

    public void disposeGraphics() {
        if (this.defaultFont != null) {
            this.defaultFont.dispose();
        }
        if (this.noteFont != null) {
            this.noteFont.dispose();
        }
        if (this.timeSignatureFont != null) {
            this.timeSignatureFont.dispose();
        }
        if (this.printerDefaultFont != null) {
            this.printerDefaultFont.dispose();
        }
        if (this.printerNoteFont != null) {
            this.printerNoteFont.dispose();
        }
        if (this.printerTimeSignatureFont != null) {
            this.printerTimeSignatureFont.dispose();
        }
        if (this.lyricFont != null) {
            this.lyricFont.dispose();
        }
        if (this.graceFont != null) {
            this.graceFont.dispose();
        }
        if (this.lineColor != null) {
            this.lineColor.dispose();
        }
        if (this.scoreNoteColor != null) {
            this.scoreNoteColor.dispose();
        }
        if (this.tabNoteColor != null) {
            this.tabNoteColor.dispose();
        }
        if (this.playNoteColor != null) {
            this.playNoteColor.dispose();
        }
    }
}

