/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gui.editors.tab.LyricPainter;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;

public class SongTrackCoords {
    private Tablature tablature;
    private SongManager songManager;
    private SongTrack track;
    private List measuresCoords;
    private LyricPainter lyricPainter;
    private int tabHeight;
    private int scoreHeight;

    public SongTrackCoords(Tablature tablature, SongManager songManager, SongTrack songTrack, ViewLayout viewLayout) {
        this.tablature = tablature;
        this.track = songTrack;
        this.songManager = songManager;
        this.measuresCoords = new ArrayList();
        this.lyricPainter = new LyricPainter(this);
        this.calculateTabHeight(viewLayout);
        this.calculateScoreHeight(viewLayout);
    }

    public void calculateTabHeight(ViewLayout viewLayout) {
        this.tabHeight = viewLayout.isTablatureEnabled() ? (this.getTrack().stringCount() - 1) * viewLayout.getStringSpan() : 0;
    }

    public void calculateScoreHeight(ViewLayout viewLayout) {
        this.scoreHeight = viewLayout.isScoreEnabled() ? viewLayout.getScoreLineSpan() * 5 : 0;
    }

    public List getMeasuresCoords() {
        return this.measuresCoords;
    }

    public SongTrack getTrack() {
        return this.track;
    }

    public MeasureCoords getFirstMeasure() {
        MeasureCoords measureCoords = null;
        for (int i = 0; i < this.measuresCoords.size(); ++i) {
            MeasureCoords measureCoords2 = (MeasureCoords)this.measuresCoords.get(i);
            if (measureCoords != null && measureCoords2.getMeasure().getStart() >= measureCoords.getMeasure().getStart()) continue;
            measureCoords = measureCoords2;
        }
        return measureCoords;
    }

    public MeasureCoords getLastMeasure() {
        int n = this.measuresCoords.size() - 1;
        return (MeasureCoords)this.measuresCoords.get(n);
    }

    public MeasureCoords getPrevMeasure(MeasureCoords measureCoords) {
        int n = measureCoords.getMeasure().getNumber() - 1;
        int n2 = n - 1;
        if (n2 >= 0) {
            return (MeasureCoords)this.measuresCoords.get(n2);
        }
        return null;
    }

    public MeasureCoords getNextMeasure(MeasureCoords measureCoords) {
        int n = measureCoords.getMeasure().getNumber() + 1;
        int n2 = n - 1;
        if (n2 < this.measuresCoords.size()) {
            return (MeasureCoords)this.measuresCoords.get(n2);
        }
        return null;
    }

    public MeasureCoords getMeasureCoords(long l) {
        Object var3_2 = null;
        for (int i = 0; i < this.measuresCoords.size(); ++i) {
            MeasureCoords measureCoords = (MeasureCoords)this.measuresCoords.get(i);
            long l2 = measureCoords.getMeasure().getStart();
            long l3 = measureCoords.getMeasure().getLength();
            if (l < l2 || l >= l2 + l3) continue;
            return measureCoords;
        }
        return null;
    }

    public MeasureCoords getMeasure(Measure measure) {
        MeasureCoords measureCoords = null;
        for (int i = 0; i < this.measuresCoords.size(); ++i) {
            MeasureCoords measureCoords2 = (MeasureCoords)this.measuresCoords.get(i);
            if (!measureCoords2.getMeasure().equals(measure)) continue;
            measureCoords = measureCoords2;
            break;
        }
        return measureCoords;
    }

    public MeasureCoords getMeasureAt(int n, int n2) {
        MeasureCoords measureCoords = null;
        int n3 = 0;
        for (MeasureCoords measureCoords2 : this.measuresCoords) {
            boolean bl;
            if (measureCoords2.isOutOfBounds() || measureCoords2.getTs() == null || !(bl = n >= measureCoords2.getPosX() && n <= measureCoords2.getPosX() + measureCoords2.getWidth() + measureCoords2.getSpan())) continue;
            int n4 = measureCoords2.getTs().getSize();
            int n5 = Math.min(Math.abs(n2 - measureCoords2.getPosY()), Math.abs(n2 - (measureCoords2.getPosY() + n4 - 10)));
            if (measureCoords != null && n5 >= n3) continue;
            measureCoords = measureCoords2;
            n3 = n5;
        }
        return measureCoords;
    }

    public boolean hasCaret() {
        return this.equals(this.tablature.getCaret().getSongTrackCoords());
    }

    public int getTabHeight() {
        return this.tabHeight;
    }

    public int getScoreHeight() {
        return this.scoreHeight;
    }

    public void setTabHeight(int n) {
        this.tabHeight = n;
    }

    public LyricPainter getLyricPainter() {
        return this.lyricPainter;
    }
}

