/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.MeasureHeaderGui;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.SongTrack;

public class SongCoords {
    private Tablature tablature;
    private SongManager songManager;
    private List tracksCoords;
    private List measureHeaders;

    public SongCoords(Tablature tablature, SongManager songManager) {
        this.tablature = tablature;
        this.songManager = songManager;
        this.init();
    }

    public void init() {
        this.tracksCoords = new ArrayList();
        this.measureHeaders = new ArrayList();
    }

    public void create(int n, int n2) {
        this.tracksCoords = new ArrayList(n);
        this.measureHeaders = new ArrayList(n2);
    }

    public SongTrackCoords getTrackAt(int n) {
        int n2 = this.tablature.getViewLayout().getTrackNumberAt(this.tracksCoords, n);
        if (n2 >= 0) {
            return this.getTrack(n2);
        }
        return null;
    }

    public SongTrackCoords getTrack(int n) {
        SongTrackCoords songTrackCoords = null;
        for (int i = 0; i < this.tracksCoords.size(); ++i) {
            SongTrackCoords songTrackCoords2 = (SongTrackCoords)this.tracksCoords.get(i);
            if (songTrackCoords2.getTrack().getNumber() != n) continue;
            songTrackCoords = songTrackCoords2;
            break;
        }
        return songTrackCoords;
    }

    public SongTrackCoords getNextTrack(SongTrackCoords songTrackCoords) {
        SongTrackCoords songTrackCoords2 = null;
        for (int i = 0; i < this.tracksCoords.size(); ++i) {
            SongTrackCoords songTrackCoords3 = (SongTrackCoords)this.tracksCoords.get(i);
            if (!songTrackCoords3.equals(songTrackCoords)) continue;
            int n = i + 1;
            if (n >= this.tracksCoords.size()) break;
            songTrackCoords2 = (SongTrackCoords)this.tracksCoords.get(n);
            break;
        }
        return songTrackCoords2;
    }

    public SongTrackCoords getPrevTrack(SongTrackCoords songTrackCoords) {
        SongTrackCoords songTrackCoords2 = null;
        for (int i = 0; i < this.tracksCoords.size(); ++i) {
            SongTrackCoords songTrackCoords3 = (SongTrackCoords)this.tracksCoords.get(i);
            if (!songTrackCoords3.equals(songTrackCoords)) continue;
            int n = i - 1;
            if (n < 0) break;
            songTrackCoords2 = (SongTrackCoords)this.tracksCoords.get(n);
            break;
        }
        return songTrackCoords2;
    }

    public SongTrackCoords getTrack(SongTrack songTrack) {
        SongTrackCoords songTrackCoords = null;
        for (int i = 0; i < this.tracksCoords.size(); ++i) {
            SongTrackCoords songTrackCoords2 = (SongTrackCoords)this.tracksCoords.get(i);
            if (!songTrackCoords2.getTrack().equals(songTrack)) continue;
            songTrackCoords = songTrackCoords2;
            break;
        }
        return songTrackCoords;
    }

    public SongTrackCoords getFirstTrack() {
        SongTrackCoords songTrackCoords = null;
        if (!this.tracksCoords.isEmpty()) {
            songTrackCoords = (SongTrackCoords)this.tracksCoords.get(0);
        }
        return songTrackCoords;
    }

    public SongTrackCoords getLastTrack() {
        SongTrackCoords songTrackCoords = null;
        if (!this.tracksCoords.isEmpty()) {
            songTrackCoords = (SongTrackCoords)this.tracksCoords.get(this.tracksCoords.size() - 1);
        }
        return songTrackCoords;
    }

    public SongManager getSongManager() {
        return this.songManager;
    }

    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }

    public List getTrackCoords() {
        return this.tracksCoords;
    }

    public SongTrackCoords getTrackByIndex(int n) {
        if (this.tracksCoords.size() > n) {
            return (SongTrackCoords)this.tracksCoords.get(n);
        }
        SongTrackCoords songTrackCoords = new SongTrackCoords(this.tablature, this.songManager, this.songManager.getTrack(n + 1), this.tablature.getViewLayout());
        this.tracksCoords.add(songTrackCoords);
        return songTrackCoords;
    }

    public MeasureHeaderGui getHeaderByIndex(int n) {
        if (this.measureHeaders.size() > n) {
            return (MeasureHeaderGui)this.measureHeaders.get(n);
        }
        MeasureHeaderGui measureHeaderGui = new MeasureHeaderGui(this.songManager.getMeasureHeader(n + 1));
        this.measureHeaders.add(measureHeaderGui);
        return measureHeaderGui;
    }

    public void disposeTracks() {
        for (int i = 0; i < this.tracksCoords.size(); ++i) {
            SongTrackCoords songTrackCoords = (SongTrackCoords)this.tracksCoords.get(i);
            for (int j = 0; j < songTrackCoords.getMeasuresCoords().size(); ++j) {
                MeasureCoords measureCoords = (MeasureCoords)songTrackCoords.getMeasuresCoords().get(j);
                measureCoords.dispose();
            }
        }
    }
}

