/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.DurationCoords;
import org.herac.tuxguitar.gui.editors.tab.MeasureComponent;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.MeasureTimeHelper;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;

public class NoteCoords
implements MeasureComponent {
    public static final int NATURAL = 0;
    public static final int SHARP = 1;
    public static final int FLAT = 2;
    public static final int[][] KEY_SIGNATURES = new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 0}, {1, 0, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 2}, {0, 0, 2, 0, 0, 0, 2}, {0, 0, 2, 0, 0, 2, 2}, {0, 2, 2, 0, 0, 2, 2}, {0, 2, 2, 0, 2, 2, 2}, {2, 2, 2, 0, 2, 2, 2}, {2, 2, 2, 2, 2, 2, 2}};
    public static final int[] SCORE_SHARP_NOTES = new int[]{0, 0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6};
    public static final int[] SCORE_FLAT_NOTES = new int[]{0, 1, 1, 2, 2, 3, 4, 4, 5, 5, 6, 6};
    public static final boolean[] NO_NATURAL_NOTES = new boolean[]{false, true, false, true, false, false, true, false, true, false, true, false};
    private static final int JOINED_TYPE_NONE_LEFT = 1;
    private static final int JOINED_TYPE_NONE_RIGHT = 2;
    private static final int JOINED_TYPE_LEFT = 3;
    private static final int JOINED_TYPE_RIGHT = 4;
    private boolean joinedGreaterThanQuarter;
    private Tablature tablature;
    private MeasureCoords meassureCoords;
    private Note note;
    private int realValue;
    private int posX;
    private int posY;
    private DurationCoords durationCoords;
    private int joinedType;
    private SongTrackCoords trackCoords;
    private MeasureTimeHelper measureTimeHelper;
    private Rectangle noteOrientation;
    private int scorePosY;

    public NoteCoords(Tablature tablature, SongTrackCoords songTrackCoords, MeasureCoords measureCoords, Note note, int n, int n2) {
        this.tablature = tablature;
        this.trackCoords = songTrackCoords;
        this.meassureCoords = measureCoords;
        this.note = note;
        this.posX = n;
        this.posY = n2;
        this.durationCoords = new DurationCoords();
        this.noteOrientation = new Rectangle(0, 0, 0, 0);
        this.calculateRealValue();
    }

    public void update(ViewLayout viewLayout) {
        int n = viewLayout.getStringSpan() / 2;
        this.joinedType = 2;
        this.joinedGreaterThanQuarter = false;
        this.durationCoords.setNote1(this);
        this.durationCoords.setNote2(this);
        boolean bl = false;
        boolean bl2 = false;
        MeasureComponent measureComponent = this.meassureCoords.getPreviousComponent(this);
        MeasureComponent measureComponent2 = this.meassureCoords.getNextComponent(this);
        NoteCoords noteCoords = null;
        NoteCoords noteCoords2 = null;
        if (measureComponent instanceof NoteCoords && this.meassureCoords.areInSameBeat(this, noteCoords = (NoteCoords)measureComponent)) {
            bl2 = true;
            if (noteCoords.getNote().getDuration().getValue() >= this.note.getDuration().getValue()) {
                this.durationCoords.setNote1(noteCoords);
                if (noteCoords2 == null || noteCoords2.getNote().getDuration().getValue() < this.note.getDuration().getValue()) {
                    this.durationCoords.setNote2(this);
                }
                bl = true;
                this.joinedType = 3;
            }
            if (noteCoords.getNote().getDuration().getValue() > 4) {
                this.joinedGreaterThanQuarter = true;
            }
        }
        if (measureComponent2 instanceof NoteCoords && this.meassureCoords.areInSameBeat(this, noteCoords2 = (NoteCoords)measureComponent2)) {
            if (noteCoords2.getNote().getDuration().getValue() >= this.note.getDuration().getValue()) {
                this.durationCoords.setNote2(noteCoords2);
                if (noteCoords == null || noteCoords.getNote().getDuration().getValue() < this.note.getDuration().getValue()) {
                    this.durationCoords.setNote1(this);
                }
                bl = true;
                this.joinedType = 4;
            }
            if (noteCoords2.getNote().getDuration().getValue() > 4) {
                this.joinedGreaterThanQuarter = true;
            }
        }
        if (!bl && bl2) {
            this.joinedType = 1;
        }
        this.scorePosY = this.measureTimeHelper.getY1(viewLayout, this, this.meassureCoords.getMeasure().getKeySignature(), this.meassureCoords.getMeasure().getClef());
        this.updateUsedStrings();
    }

    private void updateUsedStrings() {
        if (this.note.getDuration().getValue() >= 4) {
            boolean[] blArray = new boolean[this.trackCoords.getTrack().getStrings().size()];
            List list = this.meassureCoords.getComponents(this.getStart());
            for (MeasureComponent measureComponent : list) {
                if (!(measureComponent instanceof NoteCoords)) continue;
                NoteCoords noteCoords = (NoteCoords)measureComponent;
                blArray[noteCoords.getNote().getString() - 1] = true;
            }
            this.durationCoords.setUsedStrings(blArray);
        }
    }

    public void calculateRealValue() {
        this.realValue = this.getNote().getValue() + ((InstrumentString)this.trackCoords.getTrack().getStrings().get(this.getNote().getString() - 1)).getValue();
    }

    public void paint(ViewLayout viewLayout, GC gC, int n, int n2) {
        this.paintScoreNote(viewLayout, gC, n, n2 + this.meassureCoords.getTs().getPosition(2));
        this.paintOfflineEffects(viewLayout, gC, n, n2);
        this.paintTabNote(viewLayout, gC, n, n2 + this.meassureCoords.getTs().getPosition(12));
    }

    private void paintOfflineEffects(ViewLayout viewLayout, GC gC, int n, int n2) {
        int n3;
        int n4;
        NoteEffect noteEffect = this.getNote().getEffect();
        viewLayout.setOfflineEffectStyle(gC);
        if (noteEffect.isAccentuatedNote()) {
            n4 = n + this.getPosX() + this.getSpan();
            n3 = n2 + this.meassureCoords.getTs().getPosition(5);
            gC.drawString(">", n4, n3);
        } else if (noteEffect.isHeavyAccentuatedNote()) {
            n4 = n + this.getPosX() + this.getSpan();
            n3 = n2 + this.meassureCoords.getTs().getPosition(5);
            gC.drawString("^", n4, n3);
        }
        if (noteEffect.isFadeIn()) {
            n4 = n + this.getPosX() + this.getSpan();
            n3 = n2 + this.meassureCoords.getTs().getPosition(10);
            gC.drawString("<", n4, n3);
        }
        if (noteEffect.isHarmonic() && !viewLayout.isScoreEnabled()) {
            n4 = n + this.getPosX() + this.getSpan();
            n3 = n2 + this.meassureCoords.getTs().getPosition(6);
            String string = new String();
            string = noteEffect.getHarmonic().isNatural() ? "N.H" : string;
            string = noteEffect.getHarmonic().isArtificial() ? "A.H" : string;
            string = noteEffect.getHarmonic().isTapped() ? "T.H" : string;
            string = noteEffect.getHarmonic().isPinch() ? "P.H" : string;
            string = noteEffect.getHarmonic().isSemi() ? "S.H" : string;
            gC.drawString(string, n4, n3);
        }
        if (noteEffect.isTapping()) {
            n4 = n + this.getPosX() + this.getSpan();
            n3 = n2 + this.meassureCoords.getTs().getPosition(7);
            gC.drawString("T", n4, n3);
        } else if (noteEffect.isSlapping()) {
            n4 = n + this.getPosX() + this.getSpan();
            n3 = n2 + this.meassureCoords.getTs().getPosition(7);
            gC.drawString("S", n4, n3);
        } else if (noteEffect.isPopping()) {
            n4 = n + this.getPosX() + this.getSpan();
            n3 = n2 + this.meassureCoords.getTs().getPosition(7);
            gC.drawString("P", n4, n3);
        }
        if (noteEffect.isPalmMute()) {
            n4 = n + this.getPosX() + this.getSpan();
            n3 = n2 + this.meassureCoords.getTs().getPosition(8);
            gC.drawString("P.M", n4, n3);
        }
        if (noteEffect.isVibrato()) {
            n4 = n + this.getPosX() + this.getSpan();
            n3 = n2 + this.meassureCoords.getTs().getPosition(9);
            this.paintVibrato(gC, n4, n3);
        }
        if (noteEffect.isTrill()) {
            n4 = n + this.getPosX() + this.getSpan();
            n3 = n2 + this.meassureCoords.getTs().getPosition(9);
            this.paintTrill(gC, n4, n3);
        }
    }

    public void paintTabNote(ViewLayout viewLayout, GC gC, int n, int n2) {
        if (viewLayout.isTablatureEnabled()) {
            int n3;
            int n4;
            Object object;
            int n5 = n + this.getPosX() + this.getSpan() + 2;
            int n6 = n2 + this.getPosY();
            this.noteOrientation.x = n5;
            this.noteOrientation.y = n6;
            this.noteOrientation.width = 1;
            this.noteOrientation.height = 1;
            viewLayout.setNoteStyle(gC);
            if (viewLayout.isPlayModeEnabled() && this.isPlaying()) {
                viewLayout.setPlayNoteColor(gC);
            } else {
                viewLayout.setTabNoteColor(gC);
            }
            if (this.getNote().isTiedNote() && !viewLayout.isScoreEnabled()) {
                object = this.getNoteForTie();
                if (object != null) {
                    n4 = n + ((NoteCoords)object).getPosX() + ((NoteCoords)object).getSpan();
                    n3 = n2 + ((NoteCoords)object).getPosY() + 10;
                    gC.drawArc(n4, n3, n5 - n4, -30, 225, 90);
                } else {
                    Rectangle rectangle = viewLayout.getNoteOrientation(gC, n5, n6, this.note);
                    gC.drawArc(rectangle.x - 20, n2 + this.getPosY() + 10, 20, -30, 225, 90);
                }
            } else if (!this.getNote().isTiedNote()) {
                object = viewLayout.getNoteOrientation(gC, n5, n6, this.note);
                this.noteOrientation.x = ((Rectangle)object).x;
                this.noteOrientation.y = ((Rectangle)object).y;
                this.noteOrientation.width = ((Rectangle)object).width;
                this.noteOrientation.height = ((Rectangle)object).height;
                String string = this.note.getEffect().isDeadNote() ? "X" : Integer.toString(this.getNote().getValue());
                string = this.note.getEffect().isGhostNote() ? "(" + string + ")" : string;
                gC.drawString(string, this.noteOrientation.x, this.noteOrientation.y);
            }
            if (viewLayout.isPlayModeEnabled() && this.isPlaying()) {
                viewLayout.setTabNoteColor(gC);
            }
            this.paintEffects(viewLayout, gC, n, n2);
            if (!viewLayout.isScoreEnabled()) {
                int n7;
                int n8 = viewLayout.getStringSpan();
                n4 = n2 + this.meassureCoords.getTrackCoords().getTabHeight() + n8 / 2;
                n3 = n2 + this.meassureCoords.getTrackCoords().getTabHeight() + n8 / 2 * 5;
                if (this.note.getDuration().getValue() >= 4) {
                    boolean[] blArray = this.durationCoords.getUsedStrings();
                    for (n7 = this.getNote().getString() - 1; n7 < blArray.length; ++n7) {
                        if (blArray[n7]) continue;
                        int n9 = n2 + n8 * (n7 + 1) - n8;
                        int n10 = n9 + n8 / 2;
                        int n11 = n9 - n8 / 2;
                        n10 = n10 - n11 < n8 ? n10 + 1 : n10;
                        gC.drawLine(n5, n11, n5, n10);
                    }
                    gC.drawLine(n5, n4, n5, n3);
                    if (this.note.getDuration().getValue() >= 8) {
                        this.paintTabJoindeds(viewLayout, gC, n + 2, n3);
                    }
                } else if (this.note.getDuration().getValue() == 2) {
                    gC.drawLine(n5, n4 + (n3 - n4) / 2, n5, n3);
                }
                if (this.note.getDuration().isDotted() || this.note.getDuration().isDoubleDotted()) {
                    int n12 = this.note.getDuration().getValue() > 1 ? (this.joinedType == 2 || this.joinedType == 4 ? n5 + 4 : n5 - 5) : n5;
                    n7 = n3 - (this.note.getDuration().getValue() >= 8 ? n8 / 2 * (this.note.getDuration().log2() - 2) : 1);
                    gC.drawOval(n12, n7, 1, 1);
                    if (this.note.getDuration().isDoubleDotted()) {
                        gC.drawOval(n12 + 3, n7, 1, 1);
                    }
                }
                if (!this.note.getDuration().getTupleto().isEqual(Duration.NO_TUPLETO)) {
                    viewLayout.setTupletoStyle(gC);
                    gC.drawString(Integer.toString(this.note.getDuration().getTupleto().getEnters()), n5 - 3, n2 - this.meassureCoords.getTs().getPosition(12) + this.meassureCoords.getTs().getPosition(4));
                }
                if (this.note.getEffect().isTremoloPicking()) {
                    gC.setAdvanced(true);
                    gC.setLineWidth(2);
                    int n13 = n4 + (n3 - n4) / 2;
                    for (n7 = 8; n7 <= this.note.getEffect().getTremoloPicking().getDuration().getValue(); n7 += n7) {
                        gC.drawLine(n5 - 3, n13 - 1, n5 + 4, n13 + 1);
                        n13 += 4;
                    }
                    gC.setLineWidth(1);
                    gC.setAdvanced(false);
                }
            }
        }
    }

    private void paintScoreNote(ViewLayout viewLayout, GC gC, int n, int n2) {
        if (viewLayout.isScoreEnabled()) {
            int n3;
            int n4;
            boolean bl;
            int n5 = this.meassureCoords.getMeasure().getKeySignature();
            int n6 = this.meassureCoords.getMeasure().getClef();
            int n7 = this.getRealValue();
            int n8 = viewLayout.getScoreLineSpan();
            int n9 = n + this.getPosX() + this.getSpan();
            int n10 = n2 + this.getScorePosY();
            boolean bl2 = bl = viewLayout.isPlayModeEnabled() && this.isPlaying();
            if (bl) {
                viewLayout.setPlayNoteColor(gC);
            } else {
                viewLayout.setScoreNoteColor(gC);
            }
            if (this.getNote().isTiedNote()) {
                NoteCoords noteCoords = this.getNoteForTie();
                if (noteCoords != null) {
                    n4 = n + noteCoords.getPosX() + noteCoords.getSpan();
                    n3 = n2 + this.getScorePosY();
                    gC.drawArc(n4 + 3, n3 - 3, n9 - n4, 35, 45, 90);
                } else {
                    gC.drawArc(n9 - 20, n10 - 2, 20, 30, 45, 90);
                }
            }
            boolean bl3 = KEY_SIGNATURES[n5][SCORE_SHARP_NOTES[n7 % 12]] == 1;
            n4 = KEY_SIGNATURES[n5][SCORE_FLAT_NOTES[n7 % 12]] == 2 ? 1 : 0;
            n3 = NO_NATURAL_NOTES[n7 % 12];
            if (n5 <= 7) {
                if (n3 != 0 && !bl3) {
                    gC.drawImage(SystemImages.KEY_SHARP, n9 - 7, n10 - 1);
                }
                if (bl3 && n3 == 0) {
                    gC.drawImage(SystemImages.KEY_NATURAL, n9 - 7, n10 - 3);
                }
            } else {
                if (n3 != 0 && n4 == 0) {
                    gC.drawImage(SystemImages.KEY_FLAT, n9 - 7, n10 - 2);
                }
                if (n4 != 0 && n3 == 0) {
                    gC.drawImage(SystemImages.KEY_NATURAL, n9 - 7, n10 - 3);
                }
            }
            int n11 = viewLayout.getScoreLineSpan() - 2;
            if (this.note.getEffect().isHarmonic()) {
                gC.drawImage(viewLayout.getHarmonicNote(this.note.getDuration().getValue(), bl), n9, n10);
            } else {
                gC.drawImage(viewLayout.getScoreNote(this.note.getDuration().getValue(), bl), n9, n10);
            }
            if (this.note.getEffect().isGrace()) {
                Rectangle rectangle = SystemImages.GRACE_IMAGE.getBounds();
                gC.drawImage(SystemImages.GRACE_IMAGE, n9 - rectangle.width - 2, n10 - rectangle.height / 2 + 2);
            }
            if (bl) {
                viewLayout.setScoreNoteColor(gC);
            }
            if (this.note.getDuration().isDotted() || this.note.getDuration().isDoubleDotted()) {
                gC.setLineWidth(3);
                gC.drawOval(n9 + 13, n10 + 4, 1, 1);
                if (this.note.getDuration().isDoubleDotted()) {
                    gC.drawOval(n9 + 18, n10 + 4, 1, 1);
                }
                gC.setLineWidth(1);
            }
            if (!this.note.getDuration().getTupleto().isEqual(Duration.NO_TUPLETO)) {
                viewLayout.setTupletoStyle(gC);
                gC.drawString(Integer.toString(this.note.getDuration().getTupleto().getEnters()), n9, n2 - this.meassureCoords.getTs().getPosition(2) + this.meassureCoords.getTs().getPosition(4));
            }
            if (this.note.getDuration().getValue() >= 2) {
                gC.setAdvanced(true);
                if (this.measureTimeHelper.getDirection() == 1) {
                    n10 += viewLayout.getScoreLineSpan() / 3 + 1;
                    n9 += viewLayout.getScoreNoteWidth();
                    n += viewLayout.getScoreNoteWidth();
                } else {
                    n10 += viewLayout.getScoreLineSpan() / 3 * 2;
                }
                int n12 = n2 + this.measureTimeHelper.getY2(viewLayout, this.getPosX() + this.getSpan(), n5, n6);
                gC.drawLine(n9, n10, n9, n12);
                if (this.note.getDuration().getValue() >= 8) {
                    this.paintScoreJoindeds(viewLayout, gC, n, n2, n5, n6);
                }
                if (this.note.getEffect().isStaccato()) {
                    gC.setLineWidth(2);
                    gC.drawOval(n9, n12 + 4 * (this.measureTimeHelper.getDirection() == 1 ? -1 : 1), 1, 1);
                    gC.setLineWidth(1);
                }
                if (this.note.getEffect().isTremoloPicking()) {
                    gC.setLineWidth(2);
                    int n13 = n2;
                    n13 = this.measureTimeHelper.getDirection() == 1 ? (n13 += this.measureTimeHelper.getMaxNote().getScorePosY() - viewLayout.getScoreLineSpan() - 4) : (n13 += this.measureTimeHelper.getMinNote().getScorePosY() + viewLayout.getScoreLineSpan() + 4);
                    for (int i = 8; i <= this.note.getEffect().getTremoloPicking().getDuration().getValue(); i += i) {
                        gC.drawLine(n9 - 3, n13 + 1, n9 + 4, n13 - 1);
                        n13 += 4;
                    }
                    gC.setLineWidth(1);
                }
                gC.setAdvanced(false);
            } else {
                if (this.note.getEffect().isStaccato()) {
                    gC.setAdvanced(true);
                    gC.setLineWidth(2);
                    gC.drawOval(n9 + viewLayout.getScoreNoteWidth() / 2, n2 + this.measureTimeHelper.getMinNote().getScorePosY() + viewLayout.getScoreLineSpan() + 2, 1, 1);
                    gC.setLineWidth(1);
                    gC.setAdvanced(false);
                }
                if (this.note.getEffect().isTremoloPicking()) {
                    gC.setAdvanced(true);
                    gC.setLineWidth(2);
                    int n14 = n9 + viewLayout.getScoreNoteWidth() / 2;
                    int n15 = n2 + (this.measureTimeHelper.getMaxNote().getScorePosY() - viewLayout.getScoreLineSpan() - 4);
                    for (int i = 8; i <= this.note.getEffect().getTremoloPicking().getDuration().getValue(); i += i) {
                        gC.drawLine(n14 - 3, n15 + 1, n14 + 4, n15 - 1);
                        n15 += 4;
                    }
                    gC.setLineWidth(1);
                    gC.setAdvanced(false);
                }
            }
        }
    }

    public void paintTabJoindeds(ViewLayout viewLayout, GC gC, int n, int n2) {
        gC.setLineWidth(2);
        int n3 = 0;
        int n4 = 0;
        if (this.joinedType == 2) {
            n3 = this.getPosX() + this.getSpan();
            n4 = this.getPosX() + this.getSpan() + 6;
        } else if (this.joinedType == 1) {
            n3 = this.getPosX() + this.getSpan() - 5;
            n4 = this.getPosX() + this.getSpan();
        } else {
            n3 = this.durationCoords.getNote1().getPosX() + this.meassureCoords.getSpanForComponent(this.durationCoords.getNote1().getComponent());
            n4 = this.durationCoords.getNote2().getPosX() + this.meassureCoords.getSpanForComponent(this.durationCoords.getNote2().getComponent());
        }
        if (this.note.getDuration().getValue() >= 8) {
            int n5 = viewLayout.getStringSpan() / 2;
            for (int i = this.note.getDuration().log2() - 2; i > 0; --i) {
                gC.drawLine(n + n3, n2 + (n5 - i * n5), n + n4, n2 + (n5 - i * n5));
            }
        }
        gC.setLineWidth(1);
    }

    public void paintScoreJoindeds(ViewLayout viewLayout, GC gC, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n5 = this.measureTimeHelper.getDirection() == 2 ? 1 : -1;
        if (!(this.joinedType != 1 && this.joinedType != 2 || this.joinedGreaterThanQuarter)) {
            gC.setLineWidth(2);
            int n7 = n + this.getPosX() + this.getSpan();
            int n8 = n7 + 7;
            int n9 = n2 + this.measureTimeHelper.getY2(viewLayout, this.getPosX() + this.getSpan(), n3, n4);
            switch (this.note.getDuration().getValue()) {
                case 8: {
                    gC.drawLine(n7, n9, n8, n9 - 6 * n5);
                    break;
                }
                case 16: {
                    gC.drawLine(n7, n9, n8, n9 - 6 * n5);
                    gC.drawLine(n7, n9 - 5 * n5, n8, n9 - 5 * n5 - 6 * n5);
                    break;
                }
                case 32: {
                    gC.drawLine(n7, n9, n8, n9 - 6 * n5);
                    gC.drawLine(n7, n9 - 5 * n5, n8, n9 - 5 * n5 - 6 * n5);
                    gC.drawLine(n7, n9 - 10 * n5, n8, n9 - 10 * n5 - 6 * n5);
                    break;
                }
                case 64: {
                    gC.drawLine(n7, n9, n8, n9 - 6 * n5);
                    gC.drawLine(n7, n9 - 5 * n5, n8, n9 - 5 * n5 - 6 * n5);
                    gC.drawLine(n7, n9 - 10 * n5, n8, n9 - 10 * n5 - 6 * n5);
                    gC.drawLine(n7, n9 - 15 * n5, n8, n9 - 15 * n5 - 6 * n5);
                }
            }
            gC.drawLine(n8, (n9 += n5) - 6 * n5, n8, n9 - 6 * n5 - 16 * n5);
            gC.setLineWidth(1);
        } else {
            gC.setLineWidth(3);
            int n10 = 0;
            int n11 = 0;
            if (this.joinedType == 2) {
                n10 = this.getPosX() + this.getSpan();
                n11 = this.getPosX() + this.getSpan() + 6;
            } else if (this.joinedType == 1) {
                n10 = this.getPosX() + this.getSpan() - 5;
                n11 = this.getPosX() + this.getSpan();
            } else {
                n10 = this.durationCoords.getNote1().getPosX() + this.meassureCoords.getSpanForComponent(this.durationCoords.getNote1().getComponent());
                n11 = this.durationCoords.getNote2().getPosX() + this.meassureCoords.getSpanForComponent(this.durationCoords.getNote2().getComponent());
            }
            int n12 = n2 + this.measureTimeHelper.getY2(viewLayout, n10, n3, n4);
            int n13 = n2 + this.measureTimeHelper.getY2(viewLayout, n11, n3, n4);
            switch (this.note.getDuration().getValue()) {
                case 8: {
                    gC.drawLine(n + n10, n12, n + n11, n13);
                    break;
                }
                case 16: {
                    gC.drawLine(n + n10, n12, n + n11, n13);
                    gC.drawLine(n + n10, n12 - 5 * n5, n + n11, n13 - 5 * n5);
                    break;
                }
                case 32: {
                    gC.drawLine(n + n10, n12, n + n11, n13);
                    gC.drawLine(n + n10, n12 - 5 * n5, n + n11, n13 - 5 * n5);
                    gC.drawLine(n + n10, n12 - 10 * n5, n + n11, n13 - 10 * n5);
                    break;
                }
                case 64: {
                    gC.drawLine(n + n10, n12, n + n11, n13);
                    gC.drawLine(n + n10, n12 - 5 * n5, n + n11, n13 - 5 * n5);
                    gC.drawLine(n + n10, n12 - 10 * n5, n + n11, n13 - 10 * n5);
                    gC.drawLine(n + n10, n12 - 15 * n5, n + n11, n13 - 15 * n5);
                }
            }
            gC.setLineWidth(1);
        }
    }

    private NoteCoords getNoteForTie() {
        List list = this.meassureCoords.getComponentsBeforeEnd(this.meassureCoords.getMeasure().getStart());
        for (int i = list.size() - 1; i >= 0; --i) {
            NoteCoords noteCoords;
            MeasureComponent measureComponent = (MeasureComponent)list.get(i);
            if (measureComponent.getStart() >= this.getNote().getStart() || !(measureComponent instanceof NoteCoords) || (noteCoords = (NoteCoords)measureComponent).getNote().getString() != this.getNote().getString()) continue;
            return noteCoords;
        }
        return null;
    }

    private void paintEffects(ViewLayout viewLayout, GC gC, int n, int n2) {
        Object object;
        int n3 = n + this.getPosX() + this.getSpan();
        int n4 = n2 + this.getPosY();
        NoteEffect noteEffect = this.getNote().getEffect();
        if (noteEffect.isGrace()) {
            viewLayout.setGraceStyle(gC);
            String string = Integer.toString(noteEffect.getGrace().getFret());
            object = gC.stringExtent(string);
            gC.drawString(string, this.noteOrientation.x - ((Point)object).x - 2, this.noteOrientation.y);
        }
        if (noteEffect.isBend()) {
            gC.drawImage(SystemImages.BEND_IMAGE, this.noteOrientation.x + this.noteOrientation.width, this.noteOrientation.y - SystemImages.BEND_IMAGE.getBounds().height / 2);
        } else if (noteEffect.isTremoloBar()) {
            gC.drawImage(SystemImages.TREMOLO_BAR, this.noteOrientation.x + this.noteOrientation.width, this.noteOrientation.y + this.noteOrientation.height / 2);
        } else if (noteEffect.isSlide() || noteEffect.isHammer()) {
            int n5 = n;
            object = this.meassureCoords.getNextNoteComponent(this, this.getNote().getString());
            if (noteEffect.isSlide()) {
                if (object != null) {
                    NoteCoords noteCoords = (NoteCoords)object;
                    int n6 = noteCoords.getPosX() + n5 + this.meassureCoords.getSpanForComponent(noteCoords.getComponent());
                    int n7 = n4;
                    if (noteCoords.getNote().getValue() < this.getNote().getValue()) {
                        n4 -= 3;
                        n7 += 3;
                    } else if (noteCoords.getNote().getValue() > this.getNote().getValue()) {
                        n4 += 3;
                        n7 -= 3;
                    } else {
                        n4 -= 3;
                        n7 -= 3;
                    }
                    gC.drawLine(n3 + 5, n4, n6 - 2, n7);
                } else {
                    gC.drawLine(n3 + 5, n4 - 3, n3 + 20 - 2, n4 - 3);
                }
            } else if (noteEffect.isHammer()) {
                if (object != null) {
                    NoteCoords noteCoords = (NoteCoords)object;
                    int n8 = noteCoords.getPosX() + n5 + this.meassureCoords.getSpanForComponent(noteCoords.getComponent());
                    gC.drawArc(n3 + 5, n4 - 5, n8 - 6 - (n3 + 5), 15, 45, 90);
                } else {
                    gC.drawArc(n3 + 5, n4 - 5, 10, 15, 45, 90);
                }
            }
        }
    }

    private void paintVibrato(GC gC, int n, int n2) {
        int n3 = this.getWidth();
        int n4 = 0;
        int n5 = 0;
        int n6 = 2;
        int n7 = 2;
        int n8 = -1;
        gC.setLineWidth(1);
        for (int i = n; i < n + n3 - 5; i += n6) {
            n4 = n2 + n7 * (n8 *= -1) + 6;
            n5 = n2 - n7 * n8 + 6;
            gC.drawLine(i, n4, i + n6 + 1, n5);
        }
        gC.setLineWidth(1);
    }

    private void paintTrill(GC gC, int n, int n2) {
        int n3 = this.getWidth();
        int n4 = 0;
        int n5 = 0;
        int n6 = 2;
        int n7 = 2;
        int n8 = -1;
        int n9 = 9;
        gC.setLineWidth(1);
        gC.drawString("tr", n, n2);
        for (int i = n + n9; i < n + n3 - n9; i += n6) {
            n4 = n2 + n7 * (n8 *= -1) + 6;
            n5 = n2 - n7 * n8 + 6;
            gC.drawLine(i, n4, i + n6 + 1, n5);
        }
    }

    public boolean isPlaying() {
        long l;
        return this.meassureCoords.isPlaying() && (l = TuxGuitar.instance().getPlayer().getTickPosition()) >= this.getNote().getStart() && l < this.getNote().getStart() + this.getNote().getDuration().getTime();
    }

    private int getWidth() {
        double d = 1.0 / (double)this.getNote().getDuration().getValue() * 4.0;
        int n = (int)((double)this.meassureCoords.getQuarterSpan() * d);
        return n;
    }

    public void setStart(long l) {
        this.note.setStart(l);
    }

    public long getStart() {
        return this.note.getStart();
    }

    public void setDuration(Duration duration) {
        this.note.setDuration(duration);
    }

    public Duration getDuration() {
        return this.note.getDuration();
    }

    public Note getNote() {
        return this.note;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getSpan() {
        return this.meassureCoords.getSpanForComponent(this.getComponent());
    }

    public int getRealValue() {
        return this.realValue;
    }

    public MeasureTimeHelper getMeasureTimeHelper() {
        return this.measureTimeHelper;
    }

    public void setMeasureTimeHelper(MeasureTimeHelper measureTimeHelper) {
        this.measureTimeHelper = measureTimeHelper;
    }

    public Component getComponent() {
        return this.getNote();
    }

    public int getScorePosY() {
        return this.scorePosY;
    }
}

