/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.models.MeasureHeader;

public class MeasureHeaderGui {
    public static final int DEFAULT_TIME_SIGNATURE_SPAN = 40;
    public static final int DEFAULT_LEFT_SPAN = 15;
    public static final int DEFAULT_RIGHT_SPAN = 15;
    private static final int PAINT_TEMPO = 1;
    private static final int PAINT_TRIPLET_FEEL = 2;
    private static final int PAINT_TIME_SIGNATURE = 4;
    private MeasureHeader header;
    private int paintFlags;
    private int maxQuarterSpan;
    private int maxClefSpan;
    private int maxKeySignatureSpan;
    private int width;

    public MeasureHeaderGui(MeasureHeader measureHeader) {
        this.header = measureHeader;
    }

    public void reset() {
        this.paintFlags = 0;
        this.maxQuarterSpan = 0;
        this.maxClefSpan = 0;
        this.maxKeySignatureSpan = 0;
    }

    public void update(ViewLayout viewLayout) {
        this.reset();
        this.calculateMeasureChanges(viewLayout);
        this.calculateWidth();
    }

    public void calculateMeasureChanges(ViewLayout viewLayout) {
        MeasureHeader measureHeader = viewLayout.getSongManager().getPrevMeasureHeader(this.header);
        if (measureHeader == null) {
            this.paintFlags |= 1;
            this.paintFlags |= this.header.getTripletFeel() != 1 ? 2 : 0;
            this.paintFlags |= 4;
        } else {
            if (this.header.getTempo().getValue() != measureHeader.getTempo().getValue()) {
                this.paintFlags |= 1;
            }
            if (this.header.getTripletFeel() != measureHeader.getTripletFeel()) {
                this.paintFlags |= 2;
            }
            int n = this.header.getTimeSignature().getNumerator();
            int n2 = this.header.getTimeSignature().getDenominator().getValue();
            int n3 = measureHeader.getTimeSignature().getNumerator();
            int n4 = measureHeader.getTimeSignature().getDenominator().getValue();
            if (n != n3 || n2 != n4) {
                this.paintFlags |= 4;
            }
        }
    }

    public void calculateWidth() {
        double d = 1.0 / (double)this.header.getTimeSignature().getDenominator().getValue() * 4.0 * (double)this.header.getTimeSignature().getNumerator();
        this.width = (int)((double)this.getMaxQuarterSpan() * d);
        this.width += this.getFirstNoteSpan();
        this.width += this.header.getNumberOfRepetitions() > 0 ? 20 : 0;
        this.width += 15;
        this.width += 15;
    }

    public boolean shouldPaintTempo() {
        return (this.paintFlags & 1) != 0;
    }

    public boolean shouldPaintTripletFeel() {
        return (this.paintFlags & 2) != 0;
    }

    public boolean shouldPaintTimeSignature() {
        return (this.paintFlags & 4) != 0;
    }

    public int getMaxQuarterSpan() {
        return this.maxQuarterSpan;
    }

    public void notifyQuarterSpan(int n) {
        this.maxQuarterSpan = n > this.maxQuarterSpan ? n : this.maxQuarterSpan;
    }

    public int getTempoSpan() {
        return this.shouldPaintTempo() ? 50 : 0;
    }

    public int getTripletFeelSpan() {
        return this.shouldPaintTripletFeel() ? 50 : 0;
    }

    public int getTimeSignatureSpan() {
        return this.shouldPaintTimeSignature() ? 40 : 0;
    }

    public int getClefSpan() {
        return this.maxClefSpan;
    }

    public int getKeySignatureSpan() {
        return this.maxKeySignatureSpan;
    }

    public int getFirstNoteSpan() {
        boolean bl = false;
        int n = this.getTempoSpan() + this.getTripletFeelSpan();
        int n2 = this.getClefSpan() + this.getKeySignatureSpan() + this.getTimeSignatureSpan();
        return Math.max(n, n2);
    }

    public void notifyClefSpan(int n) {
        this.maxClefSpan = n > this.maxClefSpan ? n : this.maxClefSpan;
    }

    public void notifyKeySignatureSpan(int n) {
        this.maxKeySignatureSpan = n > this.maxKeySignatureSpan ? n : this.maxKeySignatureSpan;
    }

    public int getWidth() {
        return this.width;
    }
}

