/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.CacheImage;
import org.herac.tuxguitar.gui.editors.tab.MeasureComponent;
import org.herac.tuxguitar.gui.editors.tab.MeasureHeaderGui;
import org.herac.tuxguitar.gui.editors.tab.MeasureTimeHelper;
import org.herac.tuxguitar.gui.editors.tab.NoteCoords;
import org.herac.tuxguitar.gui.editors.tab.SilenceCoords;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.TablatureUtil;
import org.herac.tuxguitar.gui.editors.tab.layout.TrackSpacing;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.Silence;

public class MeasureCoords {
    public static final int[] SCORE_KEY_OFFSETS = new int[]{30, 18, 22, 24};
    private static final int[] SCORE_NATURAL_POSITIONS = new int[]{7, 7, 6, 6, 5, 4, 4, 3, 3, 2, 2, 1};
    public static final int DEFAULT_CLEF_SPAN = 40;
    public static final int DEFAULT_QUARTER_SPAN = 30;
    private Tablature tablature;
    private MeasureHeaderGui header;
    private int posX;
    private int posY;
    private int quarterSpan;
    private long beatLength;
    private boolean paintClef = true;
    private boolean paintKeySignature = true;
    private List measureComponents;
    private Measure measure;
    private Measure prevMeasure;
    private SongTrackCoords trackCoords;
    private SongManager songManager;
    private boolean outOfBounds;
    private boolean firstOfLine;
    private Rectangle clefSrcBounds;
    private Rectangle clefDstBounds;
    private int span;
    private TrackSpacing ts;
    private int maxY;
    private int minY;
    private List timeHelpers;
    private List beatPositions;
    private CacheImage cache;
    private boolean cacheEnabled;
    private int lastEffectSpan;
    private int lyricBeatIndex;
    private boolean accentuated;
    private boolean harmonic;
    private boolean tapping;
    private boolean palmMute;
    private boolean vibrato;
    private boolean tupleto;
    private boolean fadeIn;

    public MeasureCoords(SongManager songManager, Tablature tablature, MeasureHeaderGui measureHeaderGui, Measure measure, SongTrackCoords songTrackCoords) {
        this.measure = measure;
        this.header = measureHeaderGui;
        this.trackCoords = songTrackCoords;
        this.tablature = tablature;
        this.songManager = songManager;
        this.measureComponents = new ArrayList();
        this.beatPositions = new ArrayList();
        this.timeHelpers = new ArrayList();
        this.cache = new CacheImage(tablature.getDisplay());
    }

    public void create(ViewLayout viewLayout) {
        this.measureComponents.clear();
        this.beatLength = TablatureUtil.getBeatLength(this.getMeasure().getTimeSignature());
        this.autoCompleteSilences();
        this.calculateQuarterSpan(viewLayout);
        this.calculateMeasureChanges(viewLayout);
        this.header.notifyQuarterSpan(this.getQuarterSpan());
    }

    public void update(ViewLayout viewLayout) {
        this.setQuarterSpan(this.header.getMaxQuarterSpan());
        this.resetEffects();
        this.orderNotes();
        this.calculateClefBounds(viewLayout);
        this.calcuateComponents(viewLayout);
        this.updateComponents(viewLayout);
        this.orderComponents();
        this.setOutOfBounds(true);
        this.setCacheEnabled(false);
    }

    private void calculateQuarterSpan(ViewLayout viewLayout) {
        if (this.measure.getNotes().isEmpty() && this.measure.getSilences().isEmpty()) {
            this.quarterSpan = 30;
        } else {
            Component component;
            int n;
            Component component2;
            Duration duration = null;
            if (!this.measure.getNotes().isEmpty()) {
                component2 = null;
                for (n = 0; n < this.measure.getNotes().size(); ++n) {
                    component = (Note)this.measure.getNotes().get(n);
                    if (component2 != null && ((Note)component).getDuration().getTime() > ((Note)component2).getDuration().getTime()) continue;
                    component2 = component;
                }
                duration = ((Note)component2).getDuration();
            }
            if (!this.measure.getSilences().isEmpty()) {
                component2 = null;
                for (n = 0; n < this.measure.getSilences().size(); ++n) {
                    component = (Silence)this.measure.getSilences().get(n);
                    if (component2 != null && ((Silence)component).getDuration().getTime() > ((Silence)component2).getDuration().getTime()) continue;
                    component2 = component;
                }
                if (duration == null || ((Silence)component2).getDuration().getTime() <= duration.getTime()) {
                    duration = ((Silence)component2).getDuration();
                }
            }
            this.quarterSpan = viewLayout.getSpanForQuarter(duration);
        }
    }

    public void calculateMeasureChanges(ViewLayout viewLayout) {
        this.paintClef = false;
        this.paintKeySignature = false;
        if (viewLayout.isScoreEnabled()) {
            MeasureCoords measureCoords = null;
            if (!viewLayout.isFirstMeasure(this.getMeasure()) && (measureCoords = this.trackCoords.getPrevMeasure(this)) != null) {
                this.prevMeasure = measureCoords.getMeasure();
            }
            if (this.prevMeasure == null || this.getMeasure().getClef() != this.prevMeasure.getClef()) {
                this.paintClef = true;
                this.header.notifyClefSpan(40);
            }
            if (this.prevMeasure == null || this.getMeasure().getKeySignature() != this.prevMeasure.getKeySignature()) {
                this.paintKeySignature = true;
                this.header.notifyKeySignatureSpan(this.calculateKeySignatureSpan());
            }
        }
    }

    private void calculateClefBounds(ViewLayout viewLayout) {
        if (this.paintClef) {
            if (this.measure.getClef() == 1) {
                this.clefSrcBounds = SystemImages.CLEF_TREBLE.getBounds();
            } else if (this.measure.getClef() == 2) {
                this.clefSrcBounds = SystemImages.CLEF_BASS.getBounds();
            } else if (this.measure.getClef() == 3) {
                this.clefSrcBounds = SystemImages.CLEF_TENOR.getBounds();
            } else if (this.measure.getClef() == 4) {
                this.clefSrcBounds = SystemImages.CLEF_ALTO.getBounds();
            }
            this.clefDstBounds = new Rectangle(this.clefSrcBounds.x, this.clefSrcBounds.y, this.clefSrcBounds.width, viewLayout.getScoreLineSpan() * this.clefSrcBounds.height / 10);
        }
    }

    private void calcuateComponents(ViewLayout viewLayout) {
        this.measureComponents.clear();
        this.calculateComponentsCoords(viewLayout);
    }

    private void calculateComponentsCoords(ViewLayout viewLayout) {
        Component component;
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.header.getFirstNoteSpan();
        for (n = 0; n < this.measure.getNotes().size(); ++n) {
            component = (Note)this.measure.getNotes().get(n);
            n3 = ((Note)component).getString() * viewLayout.getStringSpan() - viewLayout.getStringSpan();
            n2 = TablatureUtil.getStartPosition(this.measure, ((Note)component).getStart(), this.quarterSpan) + 10;
            this.measureComponents.add(new NoteCoords(this.tablature, this.trackCoords, this, (Note)component, n2 + n4, n3));
        }
        for (n = 0; n < this.measure.getSilences().size(); ++n) {
            component = (Silence)this.measure.getSilences().get(n);
            n2 = TablatureUtil.getStartPosition(this.measure, ((Silence)component).getStart(), this.quarterSpan) + 10;
            this.measureComponents.add(new SilenceCoords(this.tablature, this, (Silence)component, n2 + n4));
        }
    }

    private void autoCompleteSilences() {
        this.songManager.getMeasureManager().autoCompleteSilences(this.measure);
    }

    private void updateComponents(ViewLayout viewLayout) {
        this.beatPositions.clear();
        this.timeHelpers.clear();
        this.maxY = 0;
        this.minY = 0;
        MeasureTimeHelper measureTimeHelper = null;
        BeatPosition beatPosition = null;
        Object object = null;
        for (Object object2 : this.measureComponents) {
            if (object2 instanceof NoteCoords) {
                Object object3 = (NoteCoords)object2;
                if (object == null || !this.areInSameBeat((MeasureComponent)object, (MeasureComponent)object2)) {
                    measureTimeHelper = new MeasureTimeHelper();
                    this.timeHelpers.add(measureTimeHelper);
                }
                if (object == null || object2.getStart() != ((NoteCoords)object).getStart()) {
                    beatPosition = new BeatPosition(((NoteCoords)object3).getStart(), ((NoteCoords)object3).getDuration(), ((NoteCoords)object3).getPosX());
                    this.beatPositions.add(beatPosition);
                }
                this.checkEffects(viewLayout, ((NoteCoords)object3).getNote().getEffect());
                beatPosition.checkValues((NoteCoords)object3);
                measureTimeHelper.check((NoteCoords)object3, this.getMeasure().getClef());
                ((NoteCoords)object3).setMeasureTimeHelper(measureTimeHelper);
                object = object3;
            }
            if (!object2.getDuration().getTupleto().isEqual(Duration.NO_TUPLETO)) {
                this.tupleto = true;
            }
            object2.update(viewLayout);
        }
        if (ViewLayout.AUTO_SPACING_ENABLED) {
            for (Object object3 : this.timeHelpers) {
                this.checkValue(((MeasureTimeHelper)object3).getMinNote(), ((MeasureTimeHelper)object3).getDirection());
                this.checkValue(((MeasureTimeHelper)object3).getMaxNote(), ((MeasureTimeHelper)object3).getDirection());
            }
        }
    }

    private void checkValue(NoteCoords noteCoords, int n) {
        int n2 = noteCoords.getScorePosY();
        if (n == 1 && n2 > this.maxY) {
            this.maxY = n2;
        } else if (n == 2 && n2 + 35 > this.maxY) {
            this.maxY = n2 + 35 + 2;
        }
        if (n == 1 && n2 - 28 < this.minY) {
            this.minY = n2 - 28 - 2;
        } else if (n == 2 && n2 < this.minY) {
            this.minY = n2;
        }
    }

    private void checkEffects(ViewLayout viewLayout, NoteEffect noteEffect) {
        if (noteEffect.isAccentuatedNote() || noteEffect.isHeavyAccentuatedNote()) {
            this.accentuated = true;
        }
        if (noteEffect.isHarmonic() && !viewLayout.isScoreEnabled()) {
            this.harmonic = true;
        }
        if (noteEffect.isTapping() || noteEffect.isSlapping() || noteEffect.isPopping()) {
            this.tapping = true;
        }
        if (noteEffect.isPalmMute()) {
            this.palmMute = true;
        }
        if (noteEffect.isFadeIn()) {
            this.fadeIn = true;
        }
        if (noteEffect.isVibrato() || noteEffect.isTrill()) {
            this.vibrato = true;
        }
    }

    private void resetEffects() {
        this.tupleto = false;
        this.accentuated = false;
        this.harmonic = false;
        this.tapping = false;
        this.palmMute = false;
        this.fadeIn = false;
        this.vibrato = false;
    }

    public void registerEffects(TrackSpacing trackSpacing) {
        if (this.tupleto) {
            trackSpacing.setSize(4, 10);
        }
        if (this.accentuated) {
            trackSpacing.setSize(5, 8);
        }
        if (this.harmonic) {
            trackSpacing.setSize(6, 8);
        }
        if (this.tapping) {
            trackSpacing.setSize(7, 8);
        }
        if (this.palmMute) {
            trackSpacing.setSize(8, 8);
        }
        if (this.fadeIn) {
            trackSpacing.setSize(10, 8);
        }
        if (this.vibrato) {
            trackSpacing.setSize(9, 8);
        }
    }

    private void orderNotes() {
        this.songManager.getMeasureManager().orderNotes(this.measure);
    }

    private void orderComponents() {
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent = null;
            for (int j = i; j < this.measureComponents.size(); ++j) {
                MeasureComponent measureComponent2 = (MeasureComponent)this.measureComponents.get(j);
                if (measureComponent != null && measureComponent2.getStart() >= measureComponent.getStart()) continue;
                measureComponent = measureComponent2;
            }
            this.measureComponents.remove(measureComponent);
            this.measureComponents.add(i, measureComponent);
        }
    }

    public void paintMeasure(ViewLayout viewLayout, GC gC, Rectangle rectangle) {
        this.setOutOfBounds(false);
        if (this.shouldRepaint()) {
            this.cache.setSize(this.getWidth() + this.getSpan(), this.getTs().getSize());
            GC gC2 = this.cache.getGC();
            viewLayout.setDefaultStyle(gC2);
            viewLayout.paintLines(this.trackCoords, this.getTs(), gC2, 0, 0, this.getWidth() + this.getSpan());
            this.paintTimeSignature(viewLayout, gC2);
            this.paintClef(viewLayout, gC2);
            this.paintKeySignature(viewLayout, gC2);
            this.paintComponents(viewLayout, gC2, rectangle);
            this.setCacheEnabled(true);
        }
        this.cache.paintImage(gC, this.getPosX(), this.getPosY());
        viewLayout.setDefaultStyle(gC);
        gC.setForeground(this.tablature.getDisplay().getSystemColor(2));
        this.paintTempo(viewLayout, gC);
        this.paintTripletFeel(viewLayout, gC);
        this.paintDivisions(viewLayout, gC);
        this.paintPlayMode(viewLayout, gC);
    }

    private boolean shouldRepaint() {
        return this.isDisposed() || !this.isCacheEnabled();
    }

    public void paintComponents(ViewLayout viewLayout, GC gC, Rectangle rectangle) {
        Object object;
        int n;
        long l = 0L;
        if (viewLayout.isScoreEnabled()) {
            for (n = 0; n < this.beatPositions.size(); ++n) {
                object = (BeatPosition)this.beatPositions.get(n);
                ((BeatPosition)object).paintExtraLines(gC, viewLayout);
            }
        }
        for (n = 0; n < this.measureComponents.size(); ++n) {
            object = (MeasureComponent)this.measureComponents.get(n);
            object.paint(viewLayout, gC, 15, 0);
        }
    }

    private void paintDivisions(ViewLayout viewLayout, GC gC) {
        int n;
        int n2;
        if (viewLayout.isScoreEnabled()) {
            n2 = this.getPosY() + this.getTs().getPosition(2);
            int n3 = n = n2 + viewLayout.getScoreLineSpan() * 4;
            if (viewLayout.isTablatureEnabled() && (viewLayout.isFirstMeasure(this.getMeasure()) || this.isFirstOfLine())) {
                n3 = this.getPosY() + this.ts.getPosition(12);
            }
            String string = Integer.toString(this.measure.getNumber());
            gC.setForeground(this.tablature.getDisplay().getSystemColor(3));
            gC.drawString(string, this.getPosX() + 1, n2 - gC.stringExtent((String)string).y);
            gC.setForeground(this.tablature.getDisplay().getSystemColor(2));
            if (this.measure.isRepeatStart()) {
                gC.setLineWidth(3);
                gC.drawLine(this.getPosX(), n2, this.getPosX(), n3 + 1);
                gC.drawOval(this.getPosX() + 7, n2 + (n - n2) / 2 - 7, 1, 2);
                gC.drawOval(this.getPosX() + 7, n2 + (n - n2) / 2 + 7, 1, 2);
                gC.setLineWidth(1);
                gC.drawLine(this.getPosX() + 3, n2, this.getPosX() + 3, n3);
            } else if (viewLayout.isFirstMeasure(this.getMeasure())) {
                gC.setLineWidth(3);
                gC.drawLine(this.getPosX(), n2, this.getPosX(), n3 + 1);
                gC.setLineWidth(1);
                gC.drawLine(this.getPosX() + 3, n2, this.getPosX() + 3, n3);
            } else {
                gC.drawLine(this.getPosX(), n2, this.getPosX(), n3);
            }
            if (this.measure.getNumberOfRepetitions() > 0) {
                gC.setLineWidth(3);
                gC.drawLine(this.getPosX() + this.getWidth() - 1 + this.getSpan(), n2, this.getPosX() + this.getWidth() - 1 + this.getSpan(), n + 1);
                gC.drawOval(this.getPosX() + this.getWidth() - 9 + this.getSpan(), n2 + (n - n2) / 2 - 7, 1, 2);
                gC.drawOval(this.getPosX() + this.getWidth() - 9 + this.getSpan(), n2 + (n - n2) / 2 + 7, 1, 2);
                gC.setLineWidth(1);
                gC.drawLine(this.getPosX() + this.getWidth() - 4 + this.getSpan(), n2, this.getPosX() + this.getWidth() - 4 + this.getSpan(), n);
                String string2 = "x" + Integer.toString(this.measure.getNumberOfRepetitions());
                gC.drawString(string2, this.getPosX() + this.getWidth() - gC.stringExtent((String)string2).x + this.getSpan(), n2 - gC.stringExtent((String)string2).y);
            } else if (viewLayout.isLastMeasure(this.getMeasure())) {
                gC.setLineWidth(3);
                gC.drawLine(this.getPosX() + this.getWidth() + this.getSpan(), n2, this.getPosX() + this.getWidth() + this.getSpan(), n + 1);
                gC.setLineWidth(1);
                gC.drawLine(this.getPosX() + this.getWidth() - 3 + this.getSpan(), n2, this.getPosX() + this.getWidth() - 3 + this.getSpan(), n);
            } else {
                gC.drawLine(this.getPosX() + this.getWidth() + this.getSpan(), n2, this.getPosX() + this.getWidth() + this.getSpan(), n);
            }
        }
        if (viewLayout.isTablatureEnabled()) {
            n2 = this.getPosY() + this.ts.getPosition(12);
            n = n2 + (this.trackCoords.getTrack().getStrings().size() - 1) * viewLayout.getStringSpan();
            if (!viewLayout.isScoreEnabled()) {
                String string = Integer.toString(this.measure.getNumber());
                gC.setForeground(this.tablature.getDisplay().getSystemColor(3));
                gC.drawString(string, this.getPosX() + 1, n2 - gC.stringExtent((String)string).y);
                gC.setForeground(this.tablature.getDisplay().getSystemColor(2));
            }
            if (this.measure.isRepeatStart()) {
                gC.setLineWidth(3);
                gC.drawLine(this.getPosX(), n2, this.getPosX(), n + 1);
                gC.drawOval(this.getPosX() + 7, n2 + (n - n2) / 2 - 7, 1, 2);
                gC.drawOval(this.getPosX() + 7, n2 + (n - n2) / 2 + 7, 1, 2);
                gC.setLineWidth(1);
                gC.drawLine(this.getPosX() + 3, n2, this.getPosX() + 3, n);
            } else if (viewLayout.isFirstMeasure(this.getMeasure())) {
                gC.setLineWidth(3);
                gC.drawLine(this.getPosX(), n2, this.getPosX(), n + 1);
                gC.setLineWidth(1);
                gC.drawLine(this.getPosX() + 3, n2, this.getPosX() + 3, n);
            } else {
                gC.drawLine(this.getPosX(), n2, this.getPosX(), n);
            }
            if (this.measure.getNumberOfRepetitions() > 0) {
                gC.setLineWidth(3);
                gC.drawLine(this.getPosX() + this.getWidth() - 1 + this.getSpan(), n2, this.getPosX() + this.getWidth() - 1 + this.getSpan(), n + 1);
                gC.drawOval(this.getPosX() + this.getWidth() - 9 + this.getSpan(), n2 + (n - n2) / 2 - 7, 1, 2);
                gC.drawOval(this.getPosX() + this.getWidth() - 9 + this.getSpan(), n2 + (n - n2) / 2 + 7, 1, 2);
                gC.setLineWidth(1);
                gC.drawLine(this.getPosX() + this.getWidth() - 4 + this.getSpan(), n2, this.getPosX() + this.getWidth() - 4 + this.getSpan(), n);
                if (!viewLayout.isScoreEnabled()) {
                    String string = "x" + Integer.toString(this.measure.getNumberOfRepetitions());
                    gC.drawString(string, this.getPosX() + this.getWidth() - gC.stringExtent((String)string).x + this.getSpan(), n2 - gC.stringExtent((String)string).y);
                }
            } else if (viewLayout.isLastMeasure(this.getMeasure())) {
                gC.setLineWidth(3);
                gC.drawLine(this.getPosX() + this.getWidth() + this.getSpan(), n2, this.getPosX() + this.getWidth() + this.getSpan(), n + 1);
                gC.setLineWidth(1);
                gC.drawLine(this.getPosX() + this.getWidth() - 3 + this.getSpan(), n2, this.getPosX() + this.getWidth() - 3 + this.getSpan(), n);
            } else {
                gC.drawLine(this.getPosX() + this.getWidth() + this.getSpan(), n2, this.getPosX() + this.getWidth() + this.getSpan(), n);
            }
        }
    }

    private void paintClef(ViewLayout viewLayout, GC gC) {
        if (viewLayout.isScoreEnabled() && this.paintClef) {
            int n = 14;
            int n2 = this.getTs().getPosition(2);
            if (this.measure.getClef() == 1) {
                gC.drawImage(SystemImages.CLEF_TREBLE, 0, 0, this.clefSrcBounds.width, this.clefSrcBounds.height, n, n2 - 8, this.clefDstBounds.width, this.clefDstBounds.height);
            } else if (this.measure.getClef() == 2) {
                gC.drawImage(SystemImages.CLEF_BASS, 0, 0, this.clefSrcBounds.width, this.clefSrcBounds.height, n, n2 - 2, this.clefDstBounds.width, this.clefDstBounds.height);
            } else if (this.measure.getClef() == 3) {
                gC.drawImage(SystemImages.CLEF_TENOR, 0, 0, this.clefSrcBounds.width, this.clefSrcBounds.height, n, n2 - 9, this.clefDstBounds.width, this.clefDstBounds.height);
            } else if (this.measure.getClef() == 4) {
                gC.drawImage(SystemImages.CLEF_ALTO, 0, 0, this.clefSrcBounds.width, this.clefSrcBounds.height, n, n2 - 1, this.clefDstBounds.width, this.clefDstBounds.height);
            }
        }
    }

    private void paintKeySignature(ViewLayout viewLayout, GC gC) {
        if (viewLayout.isScoreEnabled() && this.paintKeySignature) {
            int n = this.header.getClefSpan() + 10;
            int n2 = this.getTs().getPosition(2);
            double d = viewLayout.getScoreLineSpan() / 2;
            double d2 = (double)n2 - d;
            double d3 = 0.0;
            switch (this.measure.getClef()) {
                case 1: {
                    d3 = 0.0;
                    break;
                }
                case 2: {
                    d3 = 2.0;
                    break;
                }
                case 3: {
                    d3 = -1.0;
                    break;
                }
                case 4: {
                    d3 = 1.0;
                }
            }
            if (this.measure.getKeySignature() >= 1 && this.measure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_SHARP, n += 6, n2, d, 1 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 1 && this.prevMeasure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n += 6, n2, d, 1 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 2 && this.measure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_SHARP, n += 6, n2, d, 4 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 2 && this.prevMeasure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n += 6, n2, d, 4 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 3 && this.measure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_SHARP, n += 6, n2, d, 0 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 3 && this.prevMeasure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n += 6, n2, d, 0 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 4 && this.measure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_SHARP, n += 6, n2, d, 3 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 4 && this.prevMeasure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n += 6, n2, d, 3 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 5 && this.measure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_SHARP, n += 6, n2, d, 6 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 5 && this.prevMeasure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n += 6, n2, d, 6 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 6 && this.measure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_SHARP, n += 6, n2, d, 2 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 6 && this.prevMeasure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n += 6, n2, d, 2 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 7 && this.measure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_SHARP, n += 6, n2, d, 5 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 7 && this.prevMeasure.getKeySignature() <= 7) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n += 6, n2, d, 5 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 8) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_FLAT, n += 6, n2, d, 5 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 8) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n += 6, n2, d, 5 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 9) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_FLAT, n += 6, n2, d, 2 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 9) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n += 6, n2, d, 2 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 10) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_FLAT, n += 6, n2, d, 6 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 10) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n += 6, n2, d, 6 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 11) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_FLAT, n += 6, n2, d, 3 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 11) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n += 6, n2, d, 3 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 12) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_FLAT, n += 6, n2, d, 0 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 12) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n += 6, n2, d, 0 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 13) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_FLAT, n += 6, n2, d, 4 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 13) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n += 6, n2, d, 4 + (int)d3, d2, 9);
            }
            if (this.measure.getKeySignature() >= 14) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_FLAT, n += 6, n2, d, 1 + (int)d3, d2, 6);
            } else if (this.prevMeasure != null && this.prevMeasure.getKeySignature() >= 14) {
                this.paintKeySignatureImage(gC, SystemImages.KEY_NATURAL, n += 6, n2, d, 1 + (int)d3, d2, 9);
            }
        }
    }

    private void paintKeySignatureImage(GC gC, Image image, int n, int n2, double d, int n3, double d2, int n4) {
        int n5 = (int)((double)n2 + (d * (double)n3 - d) - (double)n4);
        n5 = (int)(n3 < 0 ? (double)n5 + d * 7.0 : (double)n5);
        gC.drawImage(image, n, n5);
    }

    private void paintTimeSignature(ViewLayout viewLayout, GC gC) {
        if (this.header.shouldPaintTimeSignature()) {
            viewLayout.setTimeSignatureStyle(gC);
            gC.setForeground(this.tablature.getDisplay().getSystemColor(2));
            int n = this.header.getClefSpan() + this.header.getKeySignatureSpan() + 15 + 10;
            String string = Integer.toString(this.getMeasure().getTimeSignature().getNumerator());
            String string2 = Integer.toString(this.getMeasure().getTimeSignature().getDenominator().getValue());
            if (viewLayout.isScoreEnabled()) {
                int n2 = this.getTs().getPosition(2);
                int n3 = n2 - 3;
                int n4 = n2 + viewLayout.getScoreLineSpan() * 4 - gC.stringExtent((String)string2).y + 3;
                gC.drawString(string, n, n3, true);
                gC.drawString(string2, n, n4, true);
            } else if (viewLayout.isTablatureEnabled()) {
                int n5 = this.getTs().getPosition(12);
                int n6 = 8 - this.trackCoords.getTrack().stringCount();
                int n7 = n5 - n6;
                int n8 = n5 + this.trackCoords.getTabHeight() - gC.stringExtent((String)string2).y + n6;
                gC.drawString(string, n, n7, true);
                gC.drawString(string2, n, n8, true);
            }
            viewLayout.setDefaultStyle(gC);
        }
    }

    private void paintTempo(ViewLayout viewLayout, GC gC) {
        if (this.header.shouldPaintTempo()) {
            int n = this.getPosX() + 15;
            int n2 = this.getPosY() - SystemImages.TEMPO_IMAGE.getBounds().height;
            if (viewLayout.isScoreEnabled()) {
                n2 += this.getTs().getPosition(2);
            } else if (viewLayout.isTablatureEnabled()) {
                n2 += this.getTs().getPosition(12);
            }
            gC.setForeground(this.tablature.getDisplay().getSystemColor(2));
            gC.drawImage(SystemImages.TEMPO_IMAGE, n - 5, n2 - 10);
            gC.drawString(" = " + this.getMeasure().getTempo().getValue(), n + 10, n2);
        }
    }

    private void paintTripletFeel(ViewLayout viewLayout, GC gC) {
        if (this.header.shouldPaintTripletFeel()) {
            int n = this.getPosX() + this.header.getTempoSpan();
            int n2 = this.getPosY() - SystemImages.TEMPO_IMAGE.getBounds().height;
            if (viewLayout.isScoreEnabled()) {
                n2 += this.getTs().getPosition(2);
            } else if (viewLayout.isTablatureEnabled()) {
                n2 += this.getTs().getPosition(12);
            }
            gC.drawImage(SystemImages.getTripletFeel(this.getMeasure().getTripletFeel()), n + 10, n2 - 13);
        }
    }

    private void paintPlayMode(ViewLayout viewLayout, GC gC) {
        if (viewLayout.isPlayModeEnabled() && this.isPlaying()) {
            int n = this.getWidth() + this.getSpan();
            int n2 = 100;
            int n3 = this.getPosY();
            int n4 = this.getPosY();
            if (viewLayout.isScoreEnabled() && viewLayout.isTablatureEnabled()) {
                n3 += this.getTs().getPosition(2) - viewLayout.getScoreLineSpan();
                n4 += this.getTs().getPosition(12) + this.trackCoords.getTabHeight() + viewLayout.getStringSpan();
            } else if (viewLayout.isScoreEnabled() && !viewLayout.isTablatureEnabled()) {
                n3 += this.getTs().getPosition(2) - viewLayout.getScoreLineSpan();
                n4 += this.getTs().getPosition(2) + viewLayout.getStringSpan() * 5;
            } else if (!viewLayout.isScoreEnabled() && viewLayout.isTablatureEnabled()) {
                n3 += this.getTs().getPosition(12) - viewLayout.getStringSpan();
                n4 += this.getTs().getPosition(12) + this.trackCoords.getTabHeight() + viewLayout.getStringSpan();
            }
            gC.setLineWidth(1);
            gC.setLineStyle(2);
            gC.drawRectangle(this.getPosX() + 5, n3, n - 10, n4 - n3);
            gC.setLineStyle(1);
        }
    }

    public boolean isPlaying() {
        long l;
        return TuxGuitar.instance().getPlayer().isRunning() && this.getTrackCoords().hasCaret() && (l = TuxGuitar.instance().getPlayer().getTickPosition()) >= this.getMeasure().getStart() && l < this.getMeasure().getStart() + this.getMeasure().getLength();
    }

    public int getSpanForComponent(Component component) {
        return (int)((component.getStart() - this.getMeasure().getStart()) * (long)this.getSpan() / this.getMeasure().getLength());
    }

    public boolean hasTrack(int n) {
        return this.trackCoords.getTrack().getNumber() == n;
    }

    public int getWidth() {
        return this.header.getWidth();
    }

    private int calculateKeySignatureSpan() {
        int n = 0;
        if (this.paintKeySignature) {
            n = this.measure.getKeySignature() <= 7 ? (n += 6 * this.measure.getKeySignature()) : (n += 6 * (this.measure.getKeySignature() - 7));
            if (this.prevMeasure != null) {
                n = this.prevMeasure.getKeySignature() <= 7 ? (n += 6 * this.prevMeasure.getKeySignature()) : (n += 6 * (this.prevMeasure.getKeySignature() - 7));
            }
        }
        return n;
    }

    public int getFirstNoteSpan() {
        return this.header.getFirstNoteSpan();
    }

    public MeasureComponent getPreviousComponent(MeasureComponent measureComponent) {
        MeasureComponent measureComponent2 = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent3 = (MeasureComponent)this.measureComponents.get(i);
            if (measureComponent3.getStart() >= measureComponent.getStart()) continue;
            if (measureComponent2 == null) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() > measureComponent2.getStart()) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() != measureComponent2.getStart() || measureComponent3.getDuration().getTime() > measureComponent2.getDuration().getTime()) continue;
            measureComponent2 = measureComponent3;
        }
        return measureComponent2;
    }

    public MeasureComponent getNextComponent(MeasureComponent measureComponent) {
        MeasureComponent measureComponent2 = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent3 = (MeasureComponent)this.measureComponents.get(i);
            if (measureComponent3.getStart() <= measureComponent.getStart()) continue;
            if (measureComponent2 == null) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() < measureComponent2.getStart()) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() != measureComponent2.getStart() || measureComponent3.getDuration().getTime() > measureComponent2.getDuration().getTime()) continue;
            measureComponent2 = measureComponent3;
        }
        return measureComponent2;
    }

    public MeasureComponent getFirstComponent() {
        MeasureComponent measureComponent = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent2 = (MeasureComponent)this.measureComponents.get(i);
            if (measureComponent != null && measureComponent2.getStart() >= measureComponent.getStart()) continue;
            measureComponent = measureComponent2;
        }
        return measureComponent;
    }

    public MeasureComponent getLastComponent() {
        MeasureComponent measureComponent = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent2 = (MeasureComponent)this.measureComponents.get(i);
            if (measureComponent != null && measureComponent.getStart() >= measureComponent2.getStart()) continue;
            measureComponent = measureComponent2;
        }
        return measureComponent;
    }

    public MeasureComponent getComponent(long l) {
        MeasureComponent measureComponent = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent2 = (MeasureComponent)this.measureComponents.get(i);
            if (measureComponent2.getStart() > l || measureComponent2.getStart() + measureComponent2.getDuration().getTime() <= l) continue;
            measureComponent = measureComponent2;
            break;
        }
        return measureComponent;
    }

    public List getComponents(long l) {
        ArrayList<MeasureComponent> arrayList = new ArrayList<MeasureComponent>();
        for (MeasureComponent measureComponent : this.measureComponents) {
            if (measureComponent.getStart() != l) continue;
            arrayList.add(measureComponent);
        }
        return arrayList;
    }

    public List getComponentsBetween(long l) {
        ArrayList<MeasureComponent> arrayList = new ArrayList<MeasureComponent>();
        for (MeasureComponent measureComponent : this.measureComponents) {
            if (measureComponent.getStart() > l || measureComponent.getStart() + measureComponent.getDuration().getTime() <= l) continue;
            arrayList.add(measureComponent);
        }
        return arrayList;
    }

    public MeasureComponent getComponent(long l, int n) {
        MeasureComponent measureComponent = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            NoteCoords noteCoords;
            MeasureComponent measureComponent2 = (MeasureComponent)this.measureComponents.get(i);
            if (!(measureComponent2 instanceof NoteCoords) || (noteCoords = (NoteCoords)measureComponent2).getStart() > l || noteCoords.getStart() + noteCoords.getDuration().getTime() <= l || noteCoords.getNote().getString() != n) continue;
            measureComponent = measureComponent2;
            break;
        }
        return measureComponent;
    }

    public MeasureComponent getComponentOrSilence(long l, int n) {
        MeasureComponent measureComponent = this.getComponent(l, n);
        if (measureComponent == null) {
            measureComponent = this.getComponent(l);
        }
        return measureComponent;
    }

    public List getComponentsBeforeEnd(long l) {
        ArrayList<MeasureComponent> arrayList = new ArrayList<MeasureComponent>();
        for (MeasureComponent measureComponent : this.measureComponents) {
            if (measureComponent.getStart() < l) continue;
            arrayList.add(measureComponent);
        }
        return arrayList;
    }

    public List getComponents() {
        return this.measureComponents;
    }

    public MeasureComponent getNextNoteComponent(MeasureComponent measureComponent, int n) {
        MeasureComponent measureComponent2 = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            Note note;
            MeasureComponent measureComponent3 = (MeasureComponent)this.measureComponents.get(i);
            if (!(measureComponent3 instanceof NoteCoords) || (note = ((NoteCoords)measureComponent3).getNote()).getString() != n || note.getStart() <= measureComponent.getStart() || measureComponent2 != null && note.getStart() >= measureComponent2.getStart()) continue;
            measureComponent2 = measureComponent3;
        }
        return measureComponent2;
    }

    public MeasureComponent getNextNoteComponent(MeasureComponent measureComponent) {
        MeasureComponent measureComponent2 = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent3 = (MeasureComponent)this.measureComponents.get(i);
            if (!(measureComponent3 instanceof NoteCoords) || measureComponent3.getStart() <= measureComponent.getStart()) continue;
            if (measureComponent2 == null) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() < measureComponent2.getStart()) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() != measureComponent2.getStart() || measureComponent3.getDuration().getTime() > measureComponent2.getDuration().getTime()) continue;
            measureComponent2 = measureComponent3;
        }
        return measureComponent2;
    }

    public MeasureComponent getNextSilenceComponent(MeasureComponent measureComponent) {
        MeasureComponent measureComponent2 = null;
        for (int i = 0; i < this.measureComponents.size(); ++i) {
            MeasureComponent measureComponent3 = (MeasureComponent)this.measureComponents.get(i);
            if (!(measureComponent3 instanceof SilenceCoords) || measureComponent3.getStart() <= measureComponent.getStart()) continue;
            if (measureComponent2 == null) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() < measureComponent2.getStart()) {
                measureComponent2 = measureComponent3;
                continue;
            }
            if (measureComponent3.getStart() != measureComponent2.getStart() || measureComponent3.getDuration().getTime() > measureComponent2.getDuration().getTime()) continue;
            measureComponent2 = measureComponent3;
        }
        return measureComponent2;
    }

    public MeasureComponent getComponentAt(int n) {
        MeasureComponent measureComponent = null;
        for (MeasureComponent measureComponent2 : this.measureComponents) {
            if (measureComponent == null) {
                measureComponent = measureComponent2;
                continue;
            }
            int n2 = Math.abs(n - (15 + this.getPosX() + measureComponent.getPosX() + measureComponent.getSpan()));
            int n3 = Math.abs(n - (15 + this.getPosX() + measureComponent2.getPosX() + measureComponent2.getSpan()));
            if (n3 >= n2) continue;
            measureComponent = measureComponent2;
        }
        return measureComponent;
    }

    public InstrumentString getStringAt(int n) {
        InstrumentString instrumentString = null;
        int n2 = this.tablature.getViewLayout().getStringSpan();
        int n3 = 0;
        int n4 = this.getPosY() + this.ts.getPosition(12);
        for (InstrumentString instrumentString2 : this.trackCoords.getTrack().getStrings()) {
            int n5 = Math.abs(n - (n4 + (instrumentString2.getNumber() * n2 - n2)));
            if (instrumentString != null && n5 >= n3) continue;
            instrumentString = instrumentString2;
            n3 = n5;
        }
        return instrumentString;
    }

    public long getBeatLength() {
        return this.beatLength;
    }

    public boolean areInSameBeat(MeasureComponent measureComponent, MeasureComponent measureComponent2) {
        return this.songManager.getMeasureManager().areInSameBeat(this.measure, measureComponent.getComponent(), measureComponent2.getComponent());
    }

    public void playBeat(long l) {
        if (!TuxGuitar.instance().getPlayer().isRunning()) {
            List list = this.songManager.getMeasureManager().getNotes(this.measure, l);
            TuxGuitar.instance().getPlayer().playBeat(this.getTrackCoords().getTrack(), list);
        }
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean bl) {
        this.cacheEnabled = bl;
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int n) {
        this.posX = n;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosY(int n) {
        this.posY = n;
    }

    public void setQuarterSpan(int n) {
        this.quarterSpan = n;
    }

    public int getQuarterSpan() {
        return this.quarterSpan;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public int getSpan() {
        return this.span;
    }

    public void setSpan(int n) {
        if (n != this.span) {
            this.setCacheEnabled(false);
        }
        this.span = n;
    }

    public boolean isOutOfBounds() {
        return this.outOfBounds;
    }

    public void setOutOfBounds(boolean bl) {
        this.outOfBounds = bl;
    }

    public boolean isFirstOfLine() {
        return this.firstOfLine;
    }

    public void setFirstOfLine(boolean bl) {
        this.firstOfLine = bl;
    }

    public SongTrackCoords getTrackCoords() {
        return this.trackCoords;
    }

    public TrackSpacing getTs() {
        return this.ts;
    }

    public void setTs(TrackSpacing trackSpacing) {
        if (this.getTs() == null) {
            this.setCacheEnabled(false);
        } else if (this.getTs().getPosition(2) != trackSpacing.getPosition(2)) {
            this.setCacheEnabled(false);
        } else if (this.getTs().getPosition(12) != trackSpacing.getPosition(12)) {
            this.setCacheEnabled(false);
        }
        this.ts = trackSpacing;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMinY() {
        return this.minY;
    }

    public List getBeatPositions() {
        return this.beatPositions;
    }

    public int getLyricBeatIndex() {
        return this.lyricBeatIndex;
    }

    public void setLyricBeatIndex(int n) {
        this.lyricBeatIndex = n;
    }

    public void dispose() {
        this.cache.dispose();
    }

    public boolean isDisposed() {
        return this.cache.isDisposed();
    }

    public class BeatPosition
    implements Component {
        private long start;
        private int posX;
        private Duration duration;
        private NoteCoords maxNote;
        private NoteCoords minNote;

        public BeatPosition(long l, Duration duration, int n) {
            this.start = l;
            this.duration = duration;
            this.posX = n;
        }

        public void checkValues(NoteCoords noteCoords) {
            int n = noteCoords.getRealValue();
            if (this.maxNote == null || n > this.maxNote.getRealValue()) {
                this.maxNote = noteCoords;
            }
            if (this.minNote == null || n < this.minNote.getRealValue()) {
                this.minNote = noteCoords;
            }
        }

        public int getPosX() {
            return this.posX + MeasureCoords.this.getSpanForComponent(this);
        }

        public void setDuration(Duration duration) {
            this.duration = duration;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public long getStart() {
            return this.start;
        }

        public void setStart(long l) {
            this.start = l;
        }

        public boolean isPlayingBeat() {
            long l;
            return MeasureCoords.this.isPlaying() && (l = TuxGuitar.instance().getPlayer().getTickPosition()) >= this.getStart() && l < this.getStart() + this.getDuration().getTime();
        }

        public NoteCoords getMinNote() {
            return this.minNote;
        }

        public NoteCoords getMaxNote() {
            return this.maxNote;
        }

        public void paintExtraLines(GC gC, ViewLayout viewLayout) {
            int n = MeasureCoords.this.getTs().getPosition(2);
            this.paintExtraLines(gC, viewLayout, this.getMinNote(), n);
            this.paintExtraLines(gC, viewLayout, this.getMaxNote(), n);
        }

        private void paintExtraLines(GC gC, ViewLayout viewLayout, NoteCoords noteCoords, int n) {
            block3: {
                int n2;
                int n3;
                int n4;
                block2: {
                    n4 = n + noteCoords.getScorePosY();
                    n3 = 15 + noteCoords.getPosX() + noteCoords.getSpan();
                    n2 = viewLayout.getScoreLineSpan();
                    if (n4 >= n) break block2;
                    viewLayout.setLineColor(gC);
                    for (int i = n; i > n4; i -= n2) {
                        gC.drawLine(n3 - 4, i, n3 + 12, i);
                    }
                    break block3;
                }
                if (n4 <= n + n2 * 4) break block3;
                viewLayout.setLineColor(gC);
                for (int i = n + n2 * 5; i < n4 + n2; i += n2) {
                    gC.drawLine(n3 - 4, i, n3 + 12, i);
                }
            }
        }

        public Object clone() {
            return new BeatPosition(this.start, (Duration)this.duration.clone(), this.posX);
        }
    }
}

