/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.lyric;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.lyric.LyricModifyListener;
import org.herac.tuxguitar.song.models.SongTrack;

public class LyricEditor {
    private static int EDITOR_WIDTH = 400;
    private static int EDITOR_HEIGHT = 200;
    private SongTrack track;
    private Shell dialog;
    private LyricModifyListener listener = new LyricModifyListener(this);
    private Label label;
    private Spinner from;
    private Text text;

    public void show() {
        Shell shell = TuxGuitar.instance().getShell();
        Rectangle rectangle = shell.getBounds();
        Rectangle rectangle2 = shell.getDisplay().getBounds();
        this.dialog = new Shell(shell, 2160);
        this.dialog.setLayout(new GridLayout());
        this.dialog.setText(TuxGuitar.getProperty("lyric.editor"));
        this.updateSongTrack();
        this.loadComposites();
        int n = shell.getBounds().x + (shell.getBounds().width - EDITOR_WIDTH) / 2;
        int n2 = shell.getBounds().y + (shell.getBounds().height - EDITOR_HEIGHT) / 2;
        this.dialog.setSize(EDITOR_WIDTH, EDITOR_HEIGHT);
        this.dialog.setLocation(n, n2);
        this.dialog.open();
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
        this.track = null;
        this.label = null;
        this.text = null;
        this.dialog = null;
    }

    private void loadComposites() {
        Composite composite = new Composite(this.dialog, 0);
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(4, 4, true, true));
        this.loadToolBar(composite);
        this.loadLyricText(composite);
    }

    private void loadToolBar(Composite composite) {
        final Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout(5, false));
        composite2.setLayoutData(new GridData(4, 0, true, false));
        Button button = new Button(composite2, 16388);
        Button button2 = new Button(composite2, 131076);
        this.label = new Label(composite2, 0);
        this.label.setText(this.track.getName());
        this.label.setLayoutData(new GridData(4, 0x1000000, true, true));
        Label label = new Label(composite2, 0);
        label.setText(TuxGuitar.getProperty("edit.from"));
        label.setLayoutData(new GridData(131072, 0x1000000, false, true));
        this.from = new Spinner(composite2, 2048);
        this.from.setLayoutData(this.getSpinnerData());
        this.from.setMinimum(1);
        this.from.setMaximum(this.track.getMeasures().size());
        this.from.setSelection(this.track.getLyrics().getFrom());
        this.from.setEnabled(this.track.getMeasures().size() > 1);
        this.from.addModifyListener(this.listener);
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getAction("action.track.go-previous").process(selectionEvent);
                composite2.layout();
            }
        });
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getAction("action.track.go-next").process(selectionEvent);
            }
        });
    }

    private GridData getSpinnerData() {
        GridData gridData = new GridData();
        return gridData;
    }

    private void loadLyricText(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout());
        composite2.setLayoutData(new GridData(4, 4, true, true));
        this.text = new Text(composite2, 2626);
        this.text.setLayoutData(new GridData(4, 4, true, true));
        this.text.setFocus();
        this.text.setText(this.track.getLyrics().getLyrics());
        this.text.addModifyListener(this.listener);
    }

    public void updateSongTrack() {
        if (this.dialog != null && !this.dialog.isDisposed()) {
            this.track = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getSongTrackCoords().getTrack();
            if (this.label != null && !this.label.isDisposed()) {
                this.label.setText(this.track.getName());
            }
            if (this.from != null && !this.from.isDisposed()) {
                this.from.setMaximum(this.track.getMeasures().size());
                this.from.setSelection(this.track.getLyrics().getFrom());
                this.from.setEnabled(this.track.getMeasures().size() > 1);
            }
            if (this.text != null && !this.text.isDisposed()) {
                this.text.setText(this.track.getLyrics().getLyrics());
            }
        }
    }

    public SongTrack getTrack() {
        return this.track;
    }
}

