/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.chord.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.herac.tuxguitar.song.models.Chord;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ChordWriter {
    private static final String CHORD_LIST_TAG = "chords";
    private static final String CHORD_TAG = "chord";
    private static final String CHORD_NAME_ATTRIBUTE = "name";
    private static final String CHORD_STRINGS_ATTRIBUTE = "strings";
    private static final String STRING_TAG = "string";
    private static final String STRING_NUMBER_ATTRIBUTE = "number";
    private static final String STRING_FRET_ATTRIBUTE = "fret";

    public static void setChords(List list, String string) {
        File file = new File(string);
        Document document = ChordWriter.createDocument();
        ChordWriter.setChords(list, document);
        ChordWriter.saveDocument(document, file);
    }

    public static Document createDocument() {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return document;
    }

    public static void saveDocument(Document document, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(fileOutputStream);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    private static void setChords(List list, Document document) {
        Element element = document.createElement(CHORD_LIST_TAG);
        for (Chord chord : list) {
            Element element2 = document.createElement(CHORD_TAG);
            element.appendChild(element2);
            Attr attr = document.createAttribute(CHORD_NAME_ATTRIBUTE);
            attr.setNodeValue(chord.getName());
            element2.getAttributes().setNamedItem(attr);
            Attr attr2 = document.createAttribute(CHORD_STRINGS_ATTRIBUTE);
            attr2.setNodeValue(Integer.toString(chord.getStrings().length));
            element2.getAttributes().setNamedItem(attr2);
            for (int i = 0; i < chord.getStrings().length; ++i) {
                Element element3 = document.createElement(STRING_TAG);
                element2.appendChild(element3);
                Attr attr3 = document.createAttribute(STRING_NUMBER_ATTRIBUTE);
                attr3.setNodeValue(Integer.toString(i));
                element3.getAttributes().setNamedItem(attr3);
                Attr attr4 = document.createAttribute(STRING_FRET_ATTRIBUTE);
                attr4.setNodeValue(Integer.toString(chord.getFretValue(i)));
                element3.getAttributes().setNamedItem(attr4);
            }
        }
        document.appendChild(element);
    }
}

