/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.chord.xml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.herac.tuxguitar.song.models.Chord;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ChordReader {
    private static final String ACTION_ATTRIBUTE = "action";
    private static final String KEYS_ATTRIBUTE = "keys";
    private static final String CHORD_LIST_TAG = "chords";
    private static final String CHORD_TAG = "chord";
    private static final String CHORD_NAME_ATTRIBUTE = "name";
    private static final String CHORD_STRINGS_ATTRIBUTE = "strings";
    private static final String STRING_TAG = "string";
    private static final String STRING_NUMBER_ATTRIBUTE = "number";
    private static final String STRING_FRET_ATTRIBUTE = "fret";

    public static List getChords(String string) {
        ArrayList arrayList = new ArrayList();
        try {
            File file = new File(string);
            if (file.exists()) {
                Document document = ChordReader.getDocument(file);
                ChordReader.loadChords(document.getFirstChild(), arrayList);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private static Document getDocument(File file) {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(file);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return document;
    }

    private static void loadChords(Node node, List list) {
        try {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!node2.getNodeName().equals(CHORD_TAG)) continue;
                NamedNodeMap namedNodeMap = node2.getAttributes();
                String string = namedNodeMap.getNamedItem(CHORD_NAME_ATTRIBUTE).getNodeValue();
                String string2 = namedNodeMap.getNamedItem(CHORD_STRINGS_ATTRIBUTE).getNodeValue();
                Chord chord = new Chord(Integer.parseInt(string2));
                chord.setName(string);
                NodeList nodeList2 = node2.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node3 = nodeList2.item(j);
                    if (!node3.getNodeName().equals(STRING_TAG)) continue;
                    NamedNodeMap namedNodeMap2 = node3.getAttributes();
                    String string3 = namedNodeMap2.getNamedItem(STRING_NUMBER_ATTRIBUTE).getNodeValue();
                    String string4 = namedNodeMap2.getNamedItem(STRING_FRET_ATTRIBUTE).getNodeValue();
                    chord.addFretValue(Integer.parseInt(string3), Integer.parseInt(string4));
                }
                list.add(chord);
            }
        }
        catch (Exception exception) {
            list.clear();
            exception.printStackTrace();
        }
    }
}

