/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.chord;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.chord.ChordEditor;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.song.models.Chord;

public class ChordCustomList
extends Composite {
    private ChordEditor editor;
    private List chords;

    public ChordCustomList(Composite composite, int n, int n2, ChordEditor chordEditor) {
        super(composite, n);
        this.setLayout(new GridLayout());
        this.setLayoutData(this.makeGridData(n2));
        this.editor = chordEditor;
        this.init();
    }

    public GridData makeGridData(int n) {
        GridData gridData = new GridData(4, 128, true, true);
        gridData.heightHint = n;
        return gridData;
    }

    public void init() {
        Composite composite = new Composite(this, 0);
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(4, 4, true, true));
        this.chords = new List(composite, 2816);
        this.chords.setLayoutData(new GridData(4, 4, true, true));
        this.chords.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ChordCustomList.this.editor != null) {
                    ChordCustomList.this.showChord(ChordCustomList.this.chords.getSelectionIndex());
                }
            }
        });
        Composite composite2 = new Composite(this, 0);
        composite2.setLayout(new GridLayout(3, false));
        Button button = new Button(composite2, 8);
        button.setText(TuxGuitar.getProperty("add"));
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChordCustomList.this.addCustomChord();
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setText(TuxGuitar.getProperty("rename"));
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChordCustomList.this.renameCustomChord(ChordCustomList.this.chords.getSelectionIndex());
            }
        });
        Button button3 = new Button(composite2, 8);
        button3.setText(TuxGuitar.getProperty("remove"));
        button3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChordCustomList.this.removeCustomChord(ChordCustomList.this.chords.getSelectionIndex());
            }
        });
        this.loadChords();
    }

    private void loadChords() {
        int n = this.chords.getSelectionIndex();
        this.chords.removeAll();
        for (int i = 0; i < TuxGuitar.instance().getCustomChordManager().countChords(); ++i) {
            Chord chord = TuxGuitar.instance().getCustomChordManager().getChord(i);
            if (chord == null) continue;
            this.chords.add(chord.getName());
        }
        if (n >= 0 && n < this.chords.getItemCount()) {
            this.chords.select(n);
        } else if (n > 0 && n - 1 < this.chords.getItemCount()) {
            this.chords.select(n - 1);
        }
    }

    private void showChord(int n) {
        Chord chord = TuxGuitar.instance().getCustomChordManager().getChord(n);
        if (chord != null) {
            int n2;
            int n3;
            int n4 = -1;
            for (n3 = 0; n3 < chord.getStrings().length; ++n3) {
                n2 = chord.getFretValue(n3);
                if (n4 >= 0 && (n2 >= n4 || n2 < 0)) continue;
                n4 = n2;
            }
            this.editor.setFret((short)(n4 <= 0 ? 1 : n4));
            for (n3 = 0; n3 < chord.getStrings().length; ++n3) {
                n2 = chord.getFretValue(n3);
                this.editor.addValue(n2, n3 + 1);
            }
            this.editor.redraw();
        }
    }

    private void addCustomChord() {
        String string;
        Chord chord = this.editor.getCurrentChord();
        if (chord != null && (string = new NameDialog().open()) != null) {
            if (string.length() == 0) {
                String string2 = TuxGuitar.getProperty("error");
                String string3 = TuxGuitar.getProperty("chord.custom.name-empty-error");
                new MessageDialog(string2, string3, 1).show(this.getShell());
                return;
            }
            if (TuxGuitar.instance().getCustomChordManager().existOtherEqualCustomChord(string, -1)) {
                String string4 = TuxGuitar.getProperty("error");
                String string5 = TuxGuitar.getProperty("chord.custom.name-exist-error");
                new MessageDialog(string4, string5, 1).show(this.getShell());
                return;
            }
            chord.setName(string);
            TuxGuitar.instance().getCustomChordManager().addChord(chord);
            this.loadChords();
        }
    }

    private void renameCustomChord(int n) {
        String string;
        Chord chord = TuxGuitar.instance().getCustomChordManager().getChord(n);
        if (chord != null && (string = new NameDialog(chord.getName()).open()) != null) {
            if (string.length() == 0) {
                String string2 = TuxGuitar.getProperty("error");
                String string3 = TuxGuitar.getProperty("chord.custom.name-empty-error");
                new MessageDialog(string2, string3, 1).show(this.getShell());
                return;
            }
            if (TuxGuitar.instance().getCustomChordManager().existOtherEqualCustomChord(string, n)) {
                String string4 = TuxGuitar.getProperty("error");
                String string5 = TuxGuitar.getProperty("chord.custom.name-exist-error");
                new MessageDialog(string4, string5, 1).show(this.getShell());
                return;
            }
            TuxGuitar.instance().getCustomChordManager().renameChord(n, string);
            this.loadChords();
        }
    }

    private void removeCustomChord(int n) {
        if (n >= 0 && n < TuxGuitar.instance().getCustomChordManager().countChords()) {
            TuxGuitar.instance().getCustomChordManager().removeChord(n);
            this.loadChords();
        }
    }

    private class NameDialog {
        private String name;

        public NameDialog(String string) {
            this.name = string;
        }

        public NameDialog() {
            this(new String());
        }

        public String open() {
            final Shell shell = new Shell(ChordCustomList.this.getShell(), 67680);
            shell.setLayout(new GridLayout());
            shell.setText(TuxGuitar.getProperty("chord.name"));
            Composite composite = new Composite(shell, 0);
            composite.setLayout(new GridLayout(2, false));
            composite.setLayoutData(new GridData(4, 4, true, true));
            Label label = new Label(composite, 0);
            label.setText(TuxGuitar.getProperty("chord.name"));
            final Text text = new Text(composite, 2048);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.minimumWidth = 150;
            text.setLayoutData(gridData);
            text.setText(this.name);
            Composite composite2 = new Composite(shell, 0);
            composite2.setLayout(new GridLayout(2, false));
            composite2.setLayoutData(new GridData(0x1000008, 4, true, true));
            GridData gridData2 = new GridData(4, 4, true, true);
            gridData2.minimumWidth = 80;
            gridData2.minimumHeight = 25;
            Button button = new Button(composite2, 8);
            button.setText(TuxGuitar.getProperty("ok"));
            button.setLayoutData(gridData2);
            button.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    NameDialog.this.name = text.getText();
                    shell.dispose();
                }
            });
            Button button2 = new Button(composite2, 8);
            button2.setText(TuxGuitar.getProperty("cancel"));
            button2.setLayoutData(gridData2);
            button2.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    NameDialog.this.name = null;
                    shell.dispose();
                }
            });
            shell.pack();
            shell.open();
            int n = ChordCustomList.this.getShell().getBounds().x + (ChordCustomList.this.getShell().getBounds().width - shell.getSize().x) / 2;
            int n2 = ChordCustomList.this.getShell().getBounds().y + (ChordCustomList.this.getShell().getBounds().height - shell.getSize().y) / 2;
            shell.setLocation(n, n2);
            while (!shell.isDisposed()) {
                if (shell.getDisplay().readAndDispatch()) continue;
                shell.getDisplay().sleep();
            }
            return this.name;
        }
    }
}

