/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.track;

import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.Instrument;
import javax.sound.midi.Soundbank;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.JoinedUndoable;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableInfoTrack;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableInstrumentTrack;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableTrackGeneric;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.RGBColor;
import org.herac.tuxguitar.song.models.SongTrack;

public class ChangeTrackPropertiesAction
extends Action {
    public static final String NAME = "action.track.properties";
    private static final String[] NOTE_NAMES = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "Bb", "B"};
    private static final int MINIMUN_LEFT_CONTROLS_WIDTH = 180;
    private static final int MINIMUN_BUTTON_WIDTH = 80;
    private static final int MINIMUN_BUTTON_HEIGHT = 25;
    private static final int MAX_STRINGS = 7;
    private static final int MIN_STRINGS = 4;
    private static final int MAX_OCTAVES = 10;
    private static final int MAX_NOTES = 12;
    private Shell dialog;
    private Text nameText;
    private RGBColor trackColor;
    private List tempStrings;
    private Spinner stringCountSpinner;
    private Combo[] stringCombos = new Combo[7];
    private Combo offsetCombo;
    private int stringCount;
    private Combo instrumentCombo;
    private Button percussionCheckBox;

    public ChangeTrackPropertiesAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        SongTrackCoords songTrackCoords = this.getEditor().getTablature().getCaret().getSongTrackCoords();
        if (songTrackCoords != null) {
            this.stringCount = songTrackCoords.getTrack().getStrings().size();
            this.trackColor = (RGBColor)songTrackCoords.getTrack().getColor().clone();
            this.initTempStrings(songTrackCoords.getTrack().getStrings());
            this.dialog = new Shell(shell, 67680);
            this.dialog.setLayout(new GridLayout());
            this.dialog.setText(TuxGuitar.getProperty("track.properties"));
            Composite composite = new Composite(this.dialog, 0);
            composite.setLayout(new GridLayout(2, false));
            composite.setLayoutData(new GridData(4, 4, true, true));
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout(new GridLayout());
            composite2.setLayoutData(new GridData(4, 4, true, true));
            Composite composite3 = new Composite(composite, 0);
            composite3.setLayout(new GridLayout());
            composite3.setLayoutData(new GridData(4, 4, true, true));
            Composite composite4 = new Composite(this.dialog, 0);
            composite4.setLayout(new GridLayout());
            composite4.setLayoutData(new GridData(4, 4, true, true));
            this.initTrackInfo(this.makeGroup(composite2, 1, TuxGuitar.getProperty("track.properties.general")), songTrackCoords);
            this.initInstrumentFields(this.makeGroup(composite2, 1, TuxGuitar.getProperty("instrument.instrument")), songTrackCoords);
            this.initTunningInfo(this.makeGroup(composite3, 2, TuxGuitar.getProperty("tunning")), songTrackCoords);
            this.initButtons(composite4);
            this.updateTunningGroup(!songTrackCoords.getTrack().isPercussionTrack());
            this.dialog.pack();
            this.dialog.open();
            int n = shell.getBounds().x + (shell.getBounds().width - this.dialog.getSize().x) / 2;
            int n2 = shell.getBounds().y + (shell.getBounds().height - this.dialog.getSize().y) / 2;
            this.dialog.setLocation(n, n2);
            while (!this.dialog.isDisposed()) {
                if (this.dialog.getDisplay().readAndDispatch()) continue;
                this.dialog.getDisplay().sleep();
            }
        }
    }

    private Group makeGroup(Composite composite, int n, String string) {
        Group group = new Group(composite, 16);
        group.setLayoutData(this.makeGridData(n));
        group.setText(string);
        return group;
    }

    private GridData makeGridData(int n) {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = n;
        return gridData;
    }

    private void initTrackInfo(Composite composite, SongTrackCoords songTrackCoords) {
        composite.setLayout(new GridLayout());
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout());
        composite2.setLayoutData(new GridData(4, 128, true, true));
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout(new GridLayout());
        composite3.setLayoutData(new GridData(4, 1024, true, true));
        Label label = new Label(composite2, 0);
        label.setLayoutData(new GridData(4, 0x1000000, true, true));
        label.setText(TuxGuitar.getProperty("track.name") + ":");
        this.nameText = new Text(composite2, 2048);
        this.nameText.setLayoutData(this.getAlignmentData(180, 4));
        this.nameText.setText(songTrackCoords.getTrack().getName());
        Label label2 = new Label(composite3, 0);
        label2.setText(TuxGuitar.getProperty("track.color") + ":");
        label2.setLayoutData(new GridData(4, 0x1000000, true, true));
        final Button button = new Button(composite3, 8);
        button.setLayoutData(this.getAlignmentData(180, 4));
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorDialog colorDialog = new ColorDialog(ChangeTrackPropertiesAction.this.dialog);
                colorDialog.setRGB(ChangeTrackPropertiesAction.this.dialog.getDisplay().getSystemColor(2).getRGB());
                colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    ChangeTrackPropertiesAction.this.trackColor.setR(rGB.red);
                    ChangeTrackPropertiesAction.this.trackColor.setG(rGB.green);
                    ChangeTrackPropertiesAction.this.trackColor.setB(rGB.blue);
                    button.redraw();
                }
            }
        });
        button.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Color color = new Color(ChangeTrackPropertiesAction.this.dialog.getDisplay(), ChangeTrackPropertiesAction.this.trackColor.getR(), ChangeTrackPropertiesAction.this.trackColor.getG(), ChangeTrackPropertiesAction.this.trackColor.getB());
                paintEvent.gc.setBackground(color);
                paintEvent.gc.fillRectangle(5, 5, button.getSize().x - 10, button.getSize().y - 10);
                color.dispose();
            }
        });
    }

    private void initTunningInfo(Composite composite, SongTrackCoords songTrackCoords) {
        composite.setLayout(new GridLayout(2, true));
        this.initTunningData(composite, songTrackCoords);
        this.initTunningCombos(composite);
    }

    private void initTunningCombos(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout());
        composite2.setLayoutData(new GridData(131072, 4, true, true));
        String[] stringArray = this.getAllValueNames();
        for (int i = 0; i < 7; ++i) {
            this.stringCombos[i] = new Combo(composite2, 12);
            this.stringCombos[i].setItems(stringArray);
        }
    }

    private void initTunningData(Composite composite, SongTrackCoords songTrackCoords) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout());
        composite2.setLayoutData(new GridData(4, 128, true, true));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout(new GridLayout());
        composite3.setLayoutData(new GridData(4, 128, true, true));
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayout(new GridLayout());
        composite4.setLayoutData(new GridData(4, 1024, true, true));
        Label label = new Label(composite3, 0);
        label.setText(TuxGuitar.getProperty("tunning.strings") + ":");
        label.setLayoutData(new GridData(16384, 0x1000000, true, true));
        this.stringCountSpinner = new Spinner(composite3, 2048);
        this.stringCountSpinner.setLayoutData(this.getAlignmentData(80, 4));
        this.stringCountSpinner.setMinimum(4);
        this.stringCountSpinner.setMaximum(7);
        this.stringCountSpinner.setSelection(this.stringCount);
        this.stringCountSpinner.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChangeTrackPropertiesAction.this.stringCount = ChangeTrackPropertiesAction.this.stringCountSpinner.getSelection();
                ChangeTrackPropertiesAction.this.setDefaultTunning();
                ChangeTrackPropertiesAction.this.updateTunningGroup(!ChangeTrackPropertiesAction.this.percussionCheckBox.getSelection());
            }
        });
        Label label2 = new Label(composite4, 0);
        label2.setText(TuxGuitar.getProperty("tunning.offset") + ":");
        label2.setLayoutData(new GridData(16384, 0x1000000, true, true));
        this.offsetCombo = new Combo(composite4, 12);
        this.offsetCombo.setLayoutData(this.getAlignmentData(80, 16384));
        for (int i = -24; i <= 24; ++i) {
            this.offsetCombo.add(Integer.toString(i));
            if (i != songTrackCoords.getTrack().getOffset()) continue;
            this.offsetCombo.select(i - -24);
        }
    }

    private GridData getAlignmentData(int n, int n2) {
        GridData gridData = new GridData();
        gridData.minimumWidth = n;
        gridData.horizontalAlignment = n2;
        gridData.verticalAlignment = -1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        return gridData;
    }

    private void initButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout(2, false));
        composite2.setLayoutData(new GridData(0x1000008, 4, true, true));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        Button button = new Button(composite2, 8);
        button.setText(TuxGuitar.getProperty("ok"));
        button.setLayoutData(gridData);
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChangeTrackPropertiesAction.this.updateTrackProperties();
                new SyncThread(new Runnable(){

                    public void run() {
                        if (!TuxGuitar.isDisposed()) {
                            ChangeTrackPropertiesAction.this.updateTablature();
                            TuxGuitar.instance().getMixer().update();
                            ChangeTrackPropertiesAction.this.redraw();
                            ChangeTrackPropertiesAction.this.dialog.dispose();
                        }
                    }
                }).start();
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setText(TuxGuitar.getProperty("cancel"));
        button2.setLayoutData(gridData);
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChangeTrackPropertiesAction.this.dialog.dispose();
            }
        });
    }

    private void initInstrumentFields(Composite composite, SongTrackCoords songTrackCoords) {
        composite.setLayout(new GridLayout());
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout());
        composite2.setLayoutData(new GridData(4, 128, true, true));
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout(new GridLayout());
        composite3.setLayoutData(new GridData(4, 1024, true, true));
        Instrument[] instrumentArray = this.getInstruments();
        SongTrack songTrack = songTrackCoords.getTrack();
        Label label = new Label(composite2, 0);
        label.setText(TuxGuitar.getProperty("instrument.instrument") + ":");
        label.setLayoutData(new GridData(4, 0x1000000, true, true));
        this.instrumentCombo = new Combo(composite2, 12);
        this.instrumentCombo.setLayoutData(this.getAlignmentData(180, 4));
        if (instrumentArray != null) {
            int n = instrumentArray.length;
            if (n > 128) {
                n = 128;
            }
            for (int i = 0; i < n; ++i) {
                instrumentArray[i].getName();
                this.instrumentCombo.add(instrumentArray[i].getName());
            }
            this.instrumentCombo.select(songTrack.getChannel().getInstrument());
        }
        this.instrumentCombo.setEnabled(!songTrack.isPercussionTrack() && instrumentArray != null);
        this.percussionCheckBox = new Button(composite3, 32);
        this.percussionCheckBox.setText(TuxGuitar.getProperty("instrument.percussion-track"));
        this.percussionCheckBox.setLayoutData(new GridData(4, 0x1000000, true, true));
        if (instrumentArray != null) {
            this.percussionCheckBox.setSelection(songTrack.isPercussionTrack());
            this.percussionCheckBox.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ChangeTrackPropertiesAction.this.instrumentCombo.setEnabled(!ChangeTrackPropertiesAction.this.percussionCheckBox.getSelection());
                    ChangeTrackPropertiesAction.this.setDefaultTunning();
                    ChangeTrackPropertiesAction.this.updateTunningGroup(!ChangeTrackPropertiesAction.this.percussionCheckBox.getSelection());
                }
            });
        } else {
            this.percussionCheckBox.setEnabled(false);
        }
    }

    private Instrument[] getInstruments() {
        Instrument[] instrumentArray = null;
        Soundbank soundbank = TuxGuitar.instance().getPlayer().getSoundbank();
        if (soundbank != null) {
            instrumentArray = soundbank.getInstruments();
        }
        return instrumentArray;
    }

    private void updateTrackProperties() {
        int n;
        SongTrackCoords songTrackCoords = this.getEditor().getTablature().getCaret().getSongTrackCoords();
        String string = this.nameText.getText();
        RGBColor rGBColor = this.trackColor;
        ArrayList<InstrumentString> arrayList = new ArrayList<InstrumentString>();
        for (n = 0; n < this.stringCount; ++n) {
            arrayList.add(new InstrumentString(n + 1, this.stringCombos[n].getSelectionIndex()));
        }
        n = this.percussionCheckBox.getSelection() ? 1 : 0;
        int n2 = n != 0 ? 0 : -24 + this.offsetCombo.getSelectionIndex();
        int n3 = this.instrumentCombo.getSelectionIndex() >= 0 ? this.instrumentCombo.getSelectionIndex() : 0;
        boolean bl = this.hasInfoChanges(songTrackCoords, string, this.trackColor, n2);
        boolean bl2 = this.hasTunningChanges(songTrackCoords, arrayList);
        boolean bl3 = this.hasInstrumentChanges(songTrackCoords, n3, n != 0);
        if (bl || bl2 || bl3) {
            UndoableEdit undoableEdit;
            JoinedUndoable joinedUndoable = new JoinedUndoable();
            UndoableTrackGeneric undoableTrackGeneric = null;
            if (bl2) {
                undoableTrackGeneric = UndoableTrackGeneric.startUndo(songTrackCoords.getTrack());
            }
            if (bl) {
                undoableEdit = null;
                if (!bl2) {
                    undoableEdit = UndoableInfoTrack.startUndo(songTrackCoords.getTrack());
                }
                this.getEditor().getSongManager().getTrackManager().changeInfo(songTrackCoords.getTrack(), string, this.trackColor, n2);
                if (!bl2) {
                    joinedUndoable.addUndoableEdit(((UndoableInfoTrack)undoableEdit).endUndo(songTrackCoords.getTrack()));
                }
            }
            if (bl2) {
                this.getEditor().getSongManager().getTrackManager().changeInstrumentStrings(songTrackCoords.getTrack(), arrayList);
            }
            if (bl3) {
                undoableEdit = null;
                if (!bl2) {
                    undoableEdit = UndoableInstrumentTrack.startUndo(songTrackCoords.getTrack());
                }
                this.getEditor().getSongManager().getTrackManager().changeInstrument(songTrackCoords.getTrack(), n3, n != 0);
                if (!bl2) {
                    joinedUndoable.addUndoableEdit(((UndoableInstrumentTrack)undoableEdit).endUndo(songTrackCoords.getTrack()));
                }
            }
            if (bl2) {
                joinedUndoable.addUndoableEdit(undoableTrackGeneric.endUndo(songTrackCoords.getTrack()));
            }
            this.getEditor().getUndoManager().addEdit(joinedUndoable.endUndo());
            if (TuxGuitar.instance().getPlayer().isRunning()) {
                TuxGuitar.instance().getPlayer().updatePrograms();
            }
        }
    }

    private boolean hasInfoChanges(SongTrackCoords songTrackCoords, String string, RGBColor rGBColor, int n) {
        if (!string.equals(songTrackCoords.getTrack().getName())) {
            return true;
        }
        if (!rGBColor.isEqual(songTrackCoords.getTrack().getColor())) {
            return true;
        }
        return n != songTrackCoords.getTrack().getOffset();
    }

    private boolean hasTunningChanges(SongTrackCoords songTrackCoords, List list) {
        List list2 = songTrackCoords.getTrack().getStrings();
        if (list2.size() != list.size()) {
            return true;
        }
        for (int i = 0; i < list2.size(); ++i) {
            InstrumentString instrumentString = (InstrumentString)list2.get(i);
            boolean bl = false;
            for (int j = 0; j < list.size(); ++j) {
                InstrumentString instrumentString2 = (InstrumentString)list.get(j);
                if (!instrumentString2.isEqual(instrumentString)) continue;
                bl = true;
            }
            if (bl) continue;
            return true;
        }
        return false;
    }

    private boolean hasInstrumentChanges(SongTrackCoords songTrackCoords, int n, boolean bl) {
        return songTrackCoords.getTrack().getChannel().getInstrument() != n || songTrackCoords.getTrack().isPercussionTrack() != bl;
    }

    private void updateTunningGroup(boolean bl) {
        int n;
        for (n = 0; n < this.tempStrings.size(); ++n) {
            InstrumentString instrumentString = (InstrumentString)this.tempStrings.get(n);
            this.stringCombos[n].select(instrumentString.getValue());
            this.stringCombos[n].setVisible(true);
            this.stringCombos[n].setEnabled(bl);
        }
        for (n = this.tempStrings.size(); n < 7; ++n) {
            this.stringCombos[n].select(0);
            this.stringCombos[n].setVisible(false);
        }
        this.offsetCombo.setEnabled(bl);
    }

    private void initTempStrings(List list) {
        this.tempStrings = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            InstrumentString instrumentString = (InstrumentString)list.get(i);
            this.tempStrings.add(instrumentString.clone());
        }
    }

    private void setDefaultTunning() {
        this.tempStrings.clear();
        if (this.percussionCheckBox.getSelection()) {
            for (int i = 1; i <= this.stringCount; ++i) {
                this.tempStrings.add(new InstrumentString(i, 0));
            }
        } else {
            switch (this.stringCount) {
                case 7: {
                    this.tempStrings.add(new InstrumentString(1, 64));
                    this.tempStrings.add(new InstrumentString(2, 59));
                    this.tempStrings.add(new InstrumentString(3, 55));
                    this.tempStrings.add(new InstrumentString(4, 50));
                    this.tempStrings.add(new InstrumentString(5, 45));
                    this.tempStrings.add(new InstrumentString(6, 40));
                    this.tempStrings.add(new InstrumentString(7, 35));
                    break;
                }
                case 6: {
                    this.tempStrings.add(new InstrumentString(1, 64));
                    this.tempStrings.add(new InstrumentString(2, 59));
                    this.tempStrings.add(new InstrumentString(3, 55));
                    this.tempStrings.add(new InstrumentString(4, 50));
                    this.tempStrings.add(new InstrumentString(5, 45));
                    this.tempStrings.add(new InstrumentString(6, 40));
                    break;
                }
                case 5: {
                    this.tempStrings.add(new InstrumentString(1, 43));
                    this.tempStrings.add(new InstrumentString(2, 38));
                    this.tempStrings.add(new InstrumentString(3, 33));
                    this.tempStrings.add(new InstrumentString(4, 28));
                    this.tempStrings.add(new InstrumentString(5, 23));
                    break;
                }
                case 4: {
                    this.tempStrings.add(new InstrumentString(1, 43));
                    this.tempStrings.add(new InstrumentString(2, 38));
                    this.tempStrings.add(new InstrumentString(3, 33));
                    this.tempStrings.add(new InstrumentString(4, 28));
                }
            }
        }
    }

    private String[] getAllValueNames() {
        String[] stringArray = new String[120];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = NOTE_NAMES[i - i / 12 * 12] + i / 12;
        }
        return stringArray;
    }
}

