/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.track;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.SongCoords;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableAddTrack;
import org.herac.tuxguitar.song.models.SongTrack;

public class AddTrackAction
extends Action {
    public static final String NAME = "action.track.add";

    public AddTrackAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        UndoableAddTrack undoableAddTrack = UndoableAddTrack.startUndo();
        Caret caret = this.getEditor().getTablature().getCaret();
        SongCoords songCoords = caret.getSongCoords();
        SongTrack songTrack = this.getSongManager().createTrack();
        this.updateTablature();
        caret.update(songTrack.getNumber(), caret.getPosition(), 1);
        TuxGuitar.instance().getMixer().update();
        this.redraw();
        this.getEditor().getUndoManager().addEdit(undoableAddTrack.endUndo(songTrack));
        return true;
    }
}

