/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.note;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.Note;

public class IncrementNoteSemitoneAction
extends Action {
    public static final String NAME = "action.note.general.increment-semitone";

    public IncrementNoteSemitoneAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        Note note = this.getEditor().getTablature().getCaret().getSelectedNote();
        if (note != null) {
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            if (this.getSongManager().getMeasureManager().moveSemitoneUp(this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasure(), note.getStart(), note.getString())) {
                this.getEditor().getUndoManager().addEdit(undoableMeasureGeneric.endUndo());
            }
            this.updateTablature();
        }
        return true;
    }

    protected void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        this.redraw();
    }
}

