/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.note;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;

public class ChangeVelocityAction
extends Action {
    public static final String NAME = "action.note.general.velocity";

    public ChangeVelocityAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        if (typedEvent.widget.getData() instanceof Integer) {
            int n = (Integer)typedEvent.widget.getData();
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            Caret caret = this.getEditor().getTablature().getCaret();
            caret.setVelocity(n);
            this.getSongManager().getMeasureManager().changeVelocity(n, caret.getMeasureCoords().getMeasure(), caret.getPosition(), caret.getSelectedString().getNumber());
            this.updateTablature();
            this.getEditor().getUndoManager().addEdit(undoableMeasureGeneric.endUndo());
            return true;
        }
        return false;
    }

    protected void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        this.redraw();
    }
}

