/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.measure;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableAddMeasure;

public class AddMeasureAction
extends Action {
    public static final String NAME = "action.measure.add";
    private int selectedNumber;

    public AddMeasureAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        final int n = this.showDialog();
        if (n > 0 && n <= this.getSongManager().countMeasures() + 1) {
            new Thread(new Runnable(){

                public void run() {
                    new SyncThread(new Runnable(){

                        public void run() {
                            UndoableAddMeasure undoableAddMeasure = UndoableAddMeasure.startUndo(n);
                            AddMeasureAction.this.getSongManager().addNewMeasure(n);
                            AddMeasureAction.this.updateTablature();
                            int n = AddMeasureAction.this.getEditor().getTablature().getCaret().getSongTrackCoords().getTrack().getNumber();
                            int n2 = AddMeasureAction.this.getEditor().getTablature().getCaret().getStringNumber();
                            long l = AddMeasureAction.this.getSongManager().getMeasureHeader(n).getStart();
                            AddMeasureAction.this.getEditor().getTablature().getCaret().update(n, l, n2);
                            AddMeasureAction.this.getEditor().getUndoManager().addEdit(undoableAddMeasure.endUndo());
                            AddMeasureAction.this.redraw();
                            TuxGuitar.instance().updateCache(true);
                        }
                    }).start();
                }
            }).start();
        }
        return false;
    }

    public int showDialog() {
        this.selectedNumber = -1;
        if (this.getEditor().getTablature().getCaret().getMeasureCoords() != null) {
            Shell shell = TuxGuitar.instance().getShell();
            final Shell shell2 = new Shell(shell, 67680);
            shell2.setLayout(new GridLayout());
            shell2.setText(TuxGuitar.getProperty("measure.add"));
            Composite composite = new Composite(shell2, 0);
            composite.setLayout(new GridLayout());
            composite.setLayoutData(new GridData(4, 4, true, true));
            final Button button = new Button(composite, 16);
            button.setText(TuxGuitar.getProperty("measure.add-before-current-position"));
            final Button button2 = new Button(composite, 16);
            button2.setText(TuxGuitar.getProperty("measure.add-after-current-position"));
            final Button button3 = new Button(composite, 16);
            button3.setText(TuxGuitar.getProperty("measure.add-at-end"));
            button3.setSelection(true);
            Composite composite2 = new Composite(shell2, 0);
            composite2.setLayout(new GridLayout(2, false));
            composite2.setLayoutData(new GridData(0x1000008, 4, true, true));
            GridData gridData = new GridData(4, 4, true, true);
            gridData.minimumWidth = 80;
            gridData.minimumHeight = 25;
            Button button4 = new Button(composite2, 8);
            button4.setText(TuxGuitar.getProperty("ok"));
            button4.setLayoutData(gridData);
            button4.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (button.getSelection()) {
                        AddMeasureAction.this.selectedNumber = AddMeasureAction.this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber();
                    } else if (button2.getSelection()) {
                        AddMeasureAction.this.selectedNumber = AddMeasureAction.this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber() + 1;
                    } else if (button3.getSelection()) {
                        AddMeasureAction.this.selectedNumber = AddMeasureAction.this.getSongManager().countMeasures() + 1;
                    }
                    shell2.dispose();
                }
            });
            Button button5 = new Button(composite2, 8);
            button5.setText(TuxGuitar.getProperty("cancel"));
            button5.setLayoutData(gridData);
            button5.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.pack();
            shell2.open();
            int n = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
            int n2 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
            shell2.setLocation(n, n2);
            while (!shell2.isDisposed()) {
                if (shell2.getDisplay().readAndDispatch()) continue;
                shell2.getDisplay().sleep();
            }
        }
        return this.selectedNumber;
    }
}

