/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.File;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.FileChooser;

public class SaveAsFileAction
extends Action {
    public static final String NAME = "action.file.save-as";

    public SaveAsFileAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        Shell shell = this.getEditor().getTablature().getShell();
        String string = FileChooser.instance().save(shell, FileChooser.SAVE_FORMAT);
        if (string != null) {
            ConfirmDialog confirmDialog;
            String string2;
            File file;
            boolean bl = true;
            if (!this.isSuportedFormat(string)) {
                string = string + this.getDefaultExtension();
            }
            if ((file = new File(string2 = string)).exists() && !(confirmDialog = new ConfirmDialog(this.getEditor().getTablature().getShell(), TuxGuitar.getProperty("replace-file-question"))).confirm()) {
                bl = false;
            }
            if (bl) {
                this.getEditor().getTablature().changeCursor(1);
                new SyncThread(new Runnable(){

                    public void run() {
                        if (!TuxGuitar.isDisposed()) {
                            SaveAsFileAction.this.getEditor().getSongManager().save(string2);
                            TuxGuitar.instance().getFileHistory().setFile(string2);
                            TuxGuitar.instance().updateCache(true);
                            TuxGuitar.instance().showTitle();
                            SaveAsFileAction.this.getEditor().getTablature().changeCursor(0);
                        }
                    }
                }).start();
            }
        }
        return true;
    }

    private boolean isSuportedFormat(String string) {
        return string.endsWith(".tg") || string.endsWith(".gp3") || string.endsWith(".gp4");
    }

    private String getDefaultExtension() {
        return ".gp4";
    }
}

