/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import java.awt.print.PageFormat;
import java.net.URI;
import java.net.URISyntaxException;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PageRanges;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrinterData;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.PrinterViewLayout;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.printer.PrintDialog;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintDocumentData;
import org.herac.tuxguitar.gui.printer.PrintableImpl;
import org.herac.tuxguitar.gui.util.MessageDialog;

public class PrintAction
extends Action {
    public static final String NAME = "action.file.print";
    private static final double PAPER_MARGIN = 36.0;

    public PrintAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        PrintDocumentData printDocumentData;
        if (!TuxGuitar.isDisposed() && (printDocumentData = PrintDocumentData.openDialog(TuxGuitar.instance().getShell())) != null) {
            new SyncThread(new Runnable(){

                public void run() {
                    final PrinterData printerData = new PrintDialog(PrintAction.this.getEditor().getTablature().getShell()).open();
                    if (printerData != null) {
                        new SyncThread(new Runnable(){

                            public void run() {
                                try {
                                    PrintService printService = PrintAction.this.getPrintService(printerData);
                                    if (printService != null) {
                                        MediaSizeName mediaSizeName = MediaSizeName.ISO_A4;
                                        MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
                                        float f = mediaSize.getX(1000);
                                        float f2 = mediaSize.getY(1000);
                                        PageFormat pageFormat = new PageFormat();
                                        DocPrintJob docPrintJob = printService.createPrintJob();
                                        PrintDocument printDocument = PrintAction.this.makePrintDocument(pageFormat, printDocumentData);
                                        PrintableImpl printableImpl = new PrintableImpl(printDocument);
                                        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
                                        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
                                        hashPrintRequestAttributeSet.add(new Copies(printerData.copyCount));
                                        if (printerData.scope == 1) {
                                            printerData.startPage = printerData.startPage <= 0 ? 1 : printerData.startPage;
                                            printerData.startPage = printerData.startPage > printDocument.count() ? printDocument.count() : printerData.startPage;
                                            printerData.endPage = printerData.endPage < printerData.startPage ? printerData.startPage : printerData.endPage;
                                            printerData.endPage = printerData.endPage > printDocument.count() ? printDocument.count() : printerData.endPage;
                                            hashPrintRequestAttributeSet.add(new PageRanges(printerData.startPage, printerData.endPage));
                                        }
                                        if (printerData.printToFile && printerData.fileName != null && printerData.fileName.length() > 0) {
                                            hashPrintRequestAttributeSet.add(new Destination(new URI(printerData.fileName)));
                                        }
                                        SimpleDoc simpleDoc = new SimpleDoc(printableImpl, sERVICE_FORMATTED, null);
                                        docPrintJob.print(simpleDoc, hashPrintRequestAttributeSet);
                                    }
                                }
                                catch (PrintException printException) {
                                    printException.printStackTrace();
                                }
                                catch (URISyntaxException uRISyntaxException) {
                                    uRISyntaxException.printStackTrace();
                                }
                                catch (OutOfMemoryError outOfMemoryError) {
                                    PrintAction.this.showErrorMessage(outOfMemoryError);
                                }
                            }
                        }).start();
                    }
                }
            }).start();
        }
        return true;
    }

    public PrintService getPrintService(PrinterData printerData) {
        PrintService[] printServiceArray;
        if (printerData != null && printerData.name != null) {
            printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
            for (int i = 0; i < printServiceArray.length; ++i) {
                if (!printServiceArray[i].getName().equals(printerData.name)) continue;
                return printServiceArray[i];
            }
        }
        if ((printServiceArray = PrintServiceLookup.lookupDefaultPrintService()) != null) {
            return printServiceArray;
        }
        return null;
    }

    public PrintDocument makePrintDocument(PageFormat pageFormat, PrintDocumentData printDocumentData) {
        Tablature tablature = new Tablature(this.getEditor().getTablature(), 0);
        tablature.setSongManager(this.getEditor().getSongManager());
        tablature.reloadStyles();
        PrinterViewLayout printerViewLayout = new PrinterViewLayout(tablature, this.getEditor().getSongManager(), printDocumentData);
        tablature.setViewLayout(printerViewLayout);
        tablature.initDefaults();
        tablature.updateTablature();
        tablature.getCaret().update(this.getEditor().getTablature().getCaret().getSongTrackCoords().getTrack().getNumber());
        PrintDocument printDocument = printerViewLayout.makeDocument(new Rectangle(0, 0, (int)pageFormat.getImageableWidth() - 13, (int)pageFormat.getImageableHeight()));
        tablature.dispose();
        return printDocument;
    }

    private void showErrorMessage(final Error error) {
        new SyncThread(new Runnable(){

            public void run() {
                if (!TuxGuitar.isDisposed()) {
                    String string = error.getClass().getName();
                    String string2 = error.getMessage();
                    new MessageDialog(string, string2, 33).show(PrintAction.this.getEditor().getTablature().getShell());
                }
            }
        }).start();
    }
}

