/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.gui.util.MessageDialog;

public class OpenFileAction
extends Action {
    public static final String NAME = "action.file.open";
    private String fileName;

    public OpenFileAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(final TypedEvent typedEvent) {
        TuxGuitar.instance().getPlayer().reset();
        Shell shell = this.getEditor().getTablature().getShell();
        this.fileName = typedEvent.widget.getData() instanceof String ? (String)typedEvent.widget.getData() : FileChooser.instance().open(shell, FileChooser.OPEN_FORMAT);
        if (this.fileName != null) {
            this.getEditor().getTablature().changeCursor(1);
            new SyncThread(new Runnable(){

                public void run() {
                    if (!TuxGuitar.isDisposed()) {
                        try {
                            OpenFileAction.this.getEditor().getSongManager().open(OpenFileAction.this.fileName);
                            TuxGuitar.instance().getFileHistory().setFile(OpenFileAction.this.fileName);
                            TuxGuitar.instance().getTablatureEditor().resetDefaults();
                            TuxGuitar.instance().getMixer().update();
                            TuxGuitar.instance().getTableViewer().getTableInfo().fireUpdate();
                            TuxGuitar.instance().showTitle();
                            OpenFileAction.this.redraw();
                            OpenFileAction.this.getEditor().getTablature().changeCursor(0);
                        }
                        catch (Exception exception) {
                            OpenFileAction.this.showErrorMessage(OpenFileAction.this.fileName);
                            exception.printStackTrace();
                            TuxGuitar.instance().getAction("action.file.new").process(typedEvent);
                        }
                        catch (Error error) {
                            OpenFileAction.this.showErrorMessage(OpenFileAction.this.fileName);
                            error.printStackTrace();
                        }
                    }
                }
            }).start();
        }
        return true;
    }

    private void showErrorMessage(final String string) {
        new SyncThread(new Runnable(){

            public void run() {
                if (!TuxGuitar.isDisposed()) {
                    OpenFileAction.this.getEditor().getTablature().changeCursor(0);
                    String string3 = "Error Message";
                    String string2 = "Cannot Open file: " + string;
                    new MessageDialog(string3, string2, 33).show(OpenFileAction.this.getEditor().getTablature().getShell());
                }
            }
        }).start();
    }
}

