/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.io.importer.MidiImporter;
import org.herac.tuxguitar.song.models.Song;

public class ImportMidiAction
extends Action {
    public static final String NAME = "action.file.import-midi";

    public ImportMidiAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(final TypedEvent typedEvent) {
        TuxGuitar.instance().getPlayer().reset();
        Shell shell = this.getEditor().getTablature().getShell();
        final String string = FileChooser.instance().open(shell, FileChooser.IMPORT_MIDI_FORMAT);
        if (string != null) {
            this.getEditor().getTablature().changeCursor(1);
            new SyncThread(new Runnable(){

                public void run() {
                    if (!TuxGuitar.isDisposed()) {
                        try {
                            Song song = new MidiImporter().importSong(string);
                            TuxGuitar.instance().getSongManager().setSong(song);
                            ImportMidiAction.this.getEditor().resetDefaults();
                            TuxGuitar.instance().getMixer().update();
                            TuxGuitar.instance().getTableViewer().getTableInfo().fireUpdate();
                            ImportMidiAction.this.redraw();
                            ImportMidiAction.this.getEditor().getTablature().changeCursor(0);
                        }
                        catch (Exception exception) {
                            ImportMidiAction.this.showErrorMessage(string);
                            exception.printStackTrace();
                            TuxGuitar.instance().getAction("action.file.new").process(typedEvent);
                        }
                        catch (Error error) {
                            ImportMidiAction.this.showErrorMessage(string);
                            error.printStackTrace();
                        }
                    }
                }
            }).start();
        }
        return true;
    }

    private void showErrorMessage(final String string) {
        new SyncThread(new Runnable(){

            public void run() {
                if (!TuxGuitar.isDisposed()) {
                    ImportMidiAction.this.getEditor().getTablature().changeCursor(0);
                    String string3 = "Error Message";
                    String string2 = "Cannot Open file: " + string;
                    new MessageDialog(string3, string2, 33).show(ImportMidiAction.this.getEditor().getTablature().getShell());
                }
            }
        }).start();
    }
}

