/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.effects;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.effects.HarmonicEditor;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.effects.HarmonicEffect;

public class ChangeHarmonicNoteAction
extends Action {
    public static final String NAME = "action.note.effect.change-harmonic";

    public ChangeHarmonicNoteAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        Note note = this.getEditor().getTablature().getCaret().getSelectedNote();
        if (note != null) {
            this.changeHarmonic(new HarmonicEditor().show(note));
        }
        return true;
    }

    private void changeHarmonic(HarmonicEffect harmonicEffect) {
        UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
        Caret caret = this.getEditor().getTablature().getCaret();
        this.getSongManager().getMeasureManager().changeHarmonicNote(caret.getMeasureCoords().getMeasure(), caret.getPosition(), caret.getSelectedString().getNumber(), harmonicEffect);
        this.updateTablature();
        this.getEditor().getUndoManager().addEdit(undoableMeasureGeneric.endUndo());
    }

    protected void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        this.redraw();
    }
}

