/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.effects;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.effects.GraceEditor;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.effects.GraceEffect;

public class ChangeGraceNoteAction
extends Action {
    public static final String NAME = "action.note.effect.change-grace";

    public ChangeGraceNoteAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        Note note = this.getEditor().getTablature().getCaret().getSelectedNote();
        if (note != null) {
            this.changeGrace(new GraceEditor().show(note));
        }
        return true;
    }

    private void changeGrace(GraceEffect graceEffect) {
        UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
        Caret caret = this.getEditor().getTablature().getCaret();
        this.getSongManager().getMeasureManager().changeGraceNote(caret.getMeasureCoords().getMeasure(), caret.getPosition(), caret.getSelectedString().getNumber(), graceEffect);
        this.updateTablature();
        this.getEditor().getUndoManager().addEdit(undoableMeasureGeneric.endUndo());
    }

    protected void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        this.redraw();
    }
}

