/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.duration;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.Duration;

public class IncrementDurationAction
extends Action {
    public static final String NAME = "action.note.duration.increment-duration";

    public IncrementDurationAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
        Duration duration = this.getEditor().getTablature().getCaret().getDuration();
        if (duration.getValue() < 64) {
            this.changeDuration(duration.getValue() * 2);
            this.updateTablature();
        }
        this.getEditor().getUndoManager().addEdit(undoableMeasureGeneric.endUndo());
        return true;
    }

    private void changeDuration(int n) {
        Caret caret = this.getEditor().getTablature().getCaret();
        caret.getDuration().setValue(n);
        caret.getDuration().setDotted(false);
        caret.getDuration().setDoubleDotted(false);
        caret.changeDuration((Duration)caret.getDuration().clone());
    }

    protected void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        this.redraw();
    }
}

