/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.dispose;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.fretboard.FretBoard;
import org.herac.tuxguitar.gui.table.SongTableInfo;

public class DisposeAction
extends Action {
    public static final String NAME = "action.main.dispose";

    public DisposeAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.saveConfig();
        this.closeModules();
        this.dispose();
        return false;
    }

    private void saveConfig() {
        TuxGuitar.instance().getConfig().setProperty("layout.mode", this.getEditor().getTablature().getViewLayout().getMode());
        TuxGuitar.instance().getConfig().setProperty("show.score", this.getEditor().getTablature().getViewLayout().isScoreEnabled());
        TuxGuitar.instance().getConfig().setProperty("show.multitrack", this.getEditor().getTablature().getViewLayout().isMultitrack());
        TuxGuitar.instance().getConfig().setProperty("show.mixer", !TuxGuitar.instance().getMixer().isDisposed());
        TuxGuitar.instance().getConfig().setProperty("show.transport", !TuxGuitar.instance().getTransport().isDisposed());
        TuxGuitar.instance().getConfig().setProperty("show.fretboard", TuxGuitar.instance().getFretBoardEditor().isVisible());
        TuxGuitar.instance().getConfig().setProperty("show.piano", TuxGuitar.instance().getPianoEditor().isVisible());
        TuxGuitar.instance().getConfig().setProperty("window.maximized", TuxGuitar.instance().getShell().getMaximized());
        TuxGuitar.instance().getConfig().setProperty("window.width", TuxGuitar.instance().getShell().getClientArea().width);
        TuxGuitar.instance().getConfig().setProperty("window.height", TuxGuitar.instance().getShell().getClientArea().height);
        TuxGuitar.instance().getConfig().setProperty("editor.mouse.mode", this.getEditor().getTablature().getEditorKit().getMouseMode());
        TuxGuitar.instance().getConfig().setProperty("editor.natural.key.mode", this.getEditor().getTablature().getEditorKit().isNatural());
        TuxGuitar.instance().getConfig().save();
    }

    public void closeModules() {
        TuxGuitar.instance().getPlayer().close();
        TuxGuitar.instance().getPluginManager().closePLugins();
    }

    private void dispose() {
        TuxGuitar.instance().getTablatureEditor().getTablature().dispose();
        SystemImages.disposeImages();
        SongTableInfo.disposeColors();
        FretBoard.disposeColors();
    }
}

