/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.caret;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableAddMeasure;

public class GoRightAction
extends Action {
    public static final String NAME = "action.caret.go-right";

    public GoRightAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        Caret caret = this.getEditor().getTablature().getCaret();
        if (!caret.moveRight()) {
            int n = this.getSongManager().countMeasures() + 1;
            UndoableAddMeasure undoableAddMeasure = UndoableAddMeasure.startUndo(n);
            this.getSongManager().addNewMeasure(n);
            this.fireUpdate(n, true);
            caret.moveRight();
            this.getEditor().getUndoManager().addEdit(undoableAddMeasure.endUndo());
        }
        this.redraw();
        return true;
    }
}

